/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.cli.deployer.CommandFileCommandMetaData;
import org.apache.geronimo.cli.deployer.CommandMetaData;
import org.apache.geronimo.cli.deployer.ConnectionParams;
import org.apache.geronimo.cli.deployer.DeployCommandMetaData;
import org.apache.geronimo.cli.deployer.DeployerCLParser;
import org.apache.geronimo.cli.deployer.DistributeCommandMetaData;
import org.apache.geronimo.cli.deployer.EncryptCommandMetaData;
import org.apache.geronimo.cli.deployer.InstallLibraryCommandMetaData;
import org.apache.geronimo.cli.deployer.InstallPluginCommandMetaData;
import org.apache.geronimo.cli.deployer.ListModulesCommandMetaData;
import org.apache.geronimo.cli.deployer.ListTargetsCommandMetaData;
import org.apache.geronimo.cli.deployer.LoginCommandMetaData;
import org.apache.geronimo.cli.deployer.RedeployCommandMetaData;
import org.apache.geronimo.cli.deployer.RestartCommandMetaData;
import org.apache.geronimo.cli.deployer.SearchPluginsCommandMetaData;
import org.apache.geronimo.cli.deployer.StartCommandMetaData;
import org.apache.geronimo.cli.deployer.StopCommandMetaData;
import org.apache.geronimo.cli.deployer.UndeployCommandMetaData;
import org.apache.geronimo.cli.deployer.UnlockKeystoreCommandMetaData;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.CommandDeploy;
import org.apache.geronimo.deployment.cli.CommandDistribute;
import org.apache.geronimo.deployment.cli.CommandEncrypt;
import org.apache.geronimo.deployment.cli.CommandInstallCAR;
import org.apache.geronimo.deployment.cli.CommandInstallLibrary;
import org.apache.geronimo.deployment.cli.CommandListConfigurations;
import org.apache.geronimo.deployment.cli.CommandListModules;
import org.apache.geronimo.deployment.cli.CommandListTargets;
import org.apache.geronimo.deployment.cli.CommandLogin;
import org.apache.geronimo.deployment.cli.CommandRedeploy;
import org.apache.geronimo.deployment.cli.CommandRestart;
import org.apache.geronimo.deployment.cli.CommandStart;
import org.apache.geronimo.deployment.cli.CommandStop;
import org.apache.geronimo.deployment.cli.CommandUndeploy;
import org.apache.geronimo.deployment.cli.CommandUnlockKeystore;
import org.apache.geronimo.deployment.cli.DeployCommand;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.OfflineServerConnection;
import org.apache.geronimo.deployment.cli.OnlineServerConnection;
import org.apache.geronimo.deployment.cli.ServerConnection;
import org.apache.geronimo.deployment.cli.StreamConsoleReader;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.util.Main;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployTool
implements Main {
    private static final IdentityHashMap<CommandMetaData, DeployCommand> commands = new IdentityHashMap();
    private static final Logger log = LoggerFactory.getLogger(DeployTool.class);
    private boolean failed = false;
    String[] generalArgs = new String[0];
    ServerConnection con = null;
    private boolean multipleCommands = false;
    private final Kernel kernel;
    private final DeploymentFactory deploymentFactory;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_REF_DEPLOYMENT_FACTORY = "DeploymentFactory";

    public DeployTool(Kernel kernel, DeploymentFactory deploymentFactory) {
        if (null == kernel) {
            throw new IllegalArgumentException("kernel is required");
        }
        if (null == deploymentFactory) {
            throw new IllegalArgumentException("deploymentFactory is required");
        }
        this.kernel = kernel;
        this.deploymentFactory = deploymentFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Object opaque) {
        if (!(opaque instanceof DeployerCLParser)) {
            throw new IllegalArgumentException("Argument type is [" + opaque.getClass() + "]; expected [" + DeployerCLParser.class + "]");
        }
        DeployerCLParser parser = (DeployerCLParser)opaque;
        StreamConsoleReader consoleReader = new StreamConsoleReader(System.in, System.out);
        CommandMetaData commandMetaData = parser.getCommandMetaData();
        CommandArgs commandArgs = parser.getCommandArgs();
        if (commandMetaData == CommandFileCommandMetaData.META_DATA) {
            this.multipleCommands = true;
            String arg = commandArgs.getArgs()[0];
            File source = new File(arg);
            if (!source.exists() || !source.canRead() || source.isDirectory()) {
                this.processException((Exception)((Object)new DeploymentSyntaxException("Cannot read command file " + source.getAbsolutePath())));
            } else {
                try {
                    String line;
                    BufferedReader commands = new BufferedReader(new FileReader(source));
                    boolean oneFailed = false;
                    while ((line = commands.readLine()) != null) {
                        if ((line = line.trim()).equals("")) continue;
                        String[] lineArgs = DeployTool.splitCommand(line);
                        if (this.failed) {
                            oneFailed = true;
                        }
                        this.failed = false;
                        this.execute(lineArgs);
                    }
                    this.failed = oneFailed;
                }
                catch (IOException e) {
                    this.processException((Exception)((Object)new DeploymentException("Unable to read command file", (Throwable)e)));
                }
                finally {
                    try {
                        this.con.close();
                    }
                    catch (DeploymentException e) {
                        this.processException((Exception)((Object)e));
                    }
                }
            }
        } else {
            DeployCommand dc = commands.get(commandMetaData);
            if (dc == null) {
                try {
                    consoleReader.printNewline();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.processException((Exception)((Object)new DeploymentSyntaxException("No such command: '" + commandMetaData + "'")));
            } else {
                try {
                    if (this.con == null) {
                        this.con = parser.isOffline() ? new OfflineServerConnection(this.kernel, true) : new OnlineServerConnection((ConnectionParams)parser, consoleReader, this.deploymentFactory);
                    }
                    try {
                        dc.execute(consoleReader, this.con, commandArgs);
                    }
                    catch (DeploymentSyntaxException e) {
                        this.processException((Exception)((Object)e));
                    }
                    catch (DeploymentException e) {
                        this.processException((Exception)((Object)e));
                    }
                    finally {
                        if (!this.multipleCommands) {
                            try {
                                this.con.close();
                            }
                            catch (DeploymentException e) {
                                this.processException((Exception)((Object)e));
                            }
                        }
                    }
                }
                catch (DeploymentException e) {
                    this.processException((Exception)((Object)e));
                }
            }
        }
        try {
            consoleReader.flushConsole();
        }
        catch (IOException e) {
            // empty catch block
        }
        return this.failed ? 1 : 0;
    }

    public static String[] splitCommand(String line) {
        String[] chunks = line.split("\"");
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < chunks.length; ++i) {
            String chunk = chunks[i];
            if (i % 2 == 1) {
                list.add(chunk);
                continue;
            }
            list.addAll(Arrays.asList(chunk.split("\\s")));
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String test = (String)it.next();
            if (!test.trim().equals("")) continue;
            it.remove();
        }
        return list.toArray(new String[list.size()]);
    }

    private void processException(Exception e) {
        this.failed = true;
        log.error("Error: ", (Throwable)e);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        commands.put(LoginCommandMetaData.META_DATA, new CommandLogin());
        commands.put(DeployCommandMetaData.META_DATA, new CommandDeploy());
        commands.put(DistributeCommandMetaData.META_DATA, new CommandDistribute());
        commands.put(ListModulesCommandMetaData.META_DATA, new CommandListModules());
        commands.put(ListTargetsCommandMetaData.META_DATA, new CommandListTargets());
        commands.put(RedeployCommandMetaData.META_DATA, new CommandRedeploy());
        commands.put(StartCommandMetaData.META_DATA, new CommandStart());
        commands.put(StopCommandMetaData.META_DATA, new CommandStop());
        commands.put(RestartCommandMetaData.META_DATA, new CommandRestart());
        commands.put(UndeployCommandMetaData.META_DATA, new CommandUndeploy());
        commands.put(SearchPluginsCommandMetaData.META_DATA, new CommandListConfigurations());
        commands.put(InstallPluginCommandMetaData.META_DATA, new CommandInstallCAR());
        commands.put(InstallLibraryCommandMetaData.META_DATA, new CommandInstallLibrary());
        commands.put(EncryptCommandMetaData.META_DATA, new CommandEncrypt());
        commands.put(UnlockKeystoreCommandMetaData.META_DATA, new CommandUnlockKeystore());
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"DeployTool", DeployTool.class, (String)"DeployTool");
        infoBuilder.addReference(GBEAN_REF_DEPLOYMENT_FACTORY, DeploymentFactory.class);
        infoBuilder.addInterface(Main.class);
        infoBuilder.setConstructor(new String[]{"kernel", GBEAN_REF_DEPLOYMENT_FACTORY});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

