/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.ConsoleReader;
import org.apache.geronimo.deployment.cli.DeployCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;

public abstract class AbstractCommand
implements DeployCommand {
    @Override
    public boolean isLocalOnly() {
        return false;
    }

    protected void emit(ConsoleReader out, String message) throws IOException {
        out.printString(DeployUtils.reformat(message, 4, 72));
        out.flushConsole();
    }

    protected void waitForProgress(final ConsoleReader out, ProgressObject po) {
        po.addProgressListener(new ProgressListener(){
            String last = null;

            public void handleProgressEvent(ProgressEvent event) {
                String msg = event.getDeploymentStatus().getMessage();
                if (this.last != null && !this.last.equals(msg)) {
                    try {
                        AbstractCommand.this.emit(out, this.last);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.last = msg;
            }
        });
        while (po.getDeploymentStatus().isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                try {
                    out.println(e.getMessage());
                }
                catch (IOException e1) {}
            }
        }
    }

    protected static boolean isMultipleTargets(TargetModuleID[] ids) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            TargetModuleID id = ids[i];
            set.add(id.getTarget().getName());
        }
        return set.size() > 1;
    }

    protected static Target[] identifyTargets(List<String> targetNames, DeploymentManager mgr) throws DeploymentException {
        Target[] tlist = new Target[targetNames.size()];
        Target[] all = mgr.getTargets();
        HashSet<String> found = new HashSet<String>();
        for (int i = 0; i < tlist.length; ++i) {
            for (int j = 0; j < all.length; ++j) {
                Target server = all[j];
                if (!server.getName().equals(targetNames.get(i)) && server.getName().indexOf(targetNames.get(i).toString()) <= -1) continue;
                tlist[i] = server;
                if (found.contains(server.getName())) {
                    throw new DeploymentException("Target list should not contain duplicates or nicknames that match duplicates (" + targetNames.get(i) + ")");
                }
                found.add(server.getName());
                break;
            }
            if (tlist[i] != null) continue;
            throw new DeploymentException("No target named or matching '" + targetNames.get(i) + "' was found");
        }
        return tlist;
    }
}

