/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.File;
import javax.enterprise.deploy.spi.DeploymentManager;
import jline.ConsoleReader;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.cli.deployer.InstallLibraryCommandArgs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.ServerConnection;
import org.apache.geronimo.deployment.plugin.GeronimoDeploymentManager;
import org.apache.geronimo.kernel.repository.Artifact;

public class CommandInstallLibrary
extends AbstractCommand {
    public void execute(ConsoleReader consoleReader, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        if (!(commandArgs instanceof InstallLibraryCommandArgs)) {
            throw new DeploymentSyntaxException("CommandArgs has the type [" + commandArgs.getClass() + "]; expected [" + InstallLibraryCommandArgs.class + "]");
        }
        InstallLibraryCommandArgs installLibraryCommandArgs = (InstallLibraryCommandArgs)commandArgs;
        if (installLibraryCommandArgs.getArgs().length == 0) {
            throw new DeploymentException("Must specify a LibraryFile");
        }
        File libFile = new File(installLibraryCommandArgs.getArgs()[0]);
        if (!(libFile.exists() && libFile.isFile() && libFile.canRead())) {
            throw new DeploymentException("File does not exist or not a normal file or not readable. " + libFile);
        }
        DeploymentManager dmgr = connection.getDeploymentManager();
        if (dmgr instanceof GeronimoDeploymentManager) {
            GeronimoDeploymentManager mgr = (GeronimoDeploymentManager)dmgr;
            String groupId = installLibraryCommandArgs.getGroupId();
            try {
                Artifact artifact = mgr.installLibrary(libFile, groupId);
                if (artifact == null) {
                    throw new DeploymentException("Unable to install library " + installLibraryCommandArgs.getArgs()[0]);
                }
                consoleReader.printString(DeployUtils.reformat("Installed " + artifact, 4, 72));
            }
            catch (Exception e) {
                throw new DeploymentException("Unable to install library " + installLibraryCommandArgs.getArgs()[0], (Throwable)e);
            }
        } else {
            throw new DeploymentException("Cannot install library using " + dmgr.getClass().getName() + " deployment manager");
        }
    }
}

