/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.util;

import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;

public class UnpackedJarEntry
extends JarEntry {
    private final File file;
    private final Manifest manifest;

    public UnpackedJarEntry(String name, File file, Manifest manifest) {
        super(name);
        this.file = file;
        this.manifest = manifest;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public Attributes getAttributes() throws IOException {
        if (this.manifest == null) {
            return null;
        }
        return this.manifest.getAttributes(this.getName());
    }

    @Override
    public Certificate[] getCertificates() {
        return null;
    }

    @Override
    public void setTime(long time) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Can not change the time of unpacked jar entry");
    }

    @Override
    public long getTime() {
        return this.file.lastModified();
    }

    @Override
    public void setSize(long size) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Can not change the size of unpacked jar entry");
    }

    @Override
    public long getSize() {
        if (this.file.isDirectory()) {
            return -1L;
        }
        return this.file.length();
    }

    @Override
    public long getCompressedSize() {
        return this.getSize();
    }

    @Override
    public void setCompressedSize(long compressedSize) {
        throw new UnsupportedOperationException("Can not change the compressed size of unpacked jar entry");
    }

    @Override
    public long getCrc() {
        return super.getCrc();
    }

    @Override
    public void setCrc(long crc) {
        throw new UnsupportedOperationException("Can not change the crc of unpacked jar entry");
    }

    @Override
    public int getMethod() {
        return 0;
    }

    @Override
    public void setMethod(int method) {
        throw new UnsupportedOperationException("Can not change the method of unpacked jar entry");
    }

    @Override
    public byte[] getExtra() {
        return null;
    }

    @Override
    public void setExtra(byte[] extra) {
        throw new UnsupportedOperationException("Can not change the extra data of unpacked jar entry");
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public void setComment(String comment) {
        throw new UnsupportedOperationException("Can not change the comment of unpacked jar entry");
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public Object clone() {
        return new UnpackedJarEntry(this.getName(), this.file, this.manifest);
    }
}

