/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.geronimo.kernel.config.LifecycleMonitor;
import org.apache.geronimo.kernel.repository.Artifact;

public class RecordingLifecycleMonitor
implements LifecycleMonitor {
    private final List<Event> events = new ArrayList<Event>();

    @Override
    public void addConfiguration(Artifact configurationId) {
        this.events.add(new Event(Action.ADD, configurationId));
    }

    @Override
    public void resolving(Artifact configurationId) {
        this.events.add(new Event(Action.RESOLVING, configurationId));
    }

    @Override
    public void reading(Artifact configurationId) {
        this.events.add(new Event(Action.READING, configurationId));
    }

    @Override
    public void loading(Artifact configurationId) {
        this.events.add(new Event(Action.LOADING, configurationId));
    }

    @Override
    public void starting(Artifact configurationId) {
        this.events.add(new Event(Action.STARTING, configurationId));
    }

    @Override
    public void stopping(Artifact configurationId) {
        this.events.add(new Event(Action.STOPPING, configurationId));
    }

    @Override
    public void unloading(Artifact configurationId) {
        this.events.add(new Event(Action.UNLOADING, configurationId));
    }

    @Override
    public void succeeded(Artifact configurationId) {
        this.events.add(new Event(Action.SUCCEEDED, configurationId));
    }

    @Override
    public void failed(Artifact configurationId, Throwable cause) {
        this.events.add(new FailedEvent(configurationId, cause));
    }

    @Override
    public void finished() {
        this.events.add(new Event(Action.FINISHED, null));
    }

    public List<Event> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Event event : this.events) {
            buf.append(event.toString()).append("\n");
        }
        return buf.toString();
    }

    private static class FailedEvent
    extends Event {
        private final Throwable cause;

        private FailedEvent(Artifact artifact, Throwable cause) {
            super(Action.FAILED, artifact);
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }

        @Override
        public String toString() {
            return super.toString() + ": " + this.cause.getMessage();
        }
    }

    private static class Event {
        private final Action action;
        private final Artifact artifact;

        private Event(Action action, Artifact artifact) {
            this.action = action;
            this.artifact = artifact;
        }

        public Action getAction() {
            return this.action;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public String toString() {
            if (this.artifact == null) {
                return this.action.toString();
            }
            return this.artifact.toString() + ": " + this.action.toString();
        }
    }

    private static enum Action {
        ADD,
        RESOLVING,
        READING,
        LOADING,
        STARTING,
        STOPPING,
        UNLOADING,
        SUCCEEDED,
        FAILED,
        FINISHED;

    }
}

