/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import org.apache.geronimo.kernel.config.LifecycleResults;
import org.apache.geronimo.kernel.repository.Artifact;

public class LifecycleException
extends Exception {
    private final String command;
    private final Artifact configurationId;
    private final LifecycleResults lifecycleResults;

    public LifecycleException(String command, Artifact configurationId, Throwable cause) {
        this(command, configurationId, new LifecycleResults(), cause);
        this.lifecycleResults.addFailed(configurationId, cause);
    }

    public LifecycleException(String command, Artifact configurationId, LifecycleResults lifecycleResults) {
        this(command, configurationId, lifecycleResults, lifecycleResults.getFailedCause(configurationId));
    }

    public LifecycleException(String command, Artifact configurationId, LifecycleResults lifecycleResults, Throwable cause) {
        super(command + " of " + configurationId + " failed", cause);
        this.command = command;
        this.configurationId = configurationId;
        this.lifecycleResults = lifecycleResults;
    }

    public String getCommand() {
        return this.command;
    }

    public Artifact getConfigurationId() {
        return this.configurationId;
    }

    public LifecycleResults getLifecycleResults() {
        return this.lifecycleResults;
    }
}

