/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfoFactoryException;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.MultiGBeanInfoFactory;
import org.apache.geronimo.kernel.management.NotificationType;
import org.osgi.framework.Bundle;

public final class GBeanInfo
implements Serializable {
    private static final long serialVersionUID = -6198804067155550221L;
    public static final int PRIORITY_CLASSLOADER = 1;
    public static final int PRIORITY_NORMAL = 5;
    private static final Set<String> DEFAULT_NOTIFICATIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(NotificationType.TYPES)));
    private final String sourceClass;
    private final String name;
    private final String className;
    private final String j2eeType;
    private final Set<GAttributeInfo> attributes;
    private final Map<String, GAttributeInfo> attributesByName;
    private final GConstructorInfo constructor;
    private final Set<GOperationInfo> operations;
    private final Set<String> notifications;
    private final Set<GReferenceInfo> references;
    private final Map<String, GReferenceInfo> referencesByName;
    private final Set<String> interfaces;
    private final int priority;
    private final boolean osgiService;
    private final String[] serviceInterfaces;

    public static GBeanInfo getGBeanInfo(String className, Bundle bundle) throws InvalidConfigurationException {
        MultiGBeanInfoFactory infoFactory = new MultiGBeanInfoFactory();
        try {
            return infoFactory.getGBeanInfo(className, bundle);
        }
        catch (GBeanInfoFactoryException e) {
            throw new InvalidConfigurationException("See nested", e);
        }
    }

    public GBeanInfo(String name, String className, String j2eeType, Collection attributes, GConstructorInfo constructor, Collection operations, Set references, Set interfaces) {
        this(null, name, className, j2eeType, attributes, constructor, operations, references, interfaces, DEFAULT_NOTIFICATIONS, 5, false, null);
    }

    public GBeanInfo(String className, String j2eeType, Collection attributes, GConstructorInfo constructor, Collection operations, Set references, Set interfaces) {
        this(null, className, className, j2eeType, attributes, constructor, operations, references, interfaces, DEFAULT_NOTIFICATIONS, 5, false, null);
    }

    public GBeanInfo(String className, String j2eeType, Collection attributes, GConstructorInfo constructor, Collection operations, Set references, Set interfaces, Set notifications) {
        this(null, className, className, j2eeType, attributes, constructor, operations, references, interfaces, notifications, 5, false, null);
    }

    public GBeanInfo(String name, String className, String j2eeType, Collection attributes, GConstructorInfo constructor, Collection operations, Set references, Set interfaces, Set notifications) {
        this(null, name, className, j2eeType, attributes, constructor, operations, references, interfaces, notifications, 5, false, null);
    }

    public GBeanInfo(String sourceClass, String name, String className, String j2eeType, Collection attributes, GConstructorInfo constructor, Collection operations, Set references, Set interfaces, int priority, boolean osgiService, String[] serviceInterfaces) {
        this(sourceClass, name, className, j2eeType, attributes, constructor, operations, references, interfaces, DEFAULT_NOTIFICATIONS, priority, osgiService, serviceInterfaces);
    }

    GBeanInfo(String sourceClass, String name, String className, String j2eeType, Collection<GAttributeInfo> attributes, GConstructorInfo constructor, Collection<GOperationInfo> operations, Set<GReferenceInfo> references, Set<String> interfaces, Set<String> notifications, int priority, boolean osgiService, String[] serviceInterfaces) {
        HashMap<String, Serializable> map;
        this.sourceClass = sourceClass;
        this.name = name;
        this.className = className;
        this.j2eeType = j2eeType;
        if (attributes == null) {
            this.attributes = Collections.emptySet();
            this.attributesByName = Collections.emptyMap();
        } else {
            map = new HashMap<String, Serializable>();
            for (GAttributeInfo attribute : attributes) {
                map.put(attribute.getName(), attribute);
            }
            this.attributesByName = Collections.unmodifiableMap(map);
            this.attributes = Collections.unmodifiableSet(new HashSet(map.values()));
        }
        this.constructor = constructor == null ? new GConstructorInfo(Collections.emptyList()) : constructor;
        this.operations = operations == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<GOperationInfo>(operations));
        if (references == null) {
            this.references = Collections.emptySet();
            this.referencesByName = Collections.emptyMap();
        } else {
            map = new HashMap();
            for (GReferenceInfo reference : references) {
                map.put(reference.getName(), reference);
            }
            this.referencesByName = Collections.unmodifiableMap(map);
            this.references = Collections.unmodifiableSet(new HashSet<GReferenceInfo>(references));
        }
        this.interfaces = interfaces == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet<String>(interfaces));
        this.notifications = notifications == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet<String>(notifications));
        this.priority = priority;
        this.osgiService = osgiService;
        this.serviceInterfaces = serviceInterfaces == null ? new String[]{} : serviceInterfaces;
    }

    public String getSourceClass() {
        return this.sourceClass;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getJ2eeType() {
        return this.j2eeType;
    }

    public GAttributeInfo getAttribute(String name) {
        return this.attributesByName.get(name);
    }

    public Set<GAttributeInfo> getAttributes() {
        return this.attributes;
    }

    public List getPersistentAttributes() {
        ArrayList<GAttributeInfo> attrs = new ArrayList<GAttributeInfo>();
        for (GAttributeInfo info : this.attributes) {
            if (!info.isPersistent()) continue;
            attrs.add(info);
        }
        return attrs;
    }

    public List getManageableAttributes() {
        ArrayList<GAttributeInfo> attrs = new ArrayList<GAttributeInfo>();
        for (GAttributeInfo info : this.attributes) {
            if (!info.isManageable()) continue;
            attrs.add(info);
        }
        return attrs;
    }

    public GConstructorInfo getConstructor() {
        return this.constructor;
    }

    public Set<GOperationInfo> getOperations() {
        return this.operations;
    }

    public Set getNotifications() {
        return this.notifications;
    }

    public Set<GReferenceInfo> getReferences() {
        return this.references;
    }

    public GReferenceInfo getReference(String name) {
        return this.referencesByName.get(name);
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isOsgiService() {
        return this.osgiService;
    }

    public String[] getServiceInterfaces() {
        return this.serviceInterfaces;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[GBeanInfo:");
        result.append(" id=").append(super.toString());
        result.append(" sourceClass=").append(this.sourceClass);
        result.append(" name=").append(this.name);
        for (GAttributeInfo geronimoAttributeInfo : this.attributes) {
            result.append("\n    attribute: ").append(geronimoAttributeInfo);
        }
        for (GOperationInfo geronimoOperationInfo : this.operations) {
            result.append("\n    operation: ").append(geronimoOperationInfo);
        }
        for (GReferenceInfo referenceInfo : this.references) {
            result.append("\n    reference: ").append(referenceInfo);
        }
        result.append("]");
        return result.toString();
    }

    public String toXML(AbstractName abstractName) {
        StringBuilder xml = new StringBuilder();
        xml.append("<gBeanInfo ");
        xml.append("id='" + super.toString() + "' ");
        xml.append("sourceClass='" + this.sourceClass + "' ");
        xml.append("name='" + this.name + "' ");
        xml.append("className='" + this.className + "' ");
        xml.append("type='" + this.j2eeType + "' ");
        xml.append("priority='" + this.priority + "' ");
        xml.append(">");
        xml.append("<attributes>");
        Iterator<Object> loop = this.attributes.iterator();
        while (loop.hasNext()) {
            xml.append(loop.next().toXML(abstractName));
        }
        xml.append("</attributes>");
        xml.append(this.constructor.toXML());
        xml.append("<operations>");
        loop = this.operations.iterator();
        while (loop.hasNext()) {
            xml.append(((GOperationInfo)loop.next()).toXML());
        }
        xml.append("</operations>");
        xml.append("<notifications>");
        for (Object object : this.notifications) {
            xml.append("<notification>" + object + "</notification>");
        }
        xml.append("</notifications>");
        xml.append("<references>");
        loop = this.references.iterator();
        while (loop.hasNext()) {
            xml.append(((GReferenceInfo)loop.next()).toXML());
        }
        xml.append("</references>");
        xml.append("</gBeanInfo>");
        return xml.toString();
    }
}

