/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.io.Serializable;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.annotation.EncryptionSetting;
import org.apache.geronimo.kernel.KernelRegistry;

public class GAttributeInfo
implements Serializable {
    private static final long serialVersionUID = 2805493042418685048L;
    private final String name;
    private final String type;
    private final boolean persistent;
    private final boolean manageable;
    private final EncryptionSetting encrypted;
    private final boolean readable;
    private final boolean writable;
    private final String getterName;
    private final String setterName;

    public GAttributeInfo(String name, String type, boolean persistent, boolean manageable, String getterName, String setterName) {
        this(name, type, persistent, manageable, getterName != null, setterName != null, getterName, setterName);
    }

    public GAttributeInfo(String name, String type, boolean persistent, boolean manageable, boolean readable, boolean writable, String getterName, String setterName) {
        this(name, type, persistent, manageable, EncryptionSetting.defaultEncryption(name, type), readable, writable, getterName, setterName);
    }

    public GAttributeInfo(String name, String type, boolean persistent, boolean manageable, boolean encrypted, String getterName, String setterName) {
        this(name, type, persistent, manageable, encrypted ? EncryptionSetting.ENCRYPTED : EncryptionSetting.PLAINTEXT, getterName != null, setterName != null, getterName, setterName);
    }

    public GAttributeInfo(String name, String type, boolean persistent, boolean manageable, EncryptionSetting encrypted, String getterName, String setterName) {
        this(name, type, persistent, manageable, encrypted, getterName != null, setterName != null, getterName, setterName);
    }

    public GAttributeInfo(String name, String type, boolean persistent, boolean manageable, EncryptionSetting encrypted, boolean readable, boolean writable, String getterName, String setterName) {
        if (encrypted == null) {
            throw new NullPointerException("enctryption must be specified");
        }
        if (encrypted == EncryptionSetting.ENCRYPTED && !"java.lang.String".equals(type)) {
            throw new IllegalArgumentException("Only attributes of String type can be encrypted.");
        }
        if (encrypted == EncryptionSetting.DEFAULT) {
            encrypted = EncryptionSetting.defaultEncryption(name, type);
        }
        this.name = name;
        this.type = type;
        this.persistent = persistent;
        this.manageable = manageable & persistent;
        this.encrypted = encrypted;
        this.readable = readable;
        this.writable = writable;
        this.getterName = getterName;
        this.setterName = setterName;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isManageable() {
        return this.manageable;
    }

    public boolean isEncrypted() {
        return this.encrypted == EncryptionSetting.ENCRYPTED;
    }

    public EncryptionSetting getEncryptedSetting() {
        return this.encrypted;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public String getGetterName() {
        return this.getterName;
    }

    public String getSetterName() {
        return this.setterName;
    }

    public String toString() {
        return "[GAttributeInfo: name=" + this.name + " type=" + this.type + " persistent=" + this.persistent + " manageable=" + this.manageable + " encrypted=" + (Object)((Object)this.encrypted) + " readable=" + this.readable + " writable=" + this.writable + " getterName=" + this.getterName + " setterName=" + this.setterName + "]";
    }

    public String toXML(AbstractName abstractName) {
        StringBuilder xml = new StringBuilder();
        xml.append("<gAttributeInfo ");
        xml.append("name='").append(this.name).append("' ");
        xml.append("type='").append(this.type).append("' ");
        xml.append("persistent='").append(this.persistent).append("' ");
        xml.append("manageable='").append(this.manageable).append("' ");
        xml.append("encrypted='").append((Object)this.encrypted).append("' ");
        xml.append("readable='").append(this.readable).append("' ");
        xml.append("writable='").append(this.writable).append("' ");
        xml.append(">");
        xml.append("<getterName>").append(this.getterName).append("</getterName>");
        xml.append("<setterName>").append(this.setterName).append("</setterName>");
        if (this.readable) {
            try {
                Object value = KernelRegistry.getSingleKernel().getAttribute(abstractName, this.name);
                if (value != null) {
                    if (value instanceof String[]) {
                        for (String valueString : (String[])value) {
                            xml.append("<value>").append(valueString).append("</value>");
                        }
                    } else {
                        value = this.encrypted.encrypt((String)value);
                        xml.append("<value>").append(value).append("</value>");
                    }
                }
            }
            catch (Exception e) {
                xml.append("<value>[could not be determined:").append(e.getMessage()).append("]</value>");
            }
        }
        xml.append("</gAttributeInfo>");
        return xml.toString();
    }
}

