/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.runtime;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.GOperationSignature;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.gbean.runtime.GBeanAttribute;
import org.apache.geronimo.gbean.runtime.GBeanCollectionReference;
import org.apache.geronimo.gbean.runtime.GBeanDependency;
import org.apache.geronimo.gbean.runtime.GBeanInstanceState;
import org.apache.geronimo.gbean.runtime.GBeanOperation;
import org.apache.geronimo.gbean.runtime.GBeanReference;
import org.apache.geronimo.gbean.runtime.GBeanSingleReference;
import org.apache.geronimo.gbean.runtime.InstanceRegistry;
import org.apache.geronimo.gbean.runtime.LifecycleBroadcaster;
import org.apache.geronimo.gbean.runtime.RawInvoker;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.NoSuchAttributeException;
import org.apache.geronimo.kernel.NoSuchOperationException;
import org.apache.geronimo.kernel.config.ManageableAttributeStore;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.kernel.management.StateManageable;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.xbean.osgi.bundle.util.BundleClassLoader;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GBeanInstance
implements StateManageable {
    private static final Logger log = LoggerFactory.getLogger(GBeanInstance.class);
    private static final int DESTROYED = 0;
    private static final int CREATING = 1;
    private static final int RUNNING = 2;
    private static final int DESTROYING = 3;
    public static final String RAW_INVOKER = "$$RAW_INVOKER$$";
    private final Kernel kernel;
    private ManageableAttributeStore manageableStore;
    private final AbstractName abstractName;
    private final GBeanInstanceState gbeanInstanceState;
    private final ObjectRecipe objectRecipe;
    private final RawInvoker rawInvoker;
    private final LifecycleBroadcaster lifecycleBroadcaster;
    private final String[] interfaces;
    private final GBeanAttribute[] attributes;
    private final Map<String, Integer> attributeIndex = new HashMap<String, Integer>();
    private final GBeanReference[] references;
    private final Map<String, Integer> referenceIndex = new HashMap<String, Integer>();
    private final GBeanDependency[] dependencies;
    private final GBeanOperation[] operations;
    private final Map<GOperationSignature, Integer> operationIndex = new HashMap<GOperationSignature, Integer>();
    private final ClassLoader classLoader;
    private final BundleContext bundleContext;
    private final GBeanInfo gbeanInfo;
    private final String name;
    private final Class type;
    private boolean dead = false;
    private int instanceState = 0;
    private Object target;
    private long startTime;
    private boolean shouldFail = false;
    private InstanceRegistry instanceRegistry;
    private String stateReason;

    public GBeanInstance(GBeanData gbeanData, Kernel kernel, DependencyManager dependencyManager, LifecycleBroadcaster lifecycleBroadcaster, BundleContext bundleContext) throws InvalidConfigurationException {
        int i;
        this.abstractName = gbeanData.getAbstractName();
        this.kernel = kernel;
        this.lifecycleBroadcaster = lifecycleBroadcaster;
        this.gbeanInstanceState = new GBeanInstanceState(this.abstractName, kernel, dependencyManager, this, lifecycleBroadcaster);
        this.bundleContext = bundleContext;
        this.classLoader = new BundleClassLoader(bundleContext.getBundle());
        GBeanInfo gbeanInfo = gbeanData.getGBeanInfo();
        try {
            this.type = bundleContext.getBundle().loadClass(gbeanInfo.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load GBeanInfo class from classloader: " + bundleContext + " className=" + gbeanInfo.getClassName(), e);
        }
        this.name = gbeanInfo.getName();
        this.interfaces = gbeanInfo.getInterfaces().toArray(new String[0]);
        this.attributes = this.buildAttributes(gbeanInfo);
        for (int i2 = 0; i2 < this.attributes.length; ++i2) {
            this.attributeIndex.put(this.attributes[i2].getName(), new Integer(i2));
        }
        HashSet<GBeanReference> referencesSet = new HashSet<GBeanReference>();
        HashSet<GBeanDependency> dependencySet = new HashSet<GBeanDependency>();
        this.buildReferencesAndDependencies(gbeanData, gbeanInfo, referencesSet, dependencySet);
        this.references = referencesSet.toArray(new GBeanReference[referencesSet.size()]);
        for (int i3 = 0; i3 < this.references.length; ++i3) {
            this.referenceIndex.put(this.references[i3].getName(), new Integer(i3));
        }
        for (ReferencePatterns referencePatterns : gbeanData.getDependencies()) {
            AbstractName dependencyName = referencePatterns.getAbstractName();
            dependencySet.add(new GBeanDependency(this, dependencyName, kernel));
        }
        this.dependencies = dependencySet.toArray(new GBeanDependency[dependencySet.size()]);
        HashMap<GOperationSignature, GBeanOperation> operationsMap = new HashMap<GOperationSignature, GBeanOperation>();
        for (GOperationInfo operationInfo : gbeanInfo.getOperations()) {
            GOperationSignature signature = new GOperationSignature(operationInfo.getName(), operationInfo.getParameterList());
            if (operationsMap.containsKey(signature)) continue;
            GBeanOperation operation = new GBeanOperation(this, operationInfo);
            operationsMap.put(signature, operation);
        }
        this.operations = new GBeanOperation[operationsMap.size()];
        int opCounter = 0;
        for (Map.Entry entry : operationsMap.entrySet()) {
            this.operations[opCounter] = (GBeanOperation)entry.getValue();
            this.operationIndex.put((GOperationSignature)entry.getKey(), new Integer(opCounter));
            ++opCounter;
        }
        this.gbeanInfo = this.rebuildGBeanInfo(gbeanInfo.getConstructor(), gbeanInfo.getJ2eeType());
        this.objectRecipe = this.newObjectRecipe(gbeanData);
        this.rawInvoker = new RawInvoker(this);
        for (i = 0; i < this.references.length; ++i) {
            this.references[i].online();
        }
        for (i = 0; i < this.dependencies.length; ++i) {
            this.dependencies[i].online();
        }
    }

    protected ObjectRecipe newObjectRecipe(GBeanData gbeanData) {
        GBeanInfo beanInfo = gbeanData.getGBeanInfo();
        List<String> cstrNames = beanInfo.getConstructor().getAttributeNames();
        Class[] cstrTypes = new Class[cstrNames.size()];
        for (int i = 0; i < cstrTypes.length; ++i) {
            Integer index;
            String argumentName = cstrNames.get(i);
            if (this.referenceIndex.containsKey(argumentName)) {
                index = this.referenceIndex.get(argumentName);
                GBeanReference reference = this.references[index];
                cstrTypes[i] = reference.getProxyType();
                continue;
            }
            if (!this.attributeIndex.containsKey(argumentName)) continue;
            index = this.attributeIndex.get(argumentName);
            GBeanAttribute attribute = this.attributes[index];
            cstrTypes[i] = attribute.getType();
        }
        ObjectRecipe objectRecipe = new ObjectRecipe(this.type, cstrNames.toArray(new String[0]), cstrTypes);
        objectRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        Map<String, Object> dataAttributes = gbeanData.getAttributes();
        for (GAttributeInfo attributeInfo : beanInfo.getAttributes()) {
            Integer integer = this.attributeIndex.get(attributeInfo.getName());
            GBeanAttribute attribute = this.attributes[integer];
            String attributeName = attribute.getName();
            if (attribute.isPersistent() || attribute.isDynamic()) {
                Object attributeValue = dataAttributes.get(attributeName);
                if (null != attributeValue) {
                    attribute.setPersistentValue(attributeValue);
                }
                if (!attribute.isPersistent() || null == attributeValue || attribute.isDynamic()) continue;
                objectRecipe.setProperty(attributeName, attribute.getPersistentValue());
                continue;
            }
            if (!attribute.isSpecial() || !attribute.isWritable() && !cstrNames.contains(attributeName)) continue;
            objectRecipe.setProperty(attributeName, attribute.getPersistentValue());
        }
        return objectRecipe;
    }

    protected void buildReferencesAndDependencies(GBeanData gbeanData, GBeanInfo gbeanInfo, Set<GBeanReference> referencesSet, Set<GBeanDependency> dependencySet) {
        Map<String, ReferencePatterns> dataReferences = gbeanData.getReferences();
        for (GReferenceInfo referenceInfo : gbeanInfo.getReferences()) {
            String referenceName = referenceInfo.getName();
            ReferencePatterns referencePatterns = dataReferences.remove(referenceName);
            if (referenceInfo.getProxyType().equals(Collection.class.getName())) {
                referencesSet.add(new GBeanCollectionReference(this, referenceInfo, this.kernel, referencePatterns));
                continue;
            }
            referencesSet.add(new GBeanSingleReference(this, referenceInfo, this.kernel, referencePatterns));
            if (referencePatterns == null) continue;
            dependencySet.add(new GBeanDependency(this, referencePatterns.getAbstractName(), this.kernel));
        }
        if (!dataReferences.isEmpty()) {
            throw new IllegalStateException("Attempting to set unknown references: " + dataReferences.keySet());
        }
    }

    protected GBeanAttribute[] buildAttributes(GBeanInfo gbeanInfo) {
        HashMap<String, GBeanAttribute> attributesMap = new HashMap<String, GBeanAttribute>();
        for (GAttributeInfo attributeInfo : gbeanInfo.getAttributes()) {
            attributesMap.put(attributeInfo.getName(), new GBeanAttribute(this, attributeInfo));
        }
        this.addManagedObjectAttributes(attributesMap);
        return attributesMap.values().toArray(new GBeanAttribute[attributesMap.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void die() throws GBeanNotFoundException {
        int i;
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            if (this.dead) {
                throw new GBeanNotFoundException(this.abstractName);
            }
            this.dead = true;
        }
        this.gbeanInstanceState.fail();
        for (i = 0; i < this.references.length; ++i) {
            this.references[i].offline();
        }
        for (i = 0; i < this.dependencies.length; ++i) {
            this.dependencies[i].offline();
        }
        this.lifecycleBroadcaster.fireUnloadedEvent();
        this.manageableStore = null;
    }

    public synchronized void setInstanceRegistry(InstanceRegistry instanceRegistry) {
        this.instanceRegistry = instanceRegistry;
    }

    public String getName() {
        return this.name;
    }

    public Bundle getBundle() {
        return this.bundleContext.getBundle();
    }

    public synchronized boolean isDead() {
        return this.dead;
    }

    public String getStateReason() {
        return this.stateReason;
    }

    public void setStateReason(String reason) {
        this.stateReason = reason;
    }

    public Class getType() {
        return this.type;
    }

    public synchronized Object getTarget() {
        return this.target;
    }

    public final String getObjectName() {
        return this.abstractName.getObjectName().getCanonicalName();
    }

    public final ObjectName getObjectNameObject() {
        return this.abstractName.getObjectName();
    }

    public final AbstractName getAbstractName() {
        return this.abstractName;
    }

    @Override
    public final synchronized long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getState() {
        return this.gbeanInstanceState.getState();
    }

    @Override
    public final State getStateInstance() {
        return this.gbeanInstanceState.getStateInstance();
    }

    public Map getAttributeIndex() {
        return Collections.unmodifiableMap(new HashMap<String, Integer>(this.attributeIndex));
    }

    public Map getOperationIndex() {
        return Collections.unmodifiableMap(new HashMap<GOperationSignature, Integer>(this.operationIndex));
    }

    public GBeanInfo getGBeanInfo() {
        return this.gbeanInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            if (this.dead) {
                throw new IllegalStateException("A dead GBean can not be started: abstractName=" + this.abstractName);
            }
        }
        this.gbeanInstanceState.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void startRecursive() {
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            if (this.dead) {
                throw new IllegalStateException("A dead GBean can not be started: abstractName=" + this.abstractName);
            }
        }
        this.gbeanInstanceState.startRecursive();
    }

    @Override
    public final void stop() {
        this.gbeanInstanceState.stop();
    }

    final void referenceFailed() {
        this.gbeanInstanceState.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GBeanData getGBeanData() {
        String name;
        int i;
        Object instance;
        int state;
        GBeanData gbeanData = new GBeanData(this.abstractName, this.gbeanInfo);
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            state = this.instanceState;
            instance = this.target;
        }
        for (i = 0; i < this.attributes.length; ++i) {
            Object value;
            GBeanAttribute attribute = this.attributes[i];
            if (!attribute.isPersistent()) continue;
            name = attribute.getName();
            if ((state != 0 || attribute.isFramework()) && attribute.isReadable()) {
                try {
                    value = attribute.getValue(instance);
                }
                catch (Throwable throwable) {
                    value = attribute.getPersistentValue();
                    log.debug("Could not get the current value of persistent attribute.  The persistent attribute will not reflect the current state attribute. " + attribute.getDescription(), throwable);
                }
            } else {
                value = attribute.getPersistentValue();
            }
            gbeanData.setAttribute(name, value);
        }
        for (i = 0; i < this.references.length; ++i) {
            GBeanReference reference = this.references[i];
            name = reference.getName();
            if (reference instanceof GBeanSingleReference) {
                AbstractName abstractName = ((GBeanSingleReference)reference).getTargetName();
                if (abstractName == null) continue;
                gbeanData.setReferencePattern(name, abstractName);
                continue;
            }
            if (reference instanceof GBeanCollectionReference) {
                Set patterns = ((GBeanCollectionReference)reference).getPatterns();
                if (patterns == null) continue;
                gbeanData.setReferencePatterns(name, patterns);
                continue;
            }
            throw new IllegalStateException("Unrecognized GBeanReference '" + reference.getClass().getName() + "'");
        }
        return gbeanData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(int index) throws Exception {
        Object instance;
        int state;
        GBeanAttribute attribute = this.attributes[index];
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            state = this.instanceState;
            instance = this.target;
        }
        if (state != 0 || attribute.isFramework()) {
            return attribute.getValue(instance);
        }
        if (attribute.isPersistent()) {
            return attribute.getPersistentValue();
        }
        throw new IllegalStateException("Cannot retrieve the value for non-persistent attribute \"" + attribute.getName() + "\" when GBeanInstance is DESTROYED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String attributeName) throws NoSuchAttributeException, Exception {
        Object instance;
        int state;
        GBeanAttribute attribute;
        try {
            attribute = this.getAttributeByName(attributeName);
        }
        catch (NoSuchAttributeException e) {
            if (attributeName.equals(RAW_INVOKER)) {
                return this.rawInvoker;
            }
            throw e;
        }
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            state = this.instanceState;
            instance = this.target;
        }
        if (state != 0 || attribute.isFramework()) {
            return attribute.getValue(instance);
        }
        if (attribute.isPersistent()) {
            return attribute.getPersistentValue();
        }
        throw new IllegalStateException("Cannot retrieve the value for non-persistent attribute " + attributeName + " when gbean has been destroyed: " + this.abstractName);
    }

    public void setAttribute(int index, Object value) throws Exception, IndexOutOfBoundsException {
        this.setAttribute(index, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttribute(int index, Object value, boolean manage) throws Exception, IndexOutOfBoundsException {
        Object instance;
        int state;
        GBeanAttribute attribute = this.attributes[index];
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            state = this.instanceState;
            instance = this.target;
        }
        if (state != 0 || attribute.isFramework()) {
            attribute.setValue(instance, value);
        } else {
            attribute.setPersistentValue(value);
        }
        if (manage && attribute.isManageable()) {
            this.updateManageableAttribute(attribute, value);
        }
    }

    public void setAttribute(String attributeName, Object value) throws Exception, NoSuchAttributeException {
        this.setAttribute(attributeName, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String attributeName, Object value, boolean manage) throws Exception, NoSuchAttributeException {
        Object instance;
        int state;
        GBeanAttribute attribute = this.getAttributeByName(attributeName);
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            state = this.instanceState;
            instance = this.target;
        }
        if (state != 0 || attribute.isFramework()) {
            attribute.setValue(instance, value);
        } else {
            attribute.setPersistentValue(value);
        }
        if (manage && attribute.isManageable()) {
            this.updateManageableAttribute(attribute, value);
        }
    }

    private void updateManageableAttribute(GBeanAttribute attribute, Object value) {
        Artifact configName;
        if (this.manageableStore == null) {
            this.manageableStore = this.getManageableAttributeStore();
            if (this.manageableStore == null) {
                return;
            }
        }
        if ((configName = this.abstractName.getArtifact()) != null) {
            this.manageableStore.setValue(configName, this.abstractName, attribute.getAttributeInfo(), value, this.getBundle());
        } else {
            log.error("Unable to identify Configuration for GBean " + this.abstractName + ".  Manageable attribute " + attribute.getName() + " was not updated in persistent store.");
        }
    }

    private ManageableAttributeStore getManageableAttributeStore() {
        Set<AbstractName> set = this.kernel.listGBeans(new AbstractNameQuery(ManageableAttributeStore.class.getName()));
        for (AbstractName abstractName1 : set) {
            try {
                return (ManageableAttributeStore)this.kernel.getGBean(abstractName1);
            }
            catch (GBeanNotFoundException e) {
            }
        }
        return null;
    }

    private GBeanAttribute getAttributeByName(String name) throws NoSuchAttributeException {
        Integer index = this.attributeIndex.get(name);
        if (index == null) {
            throw new NoSuchAttributeException("Unknown attribute \"" + name + "\" in gbean " + this.abstractName);
        }
        return this.attributes[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(int index, Object[] arguments) throws Exception {
        Object instance;
        int state;
        GBeanOperation operation = this.operations[index];
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            state = this.instanceState;
            instance = this.target;
        }
        if (state == 0 && !operation.isFramework()) {
            throw new IllegalStateException("Operations can only be invoke while the GBean instance is running: " + this.abstractName);
        }
        return operation.invoke(instance, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String operationName, Object[] arguments, String[] types) throws Exception, NoSuchOperationException {
        Object instance;
        int state;
        GOperationSignature signature = new GOperationSignature(operationName, types);
        Integer index = this.operationIndex.get(signature);
        if (index == null) {
            throw new NoSuchOperationException("Unknown operation " + signature);
        }
        GBeanOperation operation = this.operations[index];
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            state = this.instanceState;
            instance = this.target;
        }
        if (state == 0 && !operation.isFramework()) {
            throw new IllegalStateException("Operations can only be invoke while the GBean is running: " + this.abstractName);
        }
        return operation.invoke(instance, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createInstance() throws Exception {
        GBeanInstance e22;
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            int i;
            if (this.instanceState == 1 || this.instanceState == 2) {
                return false;
            }
            if (this.instanceState == 3) {
                this.stateReason = "an internal error has occurred.  An attempt was made to start an instance that was still stopping which is an illegal state transition.";
                throw new IllegalStateException("A stopping instance can not be started until fully stopped");
            }
            assert (this.instanceState == 0);
            this.stateReason = null;
            LinkedHashSet<AbstractName> unstarted = new LinkedHashSet<AbstractName>();
            for (i = 0; i < this.dependencies.length; ++i) {
                if (this.dependencies[i].start()) continue;
                unstarted.add(this.dependencies[i].getTargetName());
            }
            for (i = 0; i < this.references.length; ++i) {
                if (this.references[i].start() || !(this.references[i] instanceof GBeanSingleReference)) continue;
                GBeanReference reference = (GBeanSingleReference)this.references[i];
                unstarted.add(((GBeanSingleReference)reference).getTargetName());
            }
            if (!unstarted.isEmpty()) {
                this.stateReason = unstarted.size() == 1 ? unstarted.iterator().next() + " did not start." : "the following dependent services did not start: " + unstarted;
                return false;
            }
            this.instanceState = 1;
            this.startTime = System.currentTimeMillis();
        }
        for (GBeanReference reference : this.references) {
            Object value = reference.getProxy();
            if (null == value) continue;
            this.objectRecipe.setProperty(reference.getName(), value);
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Object instance = null;
        try {
            Object targetException;
            try {
                instance = this.objectRecipe.create(this.classLoader);
            }
            catch (ConstructionException e) {
                targetException = e.getCause();
                if (targetException instanceof Exception) {
                    this.stateReason = "the service constructor threw an exception. \n" + this.printException((Throwable)targetException);
                    throw (Exception)targetException;
                }
                if (targetException instanceof Error) {
                    this.stateReason = "the service constructor threw an exception. \n" + this.printException((Throwable)targetException);
                    throw (Error)targetException;
                }
                this.stateReason = "the service constructor threw an exception. \n" + this.printException(e);
                throw e;
            }
            Map unsetProperties = this.objectRecipe.getUnsetProperties();
            if (unsetProperties.size() > 0) {
                throw new ConstructionException("Error creating gbean of class: " + this.gbeanInfo.getClassName() + ", attempting to set nonexistent properties: " + unsetProperties.keySet());
            }
            targetException = this;
            synchronized (targetException) {
                this.target = instance;
            }
            for (GBeanAttribute attribute : this.attributes) {
                this.checkIfShouldFail();
                if (!attribute.isDynamic()) continue;
                try {
                    attribute.inject(this.target);
                }
                catch (Exception e) {
                    this.stateReason = "the setter for attribute '" + attribute.getName() + "' threw an exception. \n" + this.printException(e);
                    throw e;
                }
            }
            if (instance instanceof GBeanLifecycle) {
                this.checkIfShouldFail();
                try {
                    ((GBeanLifecycle)instance).doStart();
                }
                catch (Exception e22) {
                    this.stateReason = "the doStart method threw an exception. \n" + this.printException(e22);
                    throw e22;
                }
            }
            e22 = this;
            synchronized (e22) {
                this.checkIfShouldFail();
                if (this.instanceRegistry != null) {
                    this.instanceRegistry.instanceCreated(instance, this);
                }
                this.instanceState = 2;
                this.notifyAll();
            }
            this.stateReason = null;
            boolean e22 = true;
            return e22;
        }
        catch (Throwable t) {
            this.stateReason = "Throwable during start of gbean: \n" + this.printException(t);
            e22 = this;
            synchronized (e22) {
                this.instanceState = 3;
            }
            if (instance instanceof GBeanLifecycle) {
                try {
                    ((GBeanLifecycle)instance).doFail();
                }
                catch (Throwable ignored) {
                    log.error("Problem in doFail of " + this.abstractName, ignored);
                }
            }
            GBeanInstance gBeanInstance2 = this;
            synchronized (gBeanInstance2) {
                int i;
                for (i = 0; i < this.references.length; ++i) {
                    this.references[i].stop();
                }
                for (i = 0; i < this.dependencies.length; ++i) {
                    this.dependencies[i].stop();
                }
                this.target = null;
                this.instanceState = 0;
                this.startTime = 0L;
                this.notifyAll();
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new Error(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    private String printException(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    private synchronized void checkIfShouldFail() throws Exception {
        if (this.shouldFail) {
            this.shouldFail = false;
            throw new Exception("A reference has failed so construction can not complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean destroyInstance(boolean stop) throws Exception {
        Object instance;
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            if (!stop && this.instanceState == 1) {
                this.shouldFail = true;
                return false;
            }
            while (this.instanceState == 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    throw e;
                }
            }
            if (this.instanceState == 3 || this.instanceState == 0) {
                return false;
            }
            assert (this.instanceState == 2);
            this.stateReason = null;
            this.instanceState = 3;
            instance = this.target;
        }
        Exception problem = null;
        if (stop && instance != null) {
            try {
                Object value;
                GBeanAttribute attribute;
                int i;
                HashMap<GBeanAttribute, Object> data = new HashMap<GBeanAttribute, Object>();
                for (i = 0; i < this.attributes.length; ++i) {
                    attribute = this.attributes[i];
                    if (!attribute.isPersistent() || !attribute.isReadable()) continue;
                    try {
                        value = attribute.getValue(instance);
                    }
                    catch (Throwable e) {
                        throw new Exception("Problem while updating the persistent value of attibute: Attribute Name: " + attribute.getName() + ", " + "Type: " + attribute.getType() + ", " + "GBeanInstance: " + this.getName(), e);
                    }
                    data.put(attribute, value);
                }
                for (i = 0; i < this.attributes.length; ++i) {
                    attribute = this.attributes[i];
                    if (!attribute.isPersistent() || !attribute.isReadable()) continue;
                    value = data.get(attribute);
                    attribute.setPersistentValue(value);
                }
            }
            catch (Exception e) {
                stop = false;
                problem = e;
            }
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            if (instance instanceof GBeanLifecycle) {
                if (stop) {
                    try {
                        ((GBeanLifecycle)instance).doStop();
                    }
                    catch (Throwable ignored) {
                        log.error("Problem in doStop of " + this.abstractName, ignored);
                    }
                } else {
                    try {
                        ((GBeanLifecycle)instance).doFail();
                    }
                    catch (Throwable ignored) {
                        log.error("Problem in doFail of " + this.abstractName, ignored);
                    }
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        GBeanInstance gBeanInstance2 = this;
        synchronized (gBeanInstance2) {
            int i;
            for (i = 0; i < this.references.length; ++i) {
                this.references[i].stop();
            }
            for (i = 0; i < this.dependencies.length; ++i) {
                this.dependencies[i].stop();
            }
            this.target = null;
            this.instanceState = 0;
            if (this.instanceRegistry != null) {
                this.instanceRegistry.instanceDestroyed(instance);
            }
            this.startTime = 0L;
        }
        if (problem != null) {
            throw problem;
        }
        return true;
    }

    private void addManagedObjectAttributes(Map<String, GBeanAttribute> attributesMap) {
        attributesMap.put("abstractName", GBeanAttribute.createSpecialAttribute(attributesMap.get("abstractName"), this, "abstractName", AbstractName.class, this.getAbstractName()));
        attributesMap.put("objectName", GBeanAttribute.createSpecialAttribute(attributesMap.get("objectName"), this, "objectName", String.class, this.getObjectName()));
        attributesMap.put("classLoader", GBeanAttribute.createSpecialAttribute(attributesMap.get("classLoader"), this, "classLoader", ClassLoader.class, this.classLoader));
        attributesMap.put("bundle", GBeanAttribute.createSpecialAttribute(attributesMap.get("bundle"), this, "bundle", Bundle.class, this.bundleContext.getBundle()));
        attributesMap.put("bundleContext", GBeanAttribute.createSpecialAttribute(attributesMap.get("bundleContext"), this, "bundleContext", BundleContext.class, this.bundleContext));
        attributesMap.put("kernel", GBeanAttribute.createSpecialAttribute(attributesMap.get("kernel"), this, "kernel", Kernel.class, this.kernel));
    }

    private GBeanInfo rebuildGBeanInfo(GConstructorInfo constructor, String j2eeType) {
        HashSet<GAttributeInfo> attributeInfos = new HashSet<GAttributeInfo>();
        for (int i = 0; i < this.attributes.length; ++i) {
            GBeanAttribute attribute = this.attributes[i];
            attributeInfos.add(attribute.getAttributeInfo());
        }
        HashSet<GOperationInfo> operationInfos = new HashSet<GOperationInfo>();
        for (int i = 0; i < this.operations.length; ++i) {
            operationInfos.add(this.operations[i].getOperationInfo());
        }
        HashSet<GReferenceInfo> referenceInfos = new HashSet<GReferenceInfo>();
        for (int i = 0; i < this.references.length; ++i) {
            referenceInfos.add(this.references[i].getReferenceInfo());
        }
        HashSet<String> interfaceInfos = new HashSet<String>();
        for (int i = 0; i < this.interfaces.length; ++i) {
            interfaceInfos.add(this.interfaces[i]);
        }
        return new GBeanInfo(this.name, this.type.getName(), j2eeType, attributeInfos, constructor, operationInfos, referenceInfos, interfaceInfos);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GBeanInstance)) {
            return false;
        }
        return this.abstractName.equals(((GBeanInstance)obj).abstractName);
    }

    public int hashCode() {
        return this.abstractName.hashCode();
    }

    public String toString() {
        return this.abstractName.toString();
    }
}

