/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;

public class ReferenceMap
implements Map,
ReferenceCollectionListener {
    private final Map map;
    private final Key key;

    public ReferenceMap(Collection collection, Map map, Key key) {
        this.map = map;
        this.key = key;
        for (Object object : collection) {
            map.put(key.getKey(object), object);
        }
        if (collection instanceof ReferenceCollection) {
            ((ReferenceCollection)collection).addReferenceCollectionListener(this);
        }
    }

    public ReferenceMap(Collection collection, Key key) {
        this(collection, new HashMap(), key);
    }

    @Override
    public void memberAdded(ReferenceCollectionEvent event) {
        this.map.put(this.key.getKey(event.getMember()), event.getMember());
    }

    @Override
    public void memberRemoved(ReferenceCollectionEvent event) {
        this.map.remove(this.key.getKey(event.getMember()));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    public Object remove(Object key) {
        return this.map.remove(key);
    }

    public void putAll(Map t) {
        this.map.putAll(t);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.map).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public static interface Key {
        public Object getKey(Object var1);
    }
}

