/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.crypto.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.geronimo.crypto.asn1.ASN1InputStream;
import org.apache.geronimo.crypto.asn1.ASN1OutputStream;
import org.apache.geronimo.crypto.asn1.ASN1Sequence;
import org.apache.geronimo.crypto.asn1.DERBitString;
import org.apache.geronimo.crypto.asn1.DERBoolean;
import org.apache.geronimo.crypto.asn1.DEREncodable;
import org.apache.geronimo.crypto.asn1.DERIA5String;
import org.apache.geronimo.crypto.asn1.DERInteger;
import org.apache.geronimo.crypto.asn1.DERObjectIdentifier;
import org.apache.geronimo.crypto.asn1.DEROutputStream;
import org.apache.geronimo.crypto.asn1.misc.MiscObjectIdentifiers;
import org.apache.geronimo.crypto.asn1.misc.NetscapeCertType;
import org.apache.geronimo.crypto.asn1.misc.NetscapeRevocationURL;
import org.apache.geronimo.crypto.asn1.misc.VerisignCzagExtension;
import org.apache.geronimo.crypto.asn1.util.ASN1Dump;
import org.apache.geronimo.crypto.asn1.x509.BasicConstraints;
import org.apache.geronimo.crypto.asn1.x509.KeyUsage;
import org.apache.geronimo.crypto.asn1.x509.X509CertificateStructure;
import org.apache.geronimo.crypto.asn1.x509.X509Extension;
import org.apache.geronimo.crypto.asn1.x509.X509Extensions;
import org.apache.geronimo.crypto.encoders.Hex;
import org.apache.geronimo.crypto.jce.X509Principal;
import org.apache.geronimo.crypto.jce.interfaces.PKCS12BagAttributeCarrier;
import org.apache.geronimo.crypto.jce.provider.JDKKeyFactory;

public class X509CertificateObject
extends X509Certificate
implements PKCS12BagAttributeCarrier {
    private X509CertificateStructure c;
    private Hashtable pkcs12Attributes = new Hashtable();
    private Vector pkcs12Ordering = new Vector();

    public X509CertificateObject(X509CertificateStructure c) {
        this.c = c;
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.after(this.getNotAfter())) {
            throw new CertificateExpiredException("certificate expired on " + this.c.getEndDate().getTime());
        }
        if (date.before(this.getNotBefore())) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.c.getStartDate().getTime());
        }
    }

    public int getVersion() {
        return this.c.getVersion();
    }

    public BigInteger getSerialNumber() {
        return this.c.getSerialNumber().getValue();
    }

    public Principal getIssuerDN() {
        return new X509Principal(this.c.getIssuer());
    }

    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(this.c.getIssuer());
            return new X500Principal(bOut.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException("can't encode issuer DN", e);
        }
    }

    public Principal getSubjectDN() {
        return new X509Principal(this.c.getSubject());
    }

    public X500Principal getSubjectX500Principal() {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(this.c.getSubject());
            return new X500Principal(bOut.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException("can't encode issuer DN", e);
        }
    }

    public Date getNotBefore() {
        return this.c.getStartDate().getDate();
    }

    public Date getNotAfter() {
        return this.c.getEndDate().getDate();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        try {
            dOut.writeObject(this.c.getTBSCertificate());
            return bOut.toByteArray();
        }
        catch (IOException e) {
            throw (CertificateEncodingException)new CertificateEncodingException(e.getMessage()).initCause(e);
        }
    }

    public byte[] getSignature() {
        return this.c.getSignature().getBytes();
    }

    public String getSigAlgName() {
        Provider[] provs = Security.getProviders();
        for (int i = 0; i != provs.length; ++i) {
            String algName = provs[i].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (algName == null) continue;
            return algName;
        }
        return this.getSigAlgOID();
    }

    public String getSigAlgOID() {
        return this.c.getSignatureAlgorithm().getObjectId().getId();
    }

    public byte[] getSigAlgParams() {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        if (this.c.getSignatureAlgorithm().getParameters() != null) {
            try {
                DEROutputStream dOut = new DEROutputStream(bOut);
                dOut.writeObject(this.c.getSignatureAlgorithm().getParameters());
            }
            catch (Exception e) {
                throw new RuntimeException("exception getting sig parameters " + e.getMessage(), e);
            }
            return bOut.toByteArray();
        }
        return null;
    }

    public boolean[] getIssuerUniqueID() {
        DERBitString id = this.c.getTBSCertificate().getIssuerUniqueId();
        if (id != null) {
            byte[] bytes = id.getBytes();
            boolean[] boolId = new boolean[bytes.length * 8 - id.getPadBits()];
            for (int i = 0; i != boolId.length; ++i) {
                boolId[i] = (bytes[i / 8] & 128 >>> i % 8) != 0;
            }
            return boolId;
        }
        return null;
    }

    public boolean[] getSubjectUniqueID() {
        DERBitString id = this.c.getTBSCertificate().getSubjectUniqueId();
        if (id != null) {
            byte[] bytes = id.getBytes();
            boolean[] boolId = new boolean[bytes.length * 8 - id.getPadBits()];
            for (int i = 0; i != boolId.length; ++i) {
                boolId[i] = (bytes[i / 8] & 128 >>> i % 8) != 0;
            }
            return boolId;
        }
        return null;
    }

    public boolean[] getKeyUsage() {
        byte[] bytes = this.getExtensionBytes("2.5.29.15");
        int length = 0;
        if (bytes != null) {
            try {
                ASN1InputStream dIn = new ASN1InputStream(new ByteArrayInputStream(bytes));
                DERBitString bits = (DERBitString)dIn.readObject();
                bytes = bits.getBytes();
                length = bytes.length * 8 - bits.getPadBits();
            }
            catch (Exception e) {
                throw new RuntimeException("error processing key usage extension", e);
            }
            boolean[] keyUsage = new boolean[length < 9 ? 9 : length];
            for (int i = 0; i != length; ++i) {
                keyUsage[i] = (bytes[i / 8] & 128 >>> i % 8) != 0;
            }
            return keyUsage;
        }
        return null;
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] bytes = this.getExtensionBytes("2.5.29.37");
        boolean length = false;
        if (bytes != null) {
            try {
                ASN1InputStream dIn = new ASN1InputStream(new ByteArrayInputStream(bytes));
                ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i != seq.size(); ++i) {
                    list.add(((DERObjectIdentifier)seq.getObjectAt(i)).getId());
                }
                return Collections.unmodifiableList(list);
            }
            catch (Exception e) {
                throw (CertificateParsingException)new CertificateParsingException("error processing extended key usage extension").initCause(e);
            }
        }
        return null;
    }

    public int getBasicConstraints() {
        byte[] bytes = this.getExtensionBytes("2.5.29.19");
        if (bytes != null) {
            try {
                ASN1InputStream dIn = new ASN1InputStream(new ByteArrayInputStream(bytes));
                ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
                if (seq.size() == 2) {
                    if (((DERBoolean)seq.getObjectAt(0)).isTrue()) {
                        return ((DERInteger)seq.getObjectAt(1)).getValue().intValue();
                    }
                    return -1;
                }
                if (seq.size() == 1) {
                    if (seq.getObjectAt(0) instanceof DERBoolean) {
                        if (((DERBoolean)seq.getObjectAt(0)).isTrue()) {
                            return Integer.MAX_VALUE;
                        }
                        return -1;
                    }
                    return -1;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("error processing key usage extension", e);
            }
        }
        return -1;
    }

    public Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> set = new HashSet<String>();
            X509Extensions extensions = this.c.getTBSCertificate().getExtensions();
            if (extensions != null) {
                Enumeration e = extensions.oids();
                while (e.hasMoreElements()) {
                    DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                    X509Extension ext = extensions.getExtension(oid);
                    if (!ext.isCritical()) continue;
                    set.add(oid.getId());
                }
                return set;
            }
        }
        return null;
    }

    private byte[] getExtensionBytes(String oid) {
        X509Extension ext;
        X509Extensions exts = this.c.getTBSCertificate().getExtensions();
        if (exts != null && (ext = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            return ext.getValue().getOctets();
        }
        return null;
    }

    public byte[] getExtensionValue(String oid) {
        X509Extension ext;
        X509Extensions exts = this.c.getTBSCertificate().getExtensions();
        if (exts != null && (ext = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            try {
                dOut.writeObject(ext.getValue());
                return bOut.toByteArray();
            }
            catch (Exception e) {
                throw new RuntimeException("error encoding " + e.getMessage(), e);
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> set = new HashSet<String>();
            X509Extensions extensions = this.c.getTBSCertificate().getExtensions();
            if (extensions != null) {
                Enumeration e = extensions.oids();
                while (e.hasMoreElements()) {
                    DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                    X509Extension ext = extensions.getExtension(oid);
                    if (ext.isCritical()) continue;
                    set.add(oid.getId());
                }
                return set;
            }
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        X509Extensions extensions;
        if (this.getVersion() == 3 && (extensions = this.c.getTBSCertificate().getExtensions()) != null) {
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                X509Extension ext;
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                if (oid.getId().equals("2.5.29.15") || oid.getId().equals("2.5.29.19") || !(ext = extensions.getExtension(oid)).isCritical()) continue;
                return true;
            }
        }
        return false;
    }

    public PublicKey getPublicKey() {
        return JDKKeyFactory.createPublicKeyFromPublicKeyInfo(this.c.getSubjectPublicKeyInfo());
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        try {
            dOut.writeObject(this.c);
            return bOut.toByteArray();
        }
        catch (IOException e) {
            throw (CertificateEncodingException)new CertificateEncodingException(e.getMessage()).initCause(e);
        }
    }

    public void setBagAttribute(DERObjectIdentifier oid, DEREncodable attribute) {
        this.pkcs12Attributes.put(oid, attribute);
        this.pkcs12Ordering.addElement(oid);
    }

    public DEREncodable getBagAttribute(DERObjectIdentifier oid) {
        return (DEREncodable)this.pkcs12Attributes.get(oid);
    }

    public Enumeration getBagAttributeKeys() {
        return this.pkcs12Ordering.elements();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append("  [0]         Version: " + this.getVersion() + nl);
        buf.append("         SerialNumber: " + this.getSerialNumber() + nl);
        buf.append("             IssuerDN: " + this.getIssuerDN() + nl);
        buf.append("           Start Date: " + this.getNotBefore() + nl);
        buf.append("           Final Date: " + this.getNotAfter() + nl);
        buf.append("            SubjectDN: " + this.getSubjectDN() + nl);
        buf.append("           Public Key: " + this.getPublicKey() + nl);
        buf.append("  Signature Algorithm: " + this.getSigAlgName() + nl);
        byte[] sig = this.getSignature();
        buf.append("            Signature: " + new String(Hex.encode(sig, 0, 20)) + nl);
        for (int i = 20; i < sig.length; i += 20) {
            if (i < sig.length - 20) {
                buf.append("                       " + new String(Hex.encode(sig, i, 20)) + nl);
                continue;
            }
            buf.append("                       " + new String(Hex.encode(sig, i, sig.length - i)) + nl);
        }
        X509Extensions extensions = this.c.getTBSCertificate().getExtensions();
        if (extensions != null) {
            Enumeration e = extensions.oids();
            if (e.hasMoreElements()) {
                buf.append("       Extensions: \n");
            }
            while (e.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                X509Extension ext = extensions.getExtension(oid);
                if (ext.getValue() != null) {
                    byte[] octs = ext.getValue().getOctets();
                    ByteArrayInputStream bIn = new ByteArrayInputStream(octs);
                    ASN1InputStream dIn = new ASN1InputStream(bIn);
                    buf.append("                       critical(" + ext.isCritical() + ") ");
                    try {
                        if (oid.equals(X509Extensions.BasicConstraints)) {
                            buf.append(new BasicConstraints((ASN1Sequence)dIn.readObject()) + nl);
                            continue;
                        }
                        if (oid.equals(X509Extensions.KeyUsage)) {
                            buf.append(new KeyUsage((DERBitString)dIn.readObject()) + nl);
                            continue;
                        }
                        if (oid.equals(MiscObjectIdentifiers.netscapeCertType)) {
                            buf.append(new NetscapeCertType((DERBitString)dIn.readObject()) + nl);
                            continue;
                        }
                        if (oid.equals(MiscObjectIdentifiers.netscapeRevocationURL)) {
                            buf.append(new NetscapeRevocationURL((DERIA5String)dIn.readObject()) + nl);
                            continue;
                        }
                        if (oid.equals(MiscObjectIdentifiers.verisignCzagExtension)) {
                            buf.append(new VerisignCzagExtension((DERIA5String)dIn.readObject()) + nl);
                            continue;
                        }
                        buf.append(oid.getId());
                        buf.append(" value = " + ASN1Dump.dumpAsString(dIn.readObject()) + nl);
                    }
                    catch (Exception ex) {
                        buf.append(oid.getId());
                        buf.append(" value = *****" + nl);
                    }
                    continue;
                }
                buf.append(nl);
            }
        }
        return buf.toString();
    }

    public final void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = null;
        if (!this.c.getSignatureAlgorithm().equals(this.c.getTBSCertificate().getSignature())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        try {
            signature = Signature.getInstance(this.c.getSignatureAlgorithm().getObjectId().getId(), "BC");
        }
        catch (Exception e) {
            signature = Signature.getInstance(this.c.getSignatureAlgorithm().getObjectId().getId());
        }
        signature.initVerify(key);
        signature.update(this.getTBSCertificate());
        if (!signature.verify(this.getSignature())) {
            throw new InvalidKeyException("Public key presented not for certificate signature");
        }
    }

    public final void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = Signature.getInstance(this.c.getSignatureAlgorithm().getObjectId().getId(), sigProvider);
        if (!this.c.getSignatureAlgorithm().equals(this.c.getTBSCertificate().getSignature())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        signature.initVerify(key);
        signature.update(this.getTBSCertificate());
        if (!signature.verify(this.getSignature())) {
            throw new InvalidKeyException("Public key presented not for certificate signature");
        }
    }
}

