/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.common.propertyeditor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.geronimo.common.propertyeditor.PropertyEditorException;
import org.apache.geronimo.common.propertyeditor.TextPropertyEditorSupport;

public class PropertiesEditor
extends TextPropertyEditorSupport {
    @Override
    public Object getValue() {
        Object currentValue = super.getValue();
        if (currentValue instanceof Properties) {
            return (Properties)currentValue;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(currentValue.toString().getBytes());
        Properties bundle = new Properties();
        try {
            bundle.load(stream);
        }
        catch (IOException e) {
            throw new PropertyEditorException(e.getMessage(), e);
        }
        return bundle;
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        if (value instanceof Properties) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ((Properties)value).store(baos, null);
            }
            catch (IOException e) {
                throw new PropertyEditorException(e.getMessage(), e);
            }
            return baos.toString();
        }
        return "" + value;
    }
}

