/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.cdi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.geronimo.config.ConfigImpl;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigurationHandler
implements InvocationHandler {
    private final ConfigImpl config;
    private final Map<Method, MethodMeta> methodMetas;

    ConfigurationHandler(ConfigImpl config, Class<?> api) {
        this.config = config;
        String prefix = Optional.ofNullable(api.getAnnotation(ConfigProperty.class)).map(ConfigProperty::name).orElse("");
        this.methodMetas = Stream.of(api.getMethods()).filter(m -> m.isAnnotationPresent(ConfigProperty.class)).collect(Collectors.toMap(Function.identity(), e -> new MethodMeta((Method)e, prefix)));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class == method.getDeclaringClass()) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
        MethodMeta methodMeta = this.methodMetas.get(method);
        if (methodMeta != null) {
            return methodMeta.read(this.config);
        }
        return null;
    }

    private static class MethodMeta {
        private final String key;
        private final Object defaultValue;
        private final Class lookupType;
        private final Class collectionConversionType;
        private final Collector<Object, ?, ? extends Collection<Object>> collectionCollector;
        private final boolean optional;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private MethodMeta(Method m, String prefix) {
            boolean hasDefault;
            Type type;
            ConfigProperty annotation = m.getAnnotation(ConfigProperty.class);
            this.optional = Optional.class == m.getReturnType();
            Type type2 = type = this.optional ? ((ParameterizedType)ParameterizedType.class.cast(m.getGenericReturnType())).getActualTypeArguments()[0] : m.getGenericReturnType();
            if (Class.class.isInstance(type)) {
                this.lookupType = (Class)Class.class.cast(type);
                this.collectionCollector = null;
                this.collectionConversionType = null;
            } else {
                if (!ParameterizedType.class.isInstance(type)) throw new IllegalArgumentException("Unsupported type: " + type);
                ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(type);
                Type rawType = pt.getRawType();
                if (!Class.class.isInstance(rawType)) {
                    throw new IllegalArgumentException("Unsupported parameterized type: " + type);
                }
                Class clazz = (Class)Class.class.cast(pt.getRawType());
                if (!Collection.class.isAssignableFrom(clazz)) throw new IllegalArgumentException("Unsupported parameterized type: " + type + ", did you want a Collection?");
                Type arg0 = pt.getActualTypeArguments()[0];
                this.collectionConversionType = (Class)Class.class.cast(ParameterizedType.class.isInstance(arg0) ? ((ParameterizedType)ParameterizedType.class.cast(arg0)).getRawType() : Class.class.cast(arg0));
                this.lookupType = String.class;
                this.collectionCollector = Set.class.isAssignableFrom(clazz) ? Collectors.toSet() : Collectors.toList();
            }
            this.key = prefix + (annotation.name().isEmpty() ? m.getDeclaringClass().getName() + "." + m.getName() : annotation.name());
            String defaultValue = annotation.defaultValue();
            boolean canBeNull = "org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValue);
            boolean bl = hasDefault = !"org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValue) && !canBeNull;
            if (hasDefault) {
                Config config = ConfigProvider.getConfig();
                if (this.lookupType == Long.TYPE || this.lookupType == Long.class) {
                    this.defaultValue = Long.parseLong(defaultValue);
                    return;
                } else if (this.lookupType == Boolean.TYPE || this.lookupType == Boolean.class) {
                    this.defaultValue = Boolean.parseBoolean(defaultValue);
                    return;
                } else if (this.lookupType == Integer.TYPE || this.lookupType == Integer.class) {
                    this.defaultValue = Integer.parseInt(defaultValue);
                    return;
                } else if (this.lookupType == Double.TYPE || this.lookupType == Double.class) {
                    this.defaultValue = Double.parseDouble(defaultValue);
                    return;
                } else if (this.lookupType == Float.TYPE || this.lookupType == Float.class) {
                    this.defaultValue = Float.valueOf(Float.parseFloat(defaultValue));
                    return;
                } else if (this.lookupType == Short.TYPE || this.lookupType == Short.class) {
                    this.defaultValue = Short.parseShort(defaultValue);
                    return;
                } else if (this.lookupType == Character.TYPE || this.lookupType == Character.class) {
                    this.defaultValue = Character.valueOf(defaultValue.charAt(0));
                    return;
                } else if (this.lookupType == Byte.TYPE || this.lookupType == Byte.class) {
                    this.defaultValue = Byte.parseByte(defaultValue);
                    return;
                } else if (this.collectionCollector != null) {
                    this.defaultValue = this.convert(defaultValue, config);
                    return;
                } else {
                    if (this.lookupType != String.class) throw new IllegalArgumentException("Unsupported default for " + m);
                    this.defaultValue = defaultValue;
                }
                return;
            } else {
                this.defaultValue = this.lookupType.isPrimitive() ? (this.lookupType == Long.TYPE ? Long.valueOf(0L) : (this.lookupType == Boolean.TYPE ? Boolean.valueOf(false) : (this.lookupType == Integer.TYPE ? Integer.valueOf(0) : (this.lookupType == Double.TYPE ? Double.valueOf(0.0) : (this.lookupType == Float.TYPE ? Float.valueOf(0.0f) : (this.lookupType == Short.TYPE ? Short.valueOf((short)0) : (this.lookupType == Character.TYPE ? (Comparable<Character>)Character.valueOf('\u0000') : (Comparable<Character>)(this.lookupType == Byte.TYPE ? Byte.valueOf((byte)0) : null)))))))) : null;
            }
        }

        Object read(ConfigImpl config) {
            Optional optionalValue = Optional.ofNullable(config.access(this.key).as(this.lookupType).evaluateVariables(true).get());
            if (this.optional) {
                return this.processOptional(optionalValue, config);
            }
            return this.processOptional(optionalValue, config).orElse(this.defaultValue);
        }

        private Optional processOptional(Optional<?> optionalValue, Config config) {
            if (this.collectionCollector != null) {
                return optionalValue.map(String.class::cast).map(v -> this.convert((String)v, config));
            }
            return optionalValue;
        }

        private Collection<?> convert(String o, Config config) {
            String[] values = o.split(",");
            return Stream.of(values).map(v -> this.mapValue((String)v, config)).collect(this.collectionCollector);
        }

        private Object mapValue(String raw, Config config) {
            if (String.class == this.collectionConversionType) {
                return raw;
            }
            if (ConfigImpl.class.isInstance(config)) {
                return ((ConfigImpl)ConfigImpl.class.cast(config)).convert(raw, this.collectionConversionType);
            }
            throw new IllegalArgumentException("Unsupported conversion if config instance is not a ConfigImpl: " + this.collectionConversionType);
        }
    }
}

