/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.Vetoed;
import org.apache.geronimo.config.ConfigValueImpl;
import org.apache.geronimo.config.DefaultConfigBuilder;
import org.apache.geronimo.config.converters.BooleanConverter;
import org.apache.geronimo.config.converters.ByteConverter;
import org.apache.geronimo.config.converters.CharacterConverter;
import org.apache.geronimo.config.converters.ClassConverter;
import org.apache.geronimo.config.converters.DoubleConverter;
import org.apache.geronimo.config.converters.DurationConverter;
import org.apache.geronimo.config.converters.FloatConverter;
import org.apache.geronimo.config.converters.ImplicitConverter;
import org.apache.geronimo.config.converters.IntegerConverter;
import org.apache.geronimo.config.converters.LongConverter;
import org.apache.geronimo.config.converters.ShortConverter;
import org.apache.geronimo.config.converters.StringConverter;
import org.apache.geronimo.config.converters.URLConverter;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

@Typed
@Vetoed
public class ConfigImpl
implements Config,
AutoCloseable {
    protected Logger logger = Logger.getLogger(ConfigImpl.class.getName());
    protected List<ConfigSource> configSources = new ArrayList<ConfigSource>();
    protected Map<Type, Converter> converters = new HashMap<Type, Converter>();
    protected Map<Type, Converter> implicitConverters = new ConcurrentHashMap<Type, Converter>();
    private volatile long lastChanged = 0L;

    public ConfigImpl() {
        this.registerDefaultConverter();
    }

    private void registerDefaultConverter() {
        this.converters.put((Type)((Object)String.class), StringConverter.INSTANCE);
        this.converters.put((Type)((Object)Boolean.class), BooleanConverter.INSTANCE);
        this.converters.put(Boolean.TYPE, BooleanConverter.INSTANCE);
        this.converters.put((Type)((Object)Double.class), DoubleConverter.INSTANCE);
        this.converters.put(Double.TYPE, DoubleConverter.INSTANCE);
        this.converters.put((Type)((Object)Float.class), FloatConverter.INSTANCE);
        this.converters.put(Float.TYPE, FloatConverter.INSTANCE);
        this.converters.put((Type)((Object)Integer.class), IntegerConverter.INSTANCE);
        this.converters.put(Integer.TYPE, IntegerConverter.INSTANCE);
        this.converters.put((Type)((Object)Long.class), LongConverter.INSTANCE);
        this.converters.put(Long.TYPE, LongConverter.INSTANCE);
        this.converters.put((Type)((Object)Byte.class), ByteConverter.INSTANCE);
        this.converters.put(Byte.TYPE, ByteConverter.INSTANCE);
        this.converters.put((Type)((Object)Short.class), ShortConverter.INSTANCE);
        this.converters.put(Short.TYPE, ShortConverter.INSTANCE);
        this.converters.put((Type)((Object)Character.class), CharacterConverter.INSTANCE);
        this.converters.put(Character.TYPE, CharacterConverter.INSTANCE);
        this.converters.put((Type)((Object)Class.class), (Converter)ClassConverter.INSTANCE);
        this.converters.put((Type)((Object)Duration.class), DurationConverter.INSTANCE);
        this.converters.put((Type)((Object)URL.class), URLConverter.INSTANCE);
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> asType) {
        String value = this.getValue(propertyName);
        if (value != null && value.length() == 0) {
            value = null;
        }
        return Optional.ofNullable(this.convert(value, asType));
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        String value = this.getValue(propertyName);
        if (value == null) {
            throw new NoSuchElementException("No configured value found for config key " + propertyName);
        }
        return this.convert(value, propertyType);
    }

    public String getValue(String key) {
        for (ConfigSource configSource : this.configSources) {
            String value = configSource.getValue(key);
            if (value == null) continue;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "found value {0} for key {1} in ConfigSource {2}.", new Object[]{value, key, configSource.getName()});
            }
            return value;
        }
        return null;
    }

    public <T> T convert(String value, Class<T> asType) {
        if (value != null) {
            Converter converter = this.getConverter(asType);
            return (T)converter.convert(value);
        }
        return null;
    }

    private <T> Converter getConverter(Class<T> asType) {
        Converter converter = this.converters.get(asType);
        if (converter == null) {
            converter = this.getImplicitConverter(asType);
        }
        if (converter == null) {
            throw new IllegalArgumentException("No Converter registered for class " + asType);
        }
        return converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Converter getImplicitConverter(Class<T> asType) {
        Converter converter = this.implicitConverters.get(asType);
        if (converter == null) {
            Map<Type, Converter> map = this.implicitConverters;
            synchronized (map) {
                converter = this.implicitConverters.get(asType);
                if (converter == null) {
                    if (asType.isArray()) {
                        Converter singleItemConverter = this.getConverter(asType.getComponentType());
                        if (singleItemConverter == null) {
                            return null;
                        }
                        converter = new Converter(singleItemConverter, asType.getComponentType());
                        this.implicitConverters.putIfAbsent(asType, converter);
                    } else {
                        converter = ImplicitConverter.getImplicitConverter(asType);
                        if (converter != null) {
                            this.implicitConverters.putIfAbsent(asType, converter);
                        }
                    }
                }
            }
        }
        return converter;
    }

    public ConfigValueImpl<String> access(String key) {
        return new ConfigValueImpl<String>(this, key);
    }

    public Iterable<String> getPropertyNames() {
        return this.configSources.stream().flatMap(c -> c.getPropertyNames().stream()).collect(Collectors.toSet());
    }

    public Iterable<ConfigSource> getConfigSources() {
        return Collections.unmodifiableList(this.configSources);
    }

    public synchronized void addConfigSources(List<ConfigSource> configSourcesToAdd) {
        ArrayList<ConfigSource> allConfigSources = new ArrayList<ConfigSource>(this.configSources);
        allConfigSources.addAll(configSourcesToAdd);
        this.configSources = this.sortDescending(allConfigSources);
    }

    public synchronized void addConverter(Converter<?> converter) {
        if (converter == null) {
            return;
        }
        Type targetType = this.getTypeOfConverter(converter.getClass());
        if (targetType == null) {
            throw new IllegalStateException("Converter " + converter.getClass() + " must be a ParameterisedType");
        }
        Converter oldConverter = this.converters.get(targetType);
        if (oldConverter == null || this.getPriority(converter) > this.getPriority(oldConverter)) {
            this.converters.put(targetType, converter);
        }
    }

    public void addPrioritisedConverter(DefaultConfigBuilder.PrioritisedConverter prioritisedConverter) {
        Converter oldConverter = this.converters.get(prioritisedConverter.getType());
        if (oldConverter == null || prioritisedConverter.getPriority() >= this.getPriority(oldConverter)) {
            this.converters.put(prioritisedConverter.getType(), prioritisedConverter.getConverter());
        }
    }

    private int getPriority(Converter<?> converter) {
        int priority = 100;
        Priority priorityAnnotation = converter.getClass().getAnnotation(Priority.class);
        if (priorityAnnotation != null) {
            priority = priorityAnnotation.value();
        }
        return priority;
    }

    public Map<Type, Converter> getConverters() {
        return this.converters;
    }

    @Override
    public void close() throws Exception {
        ArrayList exceptions = new ArrayList();
        this.converters.values().stream().filter(c -> c instanceof AutoCloseable).map(AutoCloseable.class::cast).forEach(c -> {
            try {
                c.close();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        });
        this.configSources.stream().filter(c -> c instanceof AutoCloseable).map(AutoCloseable.class::cast).forEach(c -> {
            try {
                c.close();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        });
        if (!exceptions.isEmpty()) {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("The following Exceptions got detected while shutting down the Config:\n");
            for (Exception exception : exceptions) {
                sb.append(exception.getClass().getName()).append(" ").append(exception.getMessage()).append('\n');
            }
            throw new RuntimeException(sb.toString(), (Throwable)exceptions.get(0));
        }
    }

    private List<ConfigSource> sortDescending(List<ConfigSource> configSources) {
        configSources.sort((configSource1, configSource2) -> {
            int compare = Integer.compare(configSource2.getOrdinal(), configSource1.getOrdinal());
            if (compare == 0) {
                return configSource1.getName().compareTo(configSource2.getName());
            }
            return compare;
        });
        return configSources;
    }

    private Type getTypeOfConverter(Class clazz) {
        Type[] genericInterfaces;
        if (clazz.equals(Object.class)) {
            return null;
        }
        for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(genericInterface instanceof ParameterizedType) || !(pt = (ParameterizedType)genericInterface).getRawType().equals(Converter.class)) continue;
            Type[] typeArguments = pt.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new IllegalStateException("Converter " + clazz + " must be a ParameterisedType");
            }
            return typeArguments[0];
        }
        return this.getTypeOfConverter(clazz.getSuperclass());
    }

    public void onAttributeChange(Set<String> attributesChanged) {
        long l;
        long newLastChanged = System.nanoTime();
        if (this.lastChanged >= newLastChanged) {
            long l2 = this.lastChanged;
            l = l2;
            this.lastChanged = l2 + 1L;
        } else {
            l = newLastChanged;
        }
        this.lastChanged = l;
    }

    public long getLastChanged() {
        return this.lastChanged;
    }
}

