/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.converters;

import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.Converter;

public class MicroProfileTypedConverter<T> {
    private final Converter<T> delegate;
    private final int priority;

    public MicroProfileTypedConverter(Converter<T> delegate) {
        this(delegate, MicroProfileTypedConverter.readPriority(delegate));
    }

    public MicroProfileTypedConverter(Converter<T> delegate, int priority) {
        this.delegate = delegate;
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    private static <T> int readPriority(Converter<T> delegate) {
        Priority priority = delegate.getClass().getAnnotation(Priority.class);
        if (priority != null) {
            return priority.value();
        }
        return 100;
    }

    public T convert(String value) {
        return (T)this.delegate.convert(value);
    }
}

