/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.configsource;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.Vetoed;
import org.apache.geronimo.config.configsource.PropertyFileConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

@Typed
@Vetoed
public class PropertyFileConfigSourceProvider
implements ConfigSourceProvider {
    private static final Logger LOG = Logger.getLogger(PropertyFileConfigSourceProvider.class.getName());
    private List<ConfigSource> configSources = new ArrayList<ConfigSource>();

    public PropertyFileConfigSourceProvider(String propertyFileName, boolean optional, ClassLoader forClassLoader) {
        try {
            Enumeration<URL> propertyFileUrls = this.resolvePropertyFiles(forClassLoader, propertyFileName);
            if (!optional && !propertyFileUrls.hasMoreElements()) {
                throw new IllegalStateException(propertyFileName + " wasn't found.");
            }
            while (propertyFileUrls.hasMoreElements()) {
                URL propertyFileUrl = propertyFileUrls.nextElement();
                LOG.log(Level.INFO, "Custom config found by GeronimoConfig. Name: ''{0}'', URL: ''{1}''", new Object[]{propertyFileName, propertyFileUrl});
                this.configSources.add(new PropertyFileConfigSource(propertyFileUrl));
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("problem while loading GeronimoConfig property files", ioe);
        }
    }

    public Enumeration<URL> resolvePropertyFiles(ClassLoader cl, String propertyFileName) throws IOException {
        Enumeration<URL> propertyFileUrls = cl.getResources(propertyFileName);
        return propertyFileUrls;
    }

    public List<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        return this.configSources;
    }
}

