/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.components.jaspi.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.geronimo.components.jaspi.model.ClientAuthContextType;
import org.apache.geronimo.components.jaspi.model.ConfigProviderType;
import org.apache.geronimo.components.jaspi.model.KeyedObject;

@XmlRootElement(name="clientAuthConfig", namespace="http://geronimo.apache.org/xml/ns/geronimo-jaspi")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="clientAuthConfigType", propOrder={"messageLayer", "appContext", "authenticationContextID", "_protected", "clientAuthContext"})
public class ClientAuthConfigType
implements Serializable,
KeyedObject {
    private static final long serialVersionUID = 12343L;
    protected String messageLayer;
    protected String appContext;
    protected String authenticationContextID;
    @XmlElement(name="protected")
    protected boolean _protected;
    protected List<ClientAuthContextType> clientAuthContext;

    public ClientAuthConfigType() {
    }

    public ClientAuthConfigType(ClientAuthContextType clientAuthContextType, boolean _protected) {
        this.messageLayer = clientAuthContextType.getMessageLayer();
        this.appContext = clientAuthContextType.getAppContext();
        this.authenticationContextID = clientAuthContextType.getAuthenticationContextID();
        this.clientAuthContext = Collections.singletonList(clientAuthContextType);
        this._protected = _protected;
    }

    public String getMessageLayer() {
        return this.messageLayer;
    }

    public void setMessageLayer(String value) {
        this.messageLayer = value;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public void setAppContext(String value) {
        this.appContext = value;
    }

    public String getAuthenticationContextID() {
        return this.authenticationContextID;
    }

    public void setAuthenticationContextID(String value) {
        this.authenticationContextID = value;
    }

    public boolean isProtected() {
        return this._protected;
    }

    public void refresh() throws AuthException, SecurityException {
    }

    public void setProtected(boolean value) {
        this._protected = value;
    }

    public List<ClientAuthContextType> getClientAuthContext() {
        if (this.clientAuthContext == null) {
            this.clientAuthContext = new ArrayList<ClientAuthContextType>();
        }
        return this.clientAuthContext;
    }

    public String getAuthContextID(MessageInfo messageInfo) throws IllegalArgumentException {
        if (this.authenticationContextID != null) {
            return this.authenticationContextID;
        }
        for (ClientAuthContextType clientAuthContextType : this.clientAuthContext) {
            String authContextID = clientAuthContextType.getAuthenticationContextID(messageInfo);
            if (authContextID == null) continue;
            return authContextID;
        }
        return null;
    }

    @Override
    public String getKey() {
        return ConfigProviderType.getRegistrationKey(this.messageLayer, this.appContext);
    }
}

