/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.PoolIdleReleaserTimer;
import org.apache.geronimo.connector.outbound.PoolingAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSinglePoolConnectionInterceptor
implements ConnectionInterceptor,
PoolingAttributes {
    protected static Logger log = LoggerFactory.getLogger(AbstractSinglePoolConnectionInterceptor.class);
    protected final ConnectionInterceptor next;
    private final ReadWriteLock resizeLock = new ReentrantReadWriteLock();
    protected Semaphore permits;
    protected int blockingTimeoutMilliseconds;
    protected int connectionCount = 0;
    protected long idleTimeoutMilliseconds;
    private IdleReleaser idleReleaser;
    protected Timer timer = PoolIdleReleaserTimer.getTimer();
    protected int maxSize = 0;
    protected int minSize = 0;
    protected int shrinkLater = 0;
    protected volatile boolean destroyed = false;

    public AbstractSinglePoolConnectionInterceptor(ConnectionInterceptor next, int maxSize, int minSize, int blockingTimeoutMilliseconds, int idleTimeoutMinutes) {
        this.next = next;
        this.maxSize = maxSize;
        this.minSize = minSize;
        this.blockingTimeoutMilliseconds = blockingTimeoutMilliseconds;
        this.setIdleTimeoutMinutes(idleTimeoutMinutes);
        this.permits = new Semaphore(maxSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        if (connectionInfo.getManagedConnectionInfo().getManagedConnection() != null) {
            if (log.isTraceEnabled()) {
                log.trace("supplying already assigned connection from pool " + this + " " + connectionInfo);
            }
            return;
        }
        try {
            this.resizeLock.readLock().lock();
            try {
                if (this.permits.tryAcquire(this.blockingTimeoutMilliseconds, TimeUnit.MILLISECONDS)) {
                    try {
                        this.internalGetConnection(connectionInfo);
                    }
                    catch (ResourceException e) {
                        this.permits.release();
                        throw e;
                    }
                } else {
                    throw new ResourceException("No ManagedConnections available within configured blocking timeout ( " + this.blockingTimeoutMilliseconds + " [ms] ) for pool " + this);
                }
                Object var4_4 = null;
                this.resizeLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.resizeLock.readLock().unlock();
                throw throwable;
            }
        }
        catch (InterruptedException ie) {
            throw new ResourceException("Interrupted while requesting permit.", (Throwable)ie);
        }
    }

    protected abstract void internalGetConnection(ConnectionInfo var1) throws ResourceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        if (log.isTraceEnabled()) {
            log.trace("returning connection " + connectionInfo.getConnectionHandle() + " for MCI " + connectionInfo.getManagedConnectionInfo() + " and MC " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " to pool " + this);
        }
        if (this.destroyed) {
            try {
                connectionInfo.getManagedConnectionInfo().getManagedConnection().destroy();
            }
            catch (ResourceException re) {
                // empty catch block
            }
            return;
        }
        this.resizeLock.readLock().lock();
        try {
            ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
            if (connectionReturnAction == ConnectionReturnAction.RETURN_HANDLE && mci.hasConnectionHandles()) {
                if (log.isTraceEnabled()) {
                    log.trace("Return request at pool with connection handles! " + connectionInfo.getConnectionHandle() + " for MCI " + connectionInfo.getManagedConnectionInfo() + " and MC " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " to pool " + this, (Throwable)new Exception("Stack trace"));
                }
                Object var6_5 = null;
                this.resizeLock.readLock().unlock();
                return;
            }
            boolean releasePermit = this.internalReturn(connectionInfo, connectionReturnAction);
            if (releasePermit) {
                this.permits.release();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.resizeLock.readLock().unlock();
            throw throwable;
        }
        Object var6_6 = null;
        this.resizeLock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalReturn(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        boolean releasePermit;
        ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
        ManagedConnection mc = mci.getManagedConnection();
        try {
            mc.cleanup();
        }
        catch (ResourceException e) {
            connectionReturnAction = ConnectionReturnAction.DESTROY;
        }
        Object object = this.getPool();
        synchronized (object) {
            if (this.destroyed) {
                try {
                    mc.destroy();
                }
                catch (ResourceException re) {
                    // empty catch block
                }
                return this.doRemove(mci);
            }
            if (this.shrinkLater > 0) {
                connectionReturnAction = ConnectionReturnAction.DESTROY;
                --this.shrinkLater;
                releasePermit = false;
            } else {
                if (connectionReturnAction == ConnectionReturnAction.RETURN_HANDLE) {
                    mci.setLastUsed(System.currentTimeMillis());
                    this.doAdd(mci);
                    return true;
                }
                releasePermit = this.doRemove(mci);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Discarding connection in pool " + this + " " + connectionInfo);
        }
        this.next.returnConnection(connectionInfo, connectionReturnAction);
        --this.connectionCount;
        return releasePermit;
    }

    protected abstract void internalDestroy();

    @Override
    public void destroy() {
        this.destroyed = true;
        if (this.idleReleaser != null) {
            this.idleReleaser.cancel();
        }
        this.internalDestroy();
        this.next.destroy();
    }

    @Override
    public int getPartitionCount() {
        return 1;
    }

    @Override
    public int getPartitionMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPartitionMaxSize(int newMaxSize) throws InterruptedException {
        if (newMaxSize <= 0) {
            throw new IllegalArgumentException("Max size must be positive, not " + newMaxSize);
        }
        if (newMaxSize != this.getPartitionMaxSize()) {
            this.resizeLock.writeLock().lock();
            try {
                ResizeInfo resizeInfo = new ResizeInfo(this.minSize, this.permits.availablePermits(), this.connectionCount, newMaxSize);
                this.permits = new Semaphore(newMaxSize, true);
                for (int i = 0; i < resizeInfo.getTransferCheckedOut(); ++i) {
                    this.permits.acquire();
                }
                this.shrinkLater = 0;
                this.transferConnections(newMaxSize, resizeInfo.getShrinkNow());
                this.shrinkLater = resizeInfo.getShrinkLater();
                this.minSize = resizeInfo.getNewMinSize();
                this.maxSize = newMaxSize;
                Object var5_4 = null;
                this.resizeLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.resizeLock.writeLock().unlock();
                throw throwable;
            }
        }
    }

    protected abstract boolean doRemove(ManagedConnectionInfo var1);

    protected abstract void doAdd(ManagedConnectionInfo var1);

    protected abstract Object getPool();

    protected abstract void transferConnections(int var1, int var2);

    @Override
    public abstract int getIdleConnectionCount();

    @Override
    public int getConnectionCount() {
        return this.connectionCount;
    }

    @Override
    public int getPartitionMinSize() {
        return this.minSize;
    }

    @Override
    public void setPartitionMinSize(int minSize) {
        this.minSize = minSize;
    }

    @Override
    public int getBlockingTimeoutMilliseconds() {
        return this.blockingTimeoutMilliseconds;
    }

    @Override
    public void setBlockingTimeoutMilliseconds(int blockingTimeoutMilliseconds) {
        if (blockingTimeoutMilliseconds < 0) {
            throw new IllegalArgumentException("blockingTimeoutMilliseconds must be positive or 0, not " + blockingTimeoutMilliseconds);
        }
        this.blockingTimeoutMilliseconds = blockingTimeoutMilliseconds == 0 ? Integer.MAX_VALUE : blockingTimeoutMilliseconds;
    }

    @Override
    public int getIdleTimeoutMinutes() {
        return (int)this.idleTimeoutMilliseconds / 60000;
    }

    @Override
    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        if (idleTimeoutMinutes < 0) {
            throw new IllegalArgumentException("idleTimeoutMinutes must be positive or 0, not " + idleTimeoutMinutes);
        }
        if (this.idleReleaser != null) {
            this.idleReleaser.cancel();
        }
        if (idleTimeoutMinutes > 0) {
            this.idleTimeoutMilliseconds = idleTimeoutMinutes * 60 * 1000;
            this.idleReleaser = new IdleReleaser(this);
            this.timer.schedule((TimerTask)this.idleReleaser, this.idleTimeoutMilliseconds, this.idleTimeoutMilliseconds);
        }
    }

    protected abstract void getExpiredManagedConnectionInfos(long var1, List<ManagedConnectionInfo> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addToPool(ManagedConnectionInfo mci) {
        boolean added;
        Object object = this.getPool();
        synchronized (object) {
            ++this.connectionCount;
            boolean bl = added = this.getPartitionMaxSize() > this.getIdleConnectionCount();
            if (added) {
                this.doAdd(mci);
            }
        }
        return added;
    }

    protected class FillTask
    extends TimerTask {
        private final ManagedConnectionFactory managedConnectionFactory;
        private final Subject subject;
        private final ConnectionRequestInfo cri;

        public FillTask(ConnectionInfo connectionInfo) {
            this.managedConnectionFactory = connectionInfo.getManagedConnectionInfo().getManagedConnectionFactory();
            this.subject = connectionInfo.getManagedConnectionInfo().getSubject();
            this.cri = connectionInfo.getManagedConnectionInfo().getConnectionRequestInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractSinglePoolConnectionInterceptor.this.resizeLock.readLock().lock();
            try {
                try {
                    while (AbstractSinglePoolConnectionInterceptor.this.connectionCount < AbstractSinglePoolConnectionInterceptor.this.minSize) {
                        ManagedConnectionInfo mci = new ManagedConnectionInfo(this.managedConnectionFactory, this.cri);
                        mci.setSubject(this.subject);
                        ConnectionInfo ci = new ConnectionInfo(mci);
                        try {
                            AbstractSinglePoolConnectionInterceptor.this.next.getConnection(ci);
                        }
                        catch (ResourceException e) {
                            Object var5_6 = null;
                            AbstractSinglePoolConnectionInterceptor.this.resizeLock.readLock().unlock();
                            return;
                        }
                        boolean added = AbstractSinglePoolConnectionInterceptor.this.addToPool(mci);
                        if (added) continue;
                        AbstractSinglePoolConnectionInterceptor.this.internalReturn(ci, ConnectionReturnAction.DESTROY);
                        Object var5_7 = null;
                        AbstractSinglePoolConnectionInterceptor.this.resizeLock.readLock().unlock();
                        return;
                    }
                    Object var5_8 = null;
                    AbstractSinglePoolConnectionInterceptor.this.resizeLock.readLock().unlock();
                }
                catch (Throwable t) {
                    log.error("FillTask encountered error in run method", t);
                    Object var5_9 = null;
                    AbstractSinglePoolConnectionInterceptor.this.resizeLock.readLock().unlock();
                }
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                AbstractSinglePoolConnectionInterceptor.this.resizeLock.readLock().unlock();
                throw throwable;
            }
        }
    }

    private static class IdleReleaser
    extends TimerTask {
        private AbstractSinglePoolConnectionInterceptor parent;

        private IdleReleaser(AbstractSinglePoolConnectionInterceptor parent) {
            this.parent = parent;
        }

        public boolean cancel() {
            this.parent = null;
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractSinglePoolConnectionInterceptor interceptor = this.parent;
            if (interceptor == null) {
                return;
            }
            interceptor.resizeLock.readLock().lock();
            try {
                try {
                    long threshold = System.currentTimeMillis() - interceptor.idleTimeoutMilliseconds;
                    ArrayList<ManagedConnectionInfo> killList = new ArrayList<ManagedConnectionInfo>(interceptor.getPartitionMaxSize());
                    interceptor.getExpiredManagedConnectionInfos(threshold, killList);
                    for (ManagedConnectionInfo managedConnectionInfo : killList) {
                        ConnectionInfo killInfo = new ConnectionInfo(managedConnectionInfo);
                        interceptor.internalReturn(killInfo, ConnectionReturnAction.DESTROY);
                    }
                    Object var9_8 = null;
                    interceptor.resizeLock.readLock().unlock();
                }
                catch (Throwable t) {
                    log.error("Error occurred during execution of ExpirationMonitor TimerTask", t);
                    Object var9_9 = null;
                    interceptor.resizeLock.readLock().unlock();
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                interceptor.resizeLock.readLock().unlock();
                throw throwable;
            }
        }
    }

    static final class ResizeInfo {
        private final int newMinSize;
        private final int shrinkNow;
        private final int shrinkLater;
        private final int transferCheckedOut;

        ResizeInfo(int oldMinSize, int oldPermitsAvailable, int oldConnectionCount, int newMaxSize) {
            int checkedOut = oldConnectionCount - oldPermitsAvailable;
            int shrinkLater = checkedOut - newMaxSize;
            if (shrinkLater < 0) {
                shrinkLater = 0;
            }
            this.shrinkLater = shrinkLater;
            int shrinkNow = oldConnectionCount - newMaxSize - shrinkLater;
            if (shrinkNow < 0) {
                shrinkNow = 0;
            }
            this.shrinkNow = shrinkNow;
            this.newMinSize = newMaxSize >= oldMinSize ? oldMinSize : newMaxSize;
            this.transferCheckedOut = checkedOut - shrinkLater;
        }

        public int getNewMinSize() {
            return this.newMinSize;
        }

        public int getShrinkNow() {
            return this.shrinkNow;
        }

        public int getShrinkLater() {
            return this.shrinkLater;
        }

        public int getTransferCheckedOut() {
            return this.transferCheckedOut;
        }
    }
}

