/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.security.auth.Subject;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.PoolingAttributes;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;

public class MultiPoolConnectionInterceptor
implements ConnectionInterceptor,
PoolingAttributes {
    private final ConnectionInterceptor next;
    private final PoolingSupport singlePoolFactory;
    private final boolean useSubject;
    private final boolean useCRI;
    private final Map pools = new HashMap();
    private volatile boolean destroyed = false;

    public MultiPoolConnectionInterceptor(ConnectionInterceptor next, PoolingSupport singlePoolFactory, boolean useSubject, boolean useCRI) {
        this.next = next;
        this.singlePoolFactory = singlePoolFactory;
        this.useSubject = useSubject;
        this.useCRI = useCRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
        SubjectCRIKey key = new SubjectCRIKey(this.useSubject ? mci.getSubject() : null, this.useCRI ? mci.getConnectionRequestInfo() : null);
        ConnectionInterceptor poolInterceptor = null;
        Map map = this.pools;
        synchronized (map) {
            if (this.destroyed) {
                throw new ResourceException("ConnectionManaged has been destroyed");
            }
            poolInterceptor = (ConnectionInterceptor)this.pools.get(key);
            if (poolInterceptor == null) {
                poolInterceptor = this.singlePoolFactory.addPoolingInterceptors(this.next);
                this.pools.put(key, poolInterceptor);
            }
        }
        mci.setPoolInterceptor(poolInterceptor);
        poolInterceptor.getConnection(connectionInfo);
    }

    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
        ConnectionInterceptor poolInterceptor = mci.getPoolInterceptor();
        poolInterceptor.returnConnection(connectionInfo, connectionReturnAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map map = this.pools;
        synchronized (map) {
            this.destroyed = true;
            Iterator it = this.pools.entrySet().iterator();
            while (it.hasNext()) {
                ((ConnectionInterceptor)it.next().getValue()).destroy();
                it.remove();
            }
        }
        this.next.destroy();
    }

    public int getPartitionCount() {
        return this.pools.size();
    }

    public int getPartitionMaxSize() {
        return this.singlePoolFactory.getPartitionMaxSize();
    }

    public void setPartitionMaxSize(int maxSize) throws InterruptedException {
        this.singlePoolFactory.setPartitionMaxSize(maxSize);
        Iterator iterator = this.pools.entrySet().iterator();
        while (iterator.hasNext()) {
            PoolingAttributes poolingAttributes = (PoolingAttributes)iterator.next().getValue();
            poolingAttributes.setPartitionMaxSize(maxSize);
        }
    }

    public int getPartitionMinSize() {
        return this.singlePoolFactory.getPartitionMinSize();
    }

    public void setPartitionMinSize(int minSize) {
        this.singlePoolFactory.setPartitionMinSize(minSize);
        Iterator iterator = this.pools.entrySet().iterator();
        while (iterator.hasNext()) {
            PoolingAttributes poolingAttributes = (PoolingAttributes)iterator.next().getValue();
            poolingAttributes.setPartitionMinSize(minSize);
        }
    }

    public int getIdleConnectionCount() {
        int count = 0;
        Iterator iterator = this.pools.entrySet().iterator();
        while (iterator.hasNext()) {
            PoolingAttributes poolingAttributes = (PoolingAttributes)iterator.next().getValue();
            count += poolingAttributes.getIdleConnectionCount();
        }
        return count;
    }

    public int getConnectionCount() {
        int count = 0;
        Iterator iterator = this.pools.entrySet().iterator();
        while (iterator.hasNext()) {
            PoolingAttributes poolingAttributes = (PoolingAttributes)iterator.next().getValue();
            count += poolingAttributes.getConnectionCount();
        }
        return count;
    }

    public int getBlockingTimeoutMilliseconds() {
        return this.singlePoolFactory.getBlockingTimeoutMilliseconds();
    }

    public void setBlockingTimeoutMilliseconds(int timeoutMilliseconds) {
        this.singlePoolFactory.setBlockingTimeoutMilliseconds(timeoutMilliseconds);
        Iterator iterator = this.pools.entrySet().iterator();
        while (iterator.hasNext()) {
            PoolingAttributes poolingAttributes = (PoolingAttributes)iterator.next().getValue();
            poolingAttributes.setBlockingTimeoutMilliseconds(timeoutMilliseconds);
        }
    }

    public int getIdleTimeoutMinutes() {
        return this.singlePoolFactory.getIdleTimeoutMinutes();
    }

    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        this.singlePoolFactory.setIdleTimeoutMinutes(idleTimeoutMinutes);
        Iterator iterator = this.pools.entrySet().iterator();
        while (iterator.hasNext()) {
            PoolingAttributes poolingAttributes = (PoolingAttributes)iterator.next().getValue();
            poolingAttributes.setIdleTimeoutMinutes(idleTimeoutMinutes);
        }
    }

    static class SubjectCRIKey {
        private final Subject subject;
        private final ConnectionRequestInfo cri;
        private final int hashcode;

        public SubjectCRIKey(Subject subject, ConnectionRequestInfo cri) {
            this.subject = subject;
            this.cri = cri;
            this.hashcode = (subject == null ? 17 : subject.hashCode() * 17) ^ (cri == null ? 1 : cri.hashCode());
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object other) {
            if (!(other instanceof SubjectCRIKey)) {
                return false;
            }
            SubjectCRIKey o = (SubjectCRIKey)other;
            if (this.hashcode != o.hashcode) {
                return false;
            }
            return this.subject == null ? o.subject == null : (this.subject.equals(o.subject) && this.cri == null ? o.cri == null : this.cri.equals(o.cri));
        }
    }
}

