/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.Filter;
import org.apache.geode.management.internal.rest.security.GeodeAuthenticationProvider;
import org.apache.geode.management.internal.rest.security.JwtAuthenticationFilter;
import org.apache.geode.management.internal.rest.security.RestSecurityConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.web.multipart.MultipartResolver;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@ComponentScan(value={"org.apache.geode.management.internal.rest"})
public class RestSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    private GeodeAuthenticationProvider authProvider;
    @Autowired
    private ObjectMapper objectMapper;

    protected void configure(AuthenticationManagerBuilder auth) {
        auth.authenticationProvider((AuthenticationProvider)this.authProvider);
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Bean
    public MultipartResolver multipartResolver() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(new String[]{"/docs/**", "/swagger-ui.html", "/swagger-ui/index.html", "/swagger-ui/**", "/", "/v1/api-docs/**", "/webjars/springdoc-openapi-ui/**", "/v3/api-docs/**", "/swagger-resources/**"})).permitAll().and()).csrf().disable();
        if (this.authProvider.getSecurityService().isIntegratedSecurity()) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated();
            if (this.authProvider.isAuthTokenEnabled()) {
                JwtAuthenticationFilter tokenEndpointFilter = new JwtAuthenticationFilter();
                tokenEndpointFilter.setAuthenticationSuccessHandler((request, response, authentication) -> {});
                tokenEndpointFilter.setAuthenticationFailureHandler((request, response, exception) -> {});
                http.addFilterBefore((Filter)tokenEndpointFilter, BasicAuthenticationFilter.class);
            }
            http.httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)new AuthenticationFailedHandler(this, null));
        }
    }

    static /* synthetic */ ObjectMapper access$100(RestSecurityConfiguration x0) {
        return x0.objectMapper;
    }
}

