/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.api.ClusterManagementException;
import org.apache.geode.management.api.ClusterManagementRealizationException;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.internal.rest.controllers.ManagementControllerAdvice;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperFactoryBean;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@ControllerAdvice
public class ManagementControllerAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger logger = LogService.getLogger();
    private String requestContext;
    @Autowired
    private Jackson2ObjectMapperFactoryBean objectMapperFactory;

    public boolean supports(MethodParameter returnType, Class converterType) {
        return AbstractJackson2HttpMessageConverter.class.isAssignableFrom(converterType);
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        boolean includeClass;
        List values = request.getHeaders().get((Object)"X-Include-Class");
        boolean bl = includeClass = values != null && values.contains("true");
        if (this.requestContext == null) {
            this.requestContext = ServletUriComponentsBuilder.fromCurrentContextPath().build().toString();
        }
        try {
            ObjectMapper objectMapper = this.objectMapperFactory.getObject();
            String json = objectMapper.writeValueAsString(body);
            if (!includeClass) {
                json = ManagementControllerAdvice.removeClassFromJsonText((String)json);
            }
            json = ManagementControllerAdvice.qualifyHrefsInJsonText((String)json, (String)this.requestContext);
            response.getHeaders().add("Content-Type", "application/json;charset=UTF-8");
            response.getBody().write(json.getBytes());
            response.close();
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String removeClassFromJsonText(String json) {
        return json.replaceAll("\"[^\"]*\":\\{\"class\":\"[^\"]*\"},?", "").replaceAll("\"class\":\"[^\"]*\",", "");
    }

    static String qualifyHrefsInJsonText(String json, String requestContext) {
        if (requestContext == null) {
            return json;
        }
        return json.replace("#HREF/management", requestContext);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ClusterManagementResult> internalError(Exception e) {
        logger.error(e.getMessage(), (Throwable)e);
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.ERROR, this.cleanup(e.getMessage())), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private String cleanup(String message) {
        if (message == null) {
            return "";
        }
        return message.replace("java.lang.Exception: ", "").replace("java.lang.RuntimeException: ", "").replace("java.util.concurrent.ExecutionException: ", "");
    }

    @ExceptionHandler(value={ClusterManagementException.class})
    public ResponseEntity<ClusterManagementResult> clusterManagementException(Exception e) {
        ClusterManagementResult result = ((ClusterManagementException)e).getResult();
        return new ResponseEntity((Object)result, this.mapToHttpStatus(result.getStatusCode()));
    }

    @ExceptionHandler(value={ClusterManagementRealizationException.class})
    public ResponseEntity<ClusterManagementRealizationResult> clusterManagementRealizationException(Exception e) {
        ClusterManagementRealizationResult result = (ClusterManagementRealizationResult)((ClusterManagementException)e).getResult();
        return new ResponseEntity((Object)result, this.mapToHttpStatus(result.getStatusCode()));
    }

    private HttpStatus mapToHttpStatus(ClusterManagementResult.StatusCode statusCode) {
        switch (1.$SwitchMap$org$apache$geode$management$api$ClusterManagementResult$StatusCode[statusCode.ordinal()]) {
            case 1: {
                return HttpStatus.CONFLICT;
            }
            case 2: {
                return HttpStatus.NOT_FOUND;
            }
            case 3: {
                return HttpStatus.BAD_REQUEST;
            }
        }
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }

    @ExceptionHandler(value={AuthenticationFailedException.class, AuthenticationException.class})
    public ResponseEntity<ClusterManagementResult> unauthorized(Exception e) {
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.UNAUTHENTICATED, e.getMessage()), HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={NotAuthorizedException.class, SecurityException.class})
    public ResponseEntity<ClusterManagementResult> forbidden(Exception e) {
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.UNAUTHORIZED, e.getMessage()), HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={IllegalArgumentException.class, HttpMessageNotReadableException.class})
    public ResponseEntity<ClusterManagementResult> badRequest(Exception e) {
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.ILLEGAL_ARGUMENT, e.getMessage()), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<ClusterManagementResult> handleException(AccessDeniedException cause) {
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.UNAUTHORIZED, cause.getMessage()), HttpStatus.FORBIDDEN);
    }
}

