/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.api.ClusterManagementGetResult;
import org.apache.geode.management.api.ClusterManagementListResult;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.GatewayReceiver;
import org.apache.geode.management.internal.rest.controllers.AbstractManagementController;
import org.apache.geode.management.runtime.GatewayReceiverInfo;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="gatewayManagement")
@RequestMapping(value={"/v1"})
public class GatewayManagementController
extends AbstractManagementController {
    @Operation(summary="list gateway-receivers")
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ')")
    @GetMapping(value={"/gateways/receivers"})
    public ClusterManagementListResult<GatewayReceiver, GatewayReceiverInfo> listGatewayReceivers(@RequestParam(required=false) String group) {
        GatewayReceiver filter = new GatewayReceiver();
        if (StringUtils.isNotBlank((CharSequence)group)) {
            filter.setGroup(group);
        }
        return this.clusterManagementService.list((AbstractConfiguration)filter);
    }

    @Operation(summary="get gateway-receiver")
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ')")
    @GetMapping(value={"/gateways/receivers/{id:.+}"})
    public ClusterManagementGetResult<GatewayReceiver, GatewayReceiverInfo> getGatewayReceiver(@PathVariable(name="id") String id) {
        GatewayReceiver config = new GatewayReceiver();
        config.setGroup(id);
        return this.clusterManagementService.get((AbstractConfiguration)config);
    }

    @Operation(summary="create gateway-receiver")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Bad request."), @ApiResponse(responseCode="409", description="Gateway receiver already exists."), @ApiResponse(responseCode="500", description="Internal error.")})
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'MANAGE')")
    @PostMapping(value={"/gateways/receivers"})
    public ResponseEntity<ClusterManagementResult> createGatewayReceiver(@RequestBody GatewayReceiver gatewayReceiverConfig) {
        ClusterManagementRealizationResult result = this.clusterManagementService.create((AbstractConfiguration)gatewayReceiverConfig);
        return new ResponseEntity((Object)result, HttpStatus.CREATED);
    }
}

