/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.api.ClusterManagementGetResult;
import org.apache.geode.management.api.ClusterManagementListResult;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.DiskStore;
import org.apache.geode.management.internal.rest.controllers.AbstractManagementController;
import org.apache.geode.management.runtime.DiskStoreInfo;
import org.apache.geode.security.ResourcePermission;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="diskStoreManagement")
@RequestMapping(value={"/v1"})
public class DiskStoreController
extends AbstractManagementController {
    @Operation(summary="create disk-store")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Bad request."), @ApiResponse(responseCode="409", description="Diskstore already exists."), @ApiResponse(responseCode="500", description="Internal error.")})
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'MANAGE')")
    @PostMapping(value={"/diskstores"})
    public ResponseEntity<ClusterManagementResult> createDiskStore(@RequestBody DiskStore diskStoreConfig) {
        ClusterManagementRealizationResult result = this.clusterManagementService.create((AbstractConfiguration)diskStoreConfig);
        return new ResponseEntity((Object)result, HttpStatus.CREATED);
    }

    @Operation(summary="list disk-stores", extensions={@Extension(properties={@ExtensionProperty(name="jqFilter", value=".result[] | .groups[] | .runtimeInfo[] + .configuration | {Member:.memberName,\"Disk Store Name\":.name}")})})
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ')")
    @GetMapping(value={"/diskstores"})
    public ClusterManagementListResult<DiskStore, DiskStoreInfo> listDiskStores(@RequestParam(required=false) String id, @RequestParam(required=false) String group) {
        DiskStore filter = new DiskStore();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            filter.setName(id);
        }
        if (StringUtils.isNotBlank((CharSequence)group)) {
            filter.setGroup(group);
        }
        return this.clusterManagementService.list((AbstractConfiguration)filter);
    }

    @Operation(summary="get disk-store", extensions={@Extension(properties={@ExtensionProperty(name="jqFilter", value=".result | .groups[] | .runtimeInfo[] + .configuration | {Member:.memberName,\"Disk Store Name\":.name}")})})
    @GetMapping(value={"/diskstores/{id}"})
    public ClusterManagementGetResult<DiskStore, DiskStoreInfo> getDiskStore(@PathVariable(name="id") String id) {
        this.securityService.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.READ, id);
        DiskStore config = new DiskStore();
        config.setName(id);
        return this.clusterManagementService.get((AbstractConfiguration)config);
    }

    @Operation(summary="delete disk-store")
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'MANAGE')")
    @DeleteMapping(value={"/diskstores/{id}"})
    public ClusterManagementResult deleteDiskStore(@PathVariable(name="id") String id, @RequestParam(required=false) String group) {
        DiskStore config = new DiskStore();
        config.setName(id);
        if (StringUtils.isNotBlank((CharSequence)group)) {
            config.setGroup(group);
        }
        return this.clusterManagementService.delete((AbstractConfiguration)config);
    }
}

