/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.internal.rest.security.GeodeAuthenticationProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@ComponentScan(value={"org.apache.geode.management.internal.rest"})
public class RestSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    private GeodeAuthenticationProvider authProvider;
    @Autowired
    private ObjectMapper objectMapper;

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.authProvider);
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(new String[]{"/ping", "/docs/**", "/swagger-ui.html", "/experimental/api-docs/**", "/webjars/springfox-swagger-ui/**", "/swagger-resources/**"})).permitAll().anyRequest()).authenticated().and()).csrf().disable();
        if (this.authProvider.getSecurityService().isIntegratedSecurity()) {
            http.httpBasic().authenticationEntryPoint(new AuthenticationEntryPoint(){

                public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
                    response.addHeader("WWW-Authenticate", "Basic realm=\"GEODE\"");
                    response.setStatus(401);
                    response.setContentType("application/json;charset=UTF-8");
                    ClusterManagementResult result = new ClusterManagementResult(ClusterManagementResult.StatusCode.UNAUTHENTICATED, authException.getMessage());
                    RestSecurityConfiguration.this.objectMapper.writeValue((Writer)response.getWriter(), (Object)result);
                }
            });
        } else {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).permitAll();
        }
    }
}

