/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.geode.CancelException;
import org.apache.geode.GemFireException;
import org.apache.geode.GemFireIOException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.SenderProxy;
import org.apache.geode.cache.client.internal.pooling.ConnectionDestroyedException;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.cache.tier.sockets.MessageTooLargeException;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.BatchException70;
import org.apache.geode.internal.cache.wan.GatewaySenderEventDispatcher;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.cache.wan.GatewaySenderException;
import org.apache.geode.internal.cache.wan.GatewaySenderStats;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.pdx.PdxRegistryMismatchException;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;

public class GatewaySenderEventRemoteDispatcher
implements GatewaySenderEventDispatcher {
    private static final Logger logger = LogService.getLogger();
    protected final AbstractGatewaySenderEventProcessor processor;
    private volatile Connection connection;
    private final Set<String> notFoundRegions = new HashSet<String>();
    private final Object notFoundRegionsSync = new Object();
    private final AbstractGatewaySender sender;
    private AckReaderThread ackReaderThread;
    private ReentrantReadWriteLock connectionLifeCycleLock = new ReentrantReadWriteLock();
    private int failedConnectCount = 0;

    void setAckReaderThread(AckReaderThread ackReaderThread) {
        this.ackReaderThread = ackReaderThread;
    }

    public GatewaySenderEventRemoteDispatcher(AbstractGatewaySenderEventProcessor eventProcessor) {
        this.processor = eventProcessor;
        this.sender = eventProcessor.getSender();
        try {
            this.initializeConnection();
        }
        catch (GatewaySenderException gatewaySenderException) {
            // empty catch block
        }
    }

    GatewaySenderEventRemoteDispatcher(AbstractGatewaySenderEventProcessor processor, Connection connection) {
        this.processor = processor;
        this.sender = processor.getSender();
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GatewayAck readAcknowledgement() {
        GatewayAck ack;
        block15: {
            SenderProxy sp = new SenderProxy((InternalPool)this.processor.getSender().getProxy());
            ack = null;
            try {
                this.connection = this.getConnection(false);
                if (logger.isDebugEnabled()) {
                    logger.debug(" Receiving ack on the thread {}", (Object)this.connection);
                }
                this.connectionLifeCycleLock.readLock().lock();
                try {
                    if (this.connection != null && !this.processor.isStopped()) {
                        ack = (GatewayAck)sp.receiveAckFromReceiver(this.connection);
                    }
                }
                finally {
                    this.connectionLifeCycleLock.readLock().unlock();
                }
            }
            catch (Exception e) {
                Object ex;
                Throwable t = e.getCause();
                if (t instanceof BatchException70) {
                    ex = (BatchException70)t;
                } else if (e instanceof GatewaySenderException) {
                    ex = (Exception)e.getCause();
                } else {
                    ex = e;
                    this.destroyConnection();
                }
                if (this.sender.getProxy() == null || this.sender.getProxy().isDestroyed()) break block15;
                if (ex instanceof IOException || ex instanceof ServerConnectivityException && !(((Throwable)ex).getCause() instanceof PdxRegistryMismatchException) || ex instanceof ConnectionDestroyedException) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (!(ex instanceof CancelException)) {
                    logger.fatal("Stopping the processor because the following exception occurred while processing a batch:", (Throwable)ex);
                }
                this.processor.setIsStopped(true);
            }
        }
        return ack;
    }

    public boolean dispatchBatch(List events, boolean removeFromQueueOnException, boolean isRetry) {
        boolean success;
        block10: {
            GatewaySenderStats statistics = this.sender.getStatistics();
            success = false;
            try {
                long start = statistics.startTime();
                success = this._dispatchBatch(events, isRetry);
                if (success) {
                    statistics.endBatch(start, events.size());
                }
            }
            catch (GatewaySenderException ge) {
                Throwable t = ge.getCause();
                if (this.sender.getProxy() == null || this.sender.getProxy().isDestroyed()) break block10;
                if (t instanceof IOException || t instanceof ServerConnectivityException || t instanceof ConnectionDestroyedException || t instanceof IllegalStateException || t instanceof GemFireSecurityException) {
                    this.processor.handleException();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Because of IOException, failed to dispatch a batch with id : {}", (Object)this.processor.getBatchId());
                    }
                }
                logger.fatal("Stopping the processor because the following exception occurred while processing a batch:", (Throwable)ge);
                this.processor.setIsStopped(true);
            }
            catch (CancelException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Stopping the processor because cancellation occurred while processing a batch");
                }
                this.processor.setIsStopped(true);
                throw e;
            }
            catch (Exception e) {
                this.processor.setIsStopped(true);
                logger.fatal("Stopping the processor because the following exception occurred while processing a batch:", (Throwable)e);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _dispatchBatch(List events, boolean isRetry) {
        Throwable ex = null;
        int currentBatchId = this.processor.getBatchId();
        this.connection = this.getConnection(true);
        int batchIdForThisConnection = this.processor.getBatchId();
        GatewaySenderStats statistics = this.sender.getStatistics();
        if (currentBatchId != batchIdForThisConnection || this.processor.isConnectionReset()) {
            return false;
        }
        try {
            block16: {
                if (this.processor.isConnectionReset()) {
                    isRetry = true;
                }
                SenderProxy sp = new SenderProxy((InternalPool)this.sender.getProxy());
                this.connectionLifeCycleLock.readLock().lock();
                try {
                    if (this.connection != null) {
                        sp.dispatchBatch_NewWAN(this.connection, events, currentBatchId, this.sender.isRemoveFromQueueOnException(), isRetry);
                        if (logger.isDebugEnabled()) {
                            logger.debug("{} : Dispatched batch (id={}) of {} events, queue size: {} on connection {}", (Object)this.processor.getSender(), (Object)currentBatchId, (Object)events.size(), (Object)this.processor.getQueue().size(), (Object)this.connection);
                        }
                        break block16;
                    }
                    throw new ConnectionDestroyedException();
                }
                finally {
                    this.connectionLifeCycleLock.readLock().unlock();
                }
            }
            return true;
        }
        catch (ServerOperationException e) {
            Throwable t = e.getCause();
            if (t instanceof BatchException70) {
                ex = (BatchException70)t;
            } else {
                ex = e;
                this.destroyConnection();
            }
            throw new GatewaySenderException(String.format("%s : Exception during processing batch %s on connection %s", this, currentBatchId, this.connection), ex);
        }
        catch (GemFireIOException e) {
            Throwable t = e.getCause();
            if (t instanceof MessageTooLargeException) {
                ex = (MessageTooLargeException)t;
                int newBatchSize = Math.min(events.size(), this.processor.getBatchSize()) / 2;
                logger.warn(String.format("The following exception occurred attempting to send a batch of %s events. The batch will be tried again after reducing the batch size to %s events.", events.size(), newBatchSize), (Throwable)e);
                this.processor.setBatchSize(newBatchSize);
                statistics.incBatchesResized();
            } else {
                ex = e;
                this.destroyConnection();
            }
            throw new GatewaySenderException(String.format("%s : Exception during processing batch %s on connection %s", this, currentBatchId, this.connection), ex);
        }
        catch (IllegalStateException e) {
            this.processor.setException((GemFireException)new GatewaySenderException((Throwable)e));
            throw new GatewaySenderException(String.format("%s : Exception during processing batch %s on connection %s", this, currentBatchId, this.connection), (Throwable)e);
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            ex = t instanceof IOException ? (IOException)t : e;
            this.destroyConnection();
            throw new GatewaySenderException(String.format("%s : Exception during processing batch %s on connection %s", this, currentBatchId, this.connection), ex);
        }
    }

    public Connection getConnection(boolean startAckReaderThread) throws GatewaySenderException {
        InternalCache cache;
        if (this.processor.isStopped()) {
            this.stop();
            return null;
        }
        if (!this.sender.isParallel()) {
            if (this.connection == null || this.connection.isDestroyed() || !this.connection.getServer().equals((Object)this.sender.getServerLocation())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Initializing new connection as serverLocation of old connection is : {} and the serverLocation to connect is {}", (Object)(this.connection == null ? "null" : this.connection.getServer()), (Object)this.sender.getServerLocation());
                }
                this.initializeConnection();
            }
        } else if (this.connection == null || this.connection.isDestroyed()) {
            this.initializeConnection();
        }
        if (!((cache = this.sender.getCache()) == null || cache.isClosed() || !this.sender.isPrimary() || this.connection == null || this.ackReaderThread != null && this.ackReaderThread.isRunning())) {
            this.ackReaderThread = new AckReaderThread((GatewaySender)this.sender, this.processor);
            this.ackReaderThread.start();
            this.ackReaderThread.waitForRunningAckReaderThreadRunningState();
        }
        return this.connection;
    }

    public void destroyConnection() {
        this.connectionLifeCycleLock.writeLock().lock();
        try {
            Connection con = this.connection;
            if (con != null) {
                if (!con.isDestroyed()) {
                    con.destroy();
                    this.sender.getProxy().returnConnection(con);
                }
                this.connection = null;
                this.sender.setServerLocation(null);
            }
        }
        finally {
            this.connectionLifeCycleLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeConnection() throws GatewaySenderException, GemFireSecurityException {
        if (this.ackReaderThread != null) {
            this.ackReaderThread.shutDownAckReaderConnection(this.connection);
        }
        this.connectionLifeCycleLock.writeLock().lock();
        try {
            Object[] logArgs;
            Connection con;
            block23: {
                if (this.sender.getProxy() == null || this.sender.getProxy().isDestroyed()) {
                    this.sender.initProxy();
                } else {
                    this.processor.resetBatchId();
                }
                try {
                    if (this.sender.isParallel()) {
                        con = this.sender.getProxy().acquireConnection();
                        this.sender.setServerLocation(con.getServer());
                        break block23;
                    }
                    Object object = this.sender.getLockForConcurrentDispatcher();
                    synchronized (object) {
                        ServerLocation server = this.sender.getServerLocation();
                        if (server != null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("ServerLocation is: {}. Connecting to this serverLocation...", (Object)server);
                            }
                            con = this.sender.getProxy().acquireConnection(server);
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug("ServerLocation is null. Creating new connection. ");
                            }
                            con = this.sender.getProxy().acquireConnection();
                            if (this.sender.isPrimary()) {
                                if (this.sender.getServerLocation() == null) {
                                    this.sender.setServerLocation(con.getServer());
                                }
                                new UpdateAttributesProcessor((DistributionAdvisee)this.sender).distribute(false);
                            }
                        }
                    }
                }
                catch (ServerConnectivityException e) {
                    GatewaySenderException gse = this.getInitializeConnectionExceptionToThrow(e);
                    this.sender.setServerLocation(null);
                    if (this.logConnectionFailure()) {
                        logger.warn("{} : Could not connect due to: {}", (Object)this.processor.getSender().getId(), (Object)gse.getCause().getMessage());
                    }
                    ++this.failedConnectCount;
                    throw gse;
                }
            }
            if (this.failedConnectCount > 0) {
                logArgs = new Object[]{this.processor.getSender().getId(), con, this.failedConnectCount};
                logger.info("{}: Using {} after {} failed connect attempts", logArgs);
                this.failedConnectCount = 0;
            } else {
                logArgs = new Object[]{this.processor.getSender().getId(), con};
                logger.info("{}: Using {}", logArgs);
            }
            this.connection = con;
            this.processor.checkIfPdxNeedsResend(this.connection.getQueueStatus().getPdxSize());
        }
        catch (ConnectionDestroyedException e) {
            throw new GatewaySenderException(String.format("%s : Could not connect due to: %s", this.processor.getSender().getId(), e.getMessage()), (Throwable)e);
        }
        finally {
            this.connectionLifeCycleLock.writeLock().unlock();
        }
    }

    private GatewaySenderException getInitializeConnectionExceptionToThrow(ServerConnectivityException e) {
        GatewaySenderException gse = null;
        if (e.getCause() instanceof GemFireSecurityException) {
            gse = new GatewaySenderException(e.getCause());
        } else {
            String ioMsg;
            List servers = this.sender.getProxy().getCurrentServers();
            if (servers.size() == 0) {
                ioMsg = "There are no active servers.";
            } else {
                StringBuilder buffer = new StringBuilder();
                for (ServerLocation server : servers) {
                    String endpointName = String.valueOf(server);
                    if (buffer.length() > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(endpointName);
                }
                ioMsg = String.format("No available connection was found, but the following active servers exist: %s", buffer.toString());
            }
            IOException ex = new IOException(ioMsg);
            gse = new GatewaySenderException(String.format("%s : Could not connect due to: %s", this.processor.getSender().getId(), ex.getMessage()), (Throwable)ex);
        }
        return gse;
    }

    protected boolean logConnectionFailure() {
        if (logger.isDebugEnabled() || this.failedConnectCount == 0) {
            return true;
        }
        if (this.failedConnectCount >= 3000) {
            return this.failedConnectCount % 3000 == 0;
        }
        return this.failedConnectCount == 30 || this.failedConnectCount == 300;
    }

    public void stopAckReaderThread() {
        if (this.ackReaderThread != null) {
            this.ackReaderThread.shutdown();
        }
    }

    public boolean isRemoteDispatcher() {
        return true;
    }

    public boolean isConnectedToRemote() {
        return this.connection != null && !this.connection.isDestroyed();
    }

    public void shutDownAckReaderConnection() {
        if (this.ackReaderThread != null) {
            this.ackReaderThread.shutDownAckReaderConnection(this.connection);
            this.ackReaderThread.shutdown();
        }
    }

    public void stop() {
        this.stopAckReaderThread();
        if (this.processor.isStopped()) {
            this.destroyConnection();
        }
    }

    class AckReaderThread
    extends Thread {
        private Object runningStateLock;
        private volatile boolean shutdown;
        private final InternalCache cache;
        private volatile boolean ackReaderThreadRunning;

        public AckReaderThread(GatewaySender sender, AbstractGatewaySenderEventProcessor processor) {
            this(sender, processor.getName());
        }

        boolean isShutdown() {
            return this.shutdown;
        }

        public AckReaderThread(GatewaySender sender, String name) {
            super("AckReaderThread for : " + name);
            this.runningStateLock = new Object();
            this.shutdown = false;
            this.ackReaderThreadRunning = false;
            this.setDaemon(true);
            this.cache = ((AbstractGatewaySender)sender).getCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForRunningAckReaderThreadRunningState() {
            Object object = this.runningStateLock;
            synchronized (object) {
                while (!this.ackReaderThreadRunning) {
                    try {
                        this.runningStateLock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
        }

        private boolean checkCancelled() {
            if (this.shutdown) {
                return true;
            }
            return this.cache.getCancelCriterion().isCancelInProgress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block24: {
                if (logger.isDebugEnabled()) {
                    logger.debug("AckReaderThread started.. ");
                }
                Object object = this.runningStateLock;
                synchronized (object) {
                    this.ackReaderThreadRunning = true;
                    this.runningStateLock.notifyAll();
                }
                block13: while (true) {
                    try {
                        while (true) {
                            if (this.checkCancelled()) {
                                break block24;
                            }
                            GatewayAck ack = GatewaySenderEventRemoteDispatcher.this.readAcknowledgement();
                            if (ack != null) {
                                boolean gotBatchException = ack.getBatchException() != null;
                                int batchId = ack.getBatchId();
                                int numEvents = ack.getNumEvents();
                                if (gotBatchException) {
                                    logger.warn("Gateway Sender {} : Received ack for batch id {} with one or more exceptions", (Object)GatewaySenderEventRemoteDispatcher.this.processor.getSender(), (Object)ack.getBatchId());
                                    GatewaySenderStats statistics = GatewaySenderEventRemoteDispatcher.this.sender.getStatistics();
                                    statistics.incBatchesRedistributed();
                                    if (GatewaySenderEventRemoteDispatcher.this.sender.isRemoveFromQueueOnException()) {
                                        this.logBatchExceptions(ack.getBatchException());
                                        GatewaySenderEventRemoteDispatcher.this.processor.handleSuccessBatchAck(batchId);
                                        continue;
                                    }
                                    this.logBatchExceptions(ack.getBatchException());
                                    GatewaySenderEventRemoteDispatcher.this.processor.handleSuccessBatchAck(batchId);
                                    continue;
                                }
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Gateway Sender {} : Received ack for batch id {} of {} events", (Object)GatewaySenderEventRemoteDispatcher.this.processor.getSender(), (Object)ack.getBatchId(), (Object)ack.getNumEvents());
                                }
                                GatewaySenderEventRemoteDispatcher.this.processor.handleSuccessBatchAck(batchId);
                                continue;
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("{}: Received null ack from remote site.", (Object)GatewaySenderEventRemoteDispatcher.this.processor.getSender());
                            }
                            GatewaySenderEventRemoteDispatcher.this.processor.handleException();
                            try {
                                Thread.sleep(GatewaySender.CONNECTION_RETRY_INTERVAL);
                                continue block13;
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (!this.checkCancelled()) {
                            logger.fatal("Stopping the processor because the following exception occurred while processing a batch:", (Throwable)e);
                        }
                        GatewaySenderEventRemoteDispatcher.this.sender.getLifeCycleLock().writeLock().lock();
                        try {
                            GatewaySenderEventRemoteDispatcher.this.processor.stopProcessing();
                            GatewaySenderEventRemoteDispatcher.this.sender.clearTempEventsAfterSenderStopped();
                            break block24;
                        }
                        finally {
                            GatewaySenderEventRemoteDispatcher.this.sender.getLifeCycleLock().writeLock().unlock();
                        }
                    }
                }
                finally {
                    if (logger.isDebugEnabled()) {
                        logger.debug("AckReaderThread exiting. ");
                    }
                    this.ackReaderThreadRunning = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void logBatchExceptions(BatchException70 exception) {
            try {
                for (BatchException70 be : exception.getExceptions()) {
                    List[] eventsArr;
                    boolean logWarning = true;
                    if (be.getCause() instanceof RegionDestroyedException) {
                        RegionDestroyedException rde = (RegionDestroyedException)be.getCause();
                        Iterator iterator = GatewaySenderEventRemoteDispatcher.this.notFoundRegionsSync;
                        synchronized (iterator) {
                            if (GatewaySenderEventRemoteDispatcher.this.notFoundRegions.contains(rde.getRegionFullPath())) {
                                logWarning = false;
                            } else {
                                GatewaySenderEventRemoteDispatcher.this.notFoundRegions.add(rde.getRegionFullPath());
                            }
                        }
                    } else if (be.getCause() instanceof IllegalStateException && be.getCause().getMessage().contains("Unknown pdx type")) {
                        List pdxEvents = (List)GatewaySenderEventRemoteDispatcher.this.processor.getBatchIdToPDXEventsMap().get(be.getBatchId());
                        if (logWarning) {
                            logger.warn(String.format("A BatchException occurred processing PDX events. Index of array of Exception : %s", be.getIndex()), (Throwable)be);
                        }
                        if (pdxEvents == null) continue;
                        for (GatewaySenderEventImpl senderEvent : pdxEvents) {
                            senderEvent.isAcked = false;
                        }
                        GatewaySenderEventImpl gsEvent = (GatewaySenderEventImpl)pdxEvents.get(be.getIndex());
                        if (!logWarning) continue;
                        logger.warn("The event being processed when the BatchException occurred was:  {}", (Object)gsEvent);
                        continue;
                    }
                    if (logWarning) {
                        logger.warn(String.format("A BatchException occurred processing events. Index of Array of Exception : %s", be.getIndex()), (Throwable)be);
                    }
                    if ((eventsArr = (List[])GatewaySenderEventRemoteDispatcher.this.processor.getBatchIdToEventsMap().get(be.getBatchId())) == null) continue;
                    List filteredEvents = eventsArr[1];
                    GatewaySenderEventImpl gsEvent = (GatewaySenderEventImpl)filteredEvents.get(be.getIndex());
                    if (!logWarning) continue;
                    logger.warn("The event being processed when the BatchException occurred was:  {}", (Object)gsEvent);
                }
            }
            catch (Exception e) {
                logger.warn("An unexpected exception occurred processing a BatchException. The thread will continue.", (Throwable)e);
            }
        }

        boolean isRunning() {
            return this.ackReaderThreadRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Connection conn = GatewaySenderEventRemoteDispatcher.this.connection;
            if (conn != null) {
                this.shutDownAckReaderConnection(conn);
                if (!conn.isDestroyed()) {
                    conn.destroy();
                    GatewaySenderEventRemoteDispatcher.this.sender.getProxy().returnConnection(conn);
                }
            }
            this.shutdown = true;
            boolean interrupted = Thread.interrupted();
            try {
                this.join(15000L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.isAlive()) {
                logger.warn("AckReaderThread ignored cancellation");
            }
        }

        protected void shutDownAckReaderConnection(Connection connection) {
            Connection conn = connection;
            try {
                if (conn != null && conn.getInputStream() != null) {
                    conn.getInputStream().close();
                }
            }
            catch (IOException e) {
                logger.warn("Unable to shutdown AckReaderThread Connection");
            }
            catch (ConnectionDestroyedException e) {
                logger.info("AckReader shutting down and connection already destroyed");
            }
        }
    }

    public static class GatewayAck {
        private int batchId;
        private int numEvents;
        private BatchException70 be;

        public GatewayAck(BatchException70 be, int bId) {
            this.be = be;
            this.batchId = bId;
        }

        public GatewayAck(int batchId, int numEvents) {
            this.batchId = batchId;
            this.numEvents = numEvents;
        }

        public int getNumEvents() {
            return this.numEvents;
        }

        public int getBatchId() {
            return this.batchId;
        }

        public BatchException70 getBatchException() {
            return this.be;
        }
    }
}

