/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal.locator.wan;

import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorHelper;
import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorMembershipListener;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorJoinRequest;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorJoinResponse;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorPingRequest;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorPingResponse;
import com.gemstone.gemfire.distributed.internal.WanLocatorDiscoverer;
import com.gemstone.gemfire.distributed.internal.tcpserver.TcpClient;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.tcp.ConnectionException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class LocatorDiscovery {
    private static final Logger logger = LogService.getLogger();
    private WanLocatorDiscoverer discoverer;
    private DistributionLocatorId locatorId;
    private LocatorMembershipListener locatorListener;
    RemoteLocatorJoinRequest request;
    public static final int WAN_LOCATOR_CONNECTION_RETRY_ATTEMPT = Integer.getInteger("WANLocator.CONNECTION_RETRY_ATTEMPT", 50000);
    public static final int WAN_LOCATOR_CONNECTION_INTERVAL = Integer.getInteger("WANLocator.CONNECTION_INTERVAL", 10000);
    public static final int WAN_LOCATOR_PING_INTERVAL = Integer.getInteger("WANLocator.PING_INTERVAL", 10000);
    private final ConcurrentHashMap<DistributionLocatorId, long[]> failureLogInterval = new ConcurrentHashMap();
    private static final int FAILURE_MAP_MAXSIZE = Integer.getInteger("gemfire.GatewaySender.FAILURE_MAP_MAXSIZE", 1000000);
    private static final int FAILURE_LOG_MAX_INTERVAL = Integer.getInteger("gemfire.LocatorDiscovery.FAILURE_LOG_MAX_INTERVAL", 300000);

    public LocatorDiscovery(WanLocatorDiscoverer discoverer, DistributionLocatorId locotor, RemoteLocatorJoinRequest request, LocatorMembershipListener locatorListener) {
        this.discoverer = discoverer;
        this.locatorId = locotor;
        this.request = request;
        this.locatorListener = locatorListener;
    }

    public final boolean skipFailureLogging(DistributionLocatorId locatorId) {
        boolean skipLogging = false;
        if (this.failureLogInterval.size() < FAILURE_MAP_MAXSIZE) {
            long[] logInterval = this.failureLogInterval.get(locatorId);
            if (logInterval == null) {
                logInterval = this.failureLogInterval.putIfAbsent(locatorId, new long[]{System.currentTimeMillis(), 1000L});
            }
            if (logInterval != null) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - logInterval[0] < logInterval[1]) {
                    skipLogging = true;
                } else {
                    logInterval[0] = currentTime;
                    if (logInterval[1] <= (long)(FAILURE_LOG_MAX_INTERVAL / 2)) {
                        logInterval[1] = logInterval[1] * 2L;
                    }
                }
            }
        }
        return skipLogging;
    }

    private WanLocatorDiscoverer getDiscoverer() {
        return this.discoverer;
    }

    private void exchangeLocalLocators() {
        int retryAttempt = 1;
        while (!this.getDiscoverer().isStopped()) {
            try {
                RemoteLocatorJoinResponse response = (RemoteLocatorJoinResponse)TcpClient.requestToServer((InetAddress)this.locatorId.getHost(), (int)this.locatorId.getPort(), (Object)this.request, (int)WanLocatorDiscoverer.WAN_LOCATOR_CONNECTION_TIMEOUT);
                if (response == null) continue;
                LocatorHelper.addExchnagedLocators(response.getLocators(), this.locatorListener);
                logger.info((Message)LocalizedMessage.create((StringId)LocalizedStrings.LOCATOR_DISCOVERY_TASK_EXCHANGED_LOCATOR_INFORMATION_0_WITH_1, (Object[])new Object[]{this.request.getLocator(), this.locatorId}));
                break;
            }
            catch (IOException ioe) {
                if (retryAttempt == WAN_LOCATOR_CONNECTION_RETRY_ATTEMPT) {
                    ConnectionException coe = new ConnectionException("Not able to connect to local locator after " + WAN_LOCATOR_CONNECTION_RETRY_ATTEMPT + " retry attempts", (Throwable)ioe);
                    logger.fatal((Message)LocalizedMessage.create((StringId)LocalizedStrings.LOCATOR_DISCOVERY_TASK_COULD_NOT_EXCHANGE_LOCATOR_INFORMATION_0_WITH_1_AFTER_2, (Object[])new Object[]{this.request.getLocator(), this.locatorId, retryAttempt}), (Throwable)coe);
                    break;
                }
                if (this.skipFailureLogging(this.locatorId)) {
                    logger.warn((Message)LocalizedMessage.create((StringId)LocalizedStrings.LOCATOR_DISCOVERY_TASK_COULD_NOT_EXCHANGE_LOCATOR_INFORMATION_0_WITH_1_AFTER_2_RETRYING_IN_3_MS, (Object[])new Object[]{this.request.getLocator(), this.locatorId, retryAttempt, WAN_LOCATOR_CONNECTION_INTERVAL}));
                }
                try {
                    Thread.sleep(WAN_LOCATOR_CONNECTION_INTERVAL);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++retryAttempt;
            }
            catch (ClassNotFoundException cnfe) {
                logger.fatal((Message)LocalizedMessage.create((StringId)LocalizedStrings.LOCATOR_DISCOVERY_TASK_ENCOUNTERED_UNEXPECTED_EXCEPTION), (Throwable)cnfe);
                break;
            }
        }
    }

    public void exchangeRemoteLocators() {
        int retryAttempt = 1;
        DistributionLocatorId remoteLocator = this.locatorId;
        block6: while (!this.getDiscoverer().isStopped()) {
            try {
                RemoteLocatorJoinResponse response = (RemoteLocatorJoinResponse)TcpClient.requestToServer((InetAddress)remoteLocator.getHost(), (int)remoteLocator.getPort(), (Object)this.request, (int)WanLocatorDiscoverer.WAN_LOCATOR_CONNECTION_TIMEOUT);
                if (response == null) continue;
                LocatorHelper.addExchnagedLocators(response.getLocators(), this.locatorListener);
                logger.info((Message)LocalizedMessage.create((StringId)LocalizedStrings.LOCATOR_DISCOVERY_TASK_EXCHANGED_LOCATOR_INFORMATION_0_WITH_1, (Object[])new Object[]{this.request.getLocator(), this.locatorId}));
                RemoteLocatorPingRequest pingRequest = new RemoteLocatorPingRequest("");
                while (true) {
                    Thread.sleep(WAN_LOCATOR_PING_INTERVAL);
                    RemoteLocatorPingResponse pingResponse = (RemoteLocatorPingResponse)TcpClient.requestToServer((InetAddress)remoteLocator.getHost(), (int)remoteLocator.getPort(), (Object)pingRequest, (int)WanLocatorDiscoverer.WAN_LOCATOR_CONNECTION_TIMEOUT);
                    if (pingResponse == null) continue block6;
                }
            }
            catch (IOException ioe) {
                if (retryAttempt == WAN_LOCATOR_CONNECTION_RETRY_ATTEMPT) {
                    logger.fatal((Message)LocalizedMessage.create((StringId)LocalizedStrings.LOCATOR_DISCOVERY_TASK_COULD_NOT_EXCHANGE_LOCATOR_INFORMATION_0_WITH_1_AFTER_2, (Object[])new Object[]{this.request.getLocator(), remoteLocator, retryAttempt}), (Throwable)ioe);
                    break;
                }
                if (this.skipFailureLogging(remoteLocator)) {
                    logger.warn((Message)LocalizedMessage.create((StringId)LocalizedStrings.LOCATOR_DISCOVERY_TASK_COULD_NOT_EXCHANGE_LOCATOR_INFORMATION_0_WITH_1_AFTER_2_RETRYING_IN_3_MS, (Object[])new Object[]{this.request.getLocator(), remoteLocator, retryAttempt, WAN_LOCATOR_CONNECTION_INTERVAL}));
                }
                try {
                    Thread.sleep(WAN_LOCATOR_CONNECTION_INTERVAL);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++retryAttempt;
            }
            catch (ClassNotFoundException cnfe) {
                logger.fatal((Message)LocalizedMessage.create((StringId)LocalizedStrings.LOCATOR_DISCOVERY_TASK_ENCOUNTERED_UNEXPECTED_EXCEPTION), (Throwable)cnfe);
                break;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public class RemoteLocatorDiscovery
    implements Runnable {
        @Override
        public void run() {
            LocatorDiscovery.this.exchangeRemoteLocators();
        }
    }

    public class LocalLocatorDiscovery
    implements Runnable {
        @Override
        public void run() {
            LocatorDiscovery.this.exchangeLocalLocators();
        }
    }
}

