/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.tcpserver;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;

public class HostAndPort
implements DataSerializableFixedID {
    private InetSocketAddress socketInetAddress;

    public HostAndPort() {
    }

    public HostAndPort(String hostName, int port) {
        this.socketInetAddress = hostName == null ? new InetSocketAddress(port) : (InetAddressValidator.getInstance().isValid(hostName) ? new InetSocketAddress(hostName, port) : InetSocketAddress.createUnresolved(hostName, port));
    }

    public InetSocketAddress getSocketInetAddress() {
        if (this.socketInetAddress.isUnresolved()) {
            return new InetSocketAddress(this.socketInetAddress.getHostString(), this.socketInetAddress.getPort());
        }
        return this.socketInetAddress;
    }

    public String getHostName() {
        return this.socketInetAddress.getHostString();
    }

    public int getPort() {
        return this.socketInetAddress.getPort();
    }

    public int hashCode() {
        return this.socketInetAddress.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAndPort that = (HostAndPort)o;
        return Objects.equals(this.socketInetAddress, that.socketInetAddress);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.socketInetAddress + "]";
    }

    public InetAddress getAddress() {
        return this.getSocketInetAddress().getAddress();
    }

    public int getDSFID() {
        return 2185;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        if (this.socketInetAddress.isUnresolved()) {
            out.writeByte(0);
            StaticSerialization.writeString((String)this.getHostName(), (DataOutput)out);
            out.writeInt(this.getPort());
        } else {
            out.writeByte(1);
            StaticSerialization.writeInetAddress((InetAddress)this.socketInetAddress.getAddress(), (DataOutput)out);
            out.writeInt(this.getPort());
        }
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        InetAddress address = null;
        byte flags = in.readByte();
        if ((flags & 1) == 0) {
            String hostName = StaticSerialization.readString((DataInput)in);
            int port = in.readInt();
            this.socketInetAddress = hostName == null || hostName.isEmpty() ? new InetSocketAddress(port) : InetSocketAddress.createUnresolved(hostName, port);
        } else {
            address = StaticSerialization.readInetAddress((DataInput)in);
            int port = in.readInt();
            this.socketInetAddress = new InetSocketAddress(address, port);
        }
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

