/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.serialization.DSCODE;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.DscodeHelper;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.ThreadLocalByteArrayCache;
import org.apache.geode.internal.serialization.VersionedDataStream;

public class StaticSerialization {
    public static final byte NULL_ARRAY = -1;
    public static final byte INT_ARRAY_LEN = -3;
    public static final byte TIME_UNIT_NANOSECONDS = -1;
    public static final byte TIME_UNIT_MICROSECONDS = -2;
    public static final byte TIME_UNIT_MILLISECONDS = -3;
    public static final byte TIME_UNIT_SECONDS = -4;
    public static final byte SHORT_ARRAY_LEN = -2;
    public static final int MAX_BYTE_ARRAY_LEN = 252;
    public static final byte INT_VL = 126;
    public static final byte LONG_VL = 127;
    public static final int MAX_BYTE_VL = 125;
    public static final String PRE_GEODE_100_TCPSERVER_PACKAGE = "com.gemstone.org.jgroups.stack.tcpserver";
    public static final String POST_GEODE_100_TCPSERVER_PACKAGE = "org.apache.geode.distributed.internal.tcpserver";
    @MakeNotStatic(value="not tied to the cache lifecycle")
    private static final ThreadLocalByteArrayCache threadLocalByteArrayCache = new ThreadLocalByteArrayCache(65535);

    public static void writeInetAddress(InetAddress address, DataOutput out) throws IOException {
        StaticSerialization.writeByteArray(address != null ? address.getAddress() : null, out);
    }

    public static void writeByteArray(byte[] array, DataOutput out) throws IOException {
        int len = 0;
        if (array != null) {
            len = array.length;
        }
        StaticSerialization.writeByteArray(array, len, out);
    }

    public static void writeByteArray(byte[] array, int len, DataOutput out) throws IOException {
        int length = len;
        if (array == null) {
            length = -1;
        } else if (length > array.length) {
            length = array.length;
        }
        StaticSerialization.writeArrayLength(length, out);
        if (length > 0) {
            out.write(array, 0, length);
        }
    }

    public static void writeArrayLength(int len, DataOutput out) throws IOException {
        if (len == -1) {
            out.writeByte(-1);
        } else if (len <= 252) {
            out.writeByte(len);
        } else if (len <= 65535) {
            out.writeByte(-2);
            out.writeShort(len);
        } else {
            out.writeByte(-3);
            out.writeInt(len);
        }
    }

    public static int readArrayLength(DataInput in) throws IOException {
        byte code = in.readByte();
        if (code == -1) {
            return -1;
        }
        int result = StaticSerialization.ubyteToInt(code);
        if (result > 252) {
            if (code == -2) {
                return in.readUnsignedShort();
            }
            if (code == -3) {
                return in.readInt();
            }
            throw new IllegalStateException("unexpected array length code=" + code);
        }
        return result;
    }

    private static int ubyteToInt(byte ub) {
        return ub & 0xFF;
    }

    public static void writeString(String value, DataOutput out) throws IOException {
        if (value == null) {
            out.writeByte(DSCODE.NULL_STRING.toByte());
        } else {
            boolean writeUTF;
            int len;
            int utfLen = len = value.length();
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (c <= '\u007f' && c >= '\u0001') continue;
                if (c > '\u07ff') {
                    utfLen += 2;
                    continue;
                }
                ++utfLen;
            }
            boolean bl = writeUTF = utfLen > len;
            if (writeUTF) {
                if (utfLen > 65535) {
                    out.writeByte(DSCODE.HUGE_STRING.toByte());
                    out.writeInt(len);
                    out.writeChars(value);
                } else {
                    out.writeByte(DSCODE.STRING.toByte());
                    out.writeUTF(value);
                }
            } else if (len > 65535) {
                out.writeByte(DSCODE.HUGE_STRING_BYTES.toByte());
                out.writeInt(len);
                out.writeBytes(value);
            } else {
                out.writeByte(DSCODE.STRING_BYTES.toByte());
                out.writeShort(len);
                out.writeBytes(value);
            }
        }
    }

    public static String readString(DataInput in, byte header) throws IOException {
        return StaticSerialization.readString(in, DscodeHelper.toDSCODE(header));
    }

    private static String readString(DataInput in, DSCODE dscode) throws IOException {
        switch (dscode) {
            case STRING_BYTES: {
                return StaticSerialization.readStringBytesFromDataInput(in, in.readUnsignedShort());
            }
            case STRING: {
                return StaticSerialization.readStringUTFFromDataInput(in);
            }
            case NULL_STRING: {
                return null;
            }
            case HUGE_STRING_BYTES: {
                return StaticSerialization.readStringBytesFromDataInput(in, in.readInt());
            }
            case HUGE_STRING: {
                return StaticSerialization.readHugeStringFromDataInput(in);
            }
        }
        throw new IOException("Unknown String header " + String.valueOf((Object)dscode));
    }

    private static String readHugeStringFromDataInput(DataInput in) throws IOException {
        int len = in.readInt();
        char[] buf = new char[len];
        for (int i = 0; i < len; ++i) {
            buf[i] = in.readChar();
        }
        return new String(buf);
    }

    public static String[] readStringArray(DataInput in) throws IOException {
        int length = StaticSerialization.readArrayLength(in);
        if (length == -1) {
            return null;
        }
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            array[i] = StaticSerialization.readString(in);
        }
        return array;
    }

    private static String readStringUTFFromDataInput(DataInput in) throws IOException {
        return in.readUTF();
    }

    private static String readStringBytesFromDataInput(DataInput dataInput, int len) throws IOException {
        if (len == 0) {
            return "";
        }
        byte[] buf = StaticSerialization.getThreadLocalByteArray(len);
        dataInput.readFully(buf, 0, len);
        String string = new String(buf, 0, 0, len);
        return string;
    }

    public static String readString(DataInput in) throws IOException {
        return StaticSerialization.readString(in, in.readByte());
    }

    public static InetAddress readInetAddress(DataInput in) throws IOException {
        byte[] address = StaticSerialization.readByteArray(in);
        if (address == null) {
            return null;
        }
        try {
            return InetAddress.getByAddress(address);
        }
        catch (UnknownHostException ex) {
            throw new IOException("While reading an InetAddress", ex);
        }
    }

    public static void writeStringArray(String[] array, DataOutput out) throws IOException {
        int length = array == null ? -1 : array.length;
        StaticSerialization.writeArrayLength(length, out);
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                StaticSerialization.writeString(array[i], out);
            }
        }
    }

    public static void writeInteger(Integer value, DataOutput out) throws IOException {
        out.writeInt(value);
    }

    public static <K, V> HashMap<K, V> readHashMap(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        int size = StaticSerialization.readArrayLength(in);
        if (size == -1) {
            return null;
        }
        HashMap map = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            Object key = context.getDeserializer().readObject(in);
            Object value = context.getDeserializer().readObject(in);
            map.put(key, value);
        }
        return map;
    }

    public static int[] readIntArray(DataInput in) throws IOException {
        int length = StaticSerialization.readArrayLength(in);
        if (length == -1) {
            return null;
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = in.readInt();
        }
        return array;
    }

    public static byte[] readByteArray(DataInput in) throws IOException {
        int length = StaticSerialization.readArrayLength(in);
        if (length == -1) {
            return null;
        }
        byte[] array = new byte[length];
        in.readFully(array, 0, length);
        return array;
    }

    public static void writeIntArray(int[] array, DataOutput out) throws IOException {
        int length = array == null ? -1 : array.length;
        StaticSerialization.writeArrayLength(length, out);
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                out.writeInt(array[i]);
            }
        }
    }

    public static void writeHashMap(Map<?, ?> map, DataOutput out, SerializationContext context) throws IOException {
        int size = map == null ? -1 : map.size();
        StaticSerialization.writeArrayLength(size, out);
        if (size > 0) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                context.getSerializer().writeObject(entry.getKey(), out);
                context.getSerializer().writeObject(entry.getValue(), out);
            }
        }
    }

    public static byte[] getThreadLocalByteArray(int minimumLength) {
        return threadLocalByteArrayCache.get(minimumLength);
    }

    public static void writeClass(Class<?> c, DataOutput out) throws IOException {
        if (c == null || c.isPrimitive()) {
            StaticSerialization.writePrimitiveClass(c, out);
        } else {
            out.writeByte(DSCODE.CLASS.toByte());
            String cname = c.getName();
            cname = StaticSerialization.processOutgoingClassName(cname);
            StaticSerialization.writeString(cname, out);
        }
    }

    public static Class<?> readClass(DataInput in) throws IOException, ClassNotFoundException {
        byte typeCode = in.readByte();
        if (typeCode == DSCODE.CLASS.toByte()) {
            String className = StaticSerialization.readString(in);
            className = StaticSerialization.processIncomingClassName(className);
            return Class.forName(className);
        }
        return StaticSerialization.decodePrimitiveClass(typeCode);
    }

    public static String processOutgoingClassName(String name) {
        if (name.startsWith(POST_GEODE_100_TCPSERVER_PACKAGE)) {
            return PRE_GEODE_100_TCPSERVER_PACKAGE + name.substring(POST_GEODE_100_TCPSERVER_PACKAGE.length());
        }
        return name;
    }

    public static String processIncomingClassName(String name) {
        if (name.startsWith(PRE_GEODE_100_TCPSERVER_PACKAGE)) {
            return POST_GEODE_100_TCPSERVER_PACKAGE + name.substring(PRE_GEODE_100_TCPSERVER_PACKAGE.length());
        }
        return name;
    }

    public static void writePrimitiveClass(Class<?> c, DataOutput out) throws IOException {
        if (c == Boolean.TYPE) {
            out.writeByte(DSCODE.BOOLEAN_TYPE.toByte());
        } else if (c == Character.TYPE) {
            out.writeByte(DSCODE.CHARACTER_TYPE.toByte());
        } else if (c == Byte.TYPE) {
            out.writeByte(DSCODE.BYTE_TYPE.toByte());
        } else if (c == Short.TYPE) {
            out.writeByte(DSCODE.SHORT_TYPE.toByte());
        } else if (c == Integer.TYPE) {
            out.writeByte(DSCODE.INTEGER_TYPE.toByte());
        } else if (c == Long.TYPE) {
            out.writeByte(DSCODE.LONG_TYPE.toByte());
        } else if (c == Float.TYPE) {
            out.writeByte(DSCODE.FLOAT_TYPE.toByte());
        } else if (c == Double.TYPE) {
            out.writeByte(DSCODE.DOUBLE_TYPE.toByte());
        } else if (c == Void.TYPE) {
            out.writeByte(DSCODE.VOID_TYPE.toByte());
        } else if (c == null) {
            out.writeByte(DSCODE.NULL.toByte());
        } else {
            throw new IllegalArgumentException(String.format("unknown primitive type: %s", c.getName()));
        }
    }

    public static Class<?> decodePrimitiveClass(byte typeCode) throws IOException {
        DSCODE dscode = DscodeHelper.toDSCODE(typeCode);
        switch (dscode) {
            case BOOLEAN_TYPE: {
                return Boolean.TYPE;
            }
            case CHARACTER_TYPE: {
                return Character.TYPE;
            }
            case BYTE_TYPE: {
                return Byte.TYPE;
            }
            case SHORT_TYPE: {
                return Short.TYPE;
            }
            case INTEGER_TYPE: {
                return Integer.TYPE;
            }
            case LONG_TYPE: {
                return Long.TYPE;
            }
            case FLOAT_TYPE: {
                return Float.TYPE;
            }
            case DOUBLE_TYPE: {
                return Double.TYPE;
            }
            case VOID_TYPE: {
                return Void.TYPE;
            }
            case NULL: {
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("unexpected typeCode: %s", typeCode));
    }

    public static KnownVersion getVersionForDataStreamOrNull(DataInput in) {
        if (in instanceof VersionedDataStream) {
            return ((VersionedDataStream)((Object)in)).getVersion();
        }
        return null;
    }

    public static KnownVersion getVersionForDataStream(DataInput in) {
        if (in instanceof VersionedDataStream) {
            KnownVersion v = ((VersionedDataStream)((Object)in)).getVersion();
            return v != null ? v : KnownVersion.CURRENT;
        }
        return KnownVersion.CURRENT;
    }

    public static KnownVersion getVersionForDataStream(DataOutput out) {
        if (out instanceof VersionedDataStream) {
            KnownVersion v = ((VersionedDataStream)((Object)out)).getVersion();
            return v != null ? v : KnownVersion.CURRENT;
        }
        return KnownVersion.CURRENT;
    }

    public static KnownVersion getVersionForDataStreamOrNull(DataOutput out) {
        if (out instanceof VersionedDataStream) {
            return ((VersionedDataStream)((Object)out)).getVersion();
        }
        return null;
    }
}

