/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.serialization.DSCODE;
import org.apache.geode.internal.serialization.DSFIDNotFoundException;
import org.apache.geode.internal.serialization.DSFIDSerializer;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.DeserializationContextImpl;
import org.apache.geode.internal.serialization.DscodeHelper;
import org.apache.geode.internal.serialization.ObjectDeserializer;
import org.apache.geode.internal.serialization.ObjectSerializer;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.SerializationContextImpl;
import org.apache.geode.internal.serialization.SerializationVersions;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionedDataStream;

public class DSFIDSerializerImpl
implements DSFIDSerializer {
    @Immutable
    private final Constructor<?>[] dsfidMap = new Constructor[256];
    @Immutable(value="This maybe should be wrapped in an unmodifiableMap?")
    private final Int2ObjectOpenHashMap dsfidMap2 = new Int2ObjectOpenHashMap(800);
    private final ObjectSerializer objectSerializer;
    private final ObjectDeserializer objectDeserializer;

    public DSFIDSerializerImpl() {
        this.objectSerializer = this.createDefaultObjectSerializer();
        this.objectDeserializer = this.createDefaultObjectDeserializer();
    }

    public DSFIDSerializerImpl(ObjectSerializer objectSerializer, ObjectDeserializer objectDeserializer) {
        this.objectSerializer = objectSerializer == null ? this.createDefaultObjectSerializer() : objectSerializer;
        this.objectDeserializer = objectDeserializer == null ? this.createDefaultObjectDeserializer() : objectDeserializer;
    }

    private ObjectSerializer createDefaultObjectSerializer() {
        return new ObjectSerializer(){

            @Override
            public void writeObject(Object obj, DataOutput output) throws IOException {
                DSFIDSerializerImpl.this.writeDSFID((DataSerializableFixedID)obj, output);
            }

            @Override
            public void invokeToData(Object ds, DataOutput out) throws IOException {
                DSFIDSerializerImpl.this.invokeToData(ds, out);
            }
        };
    }

    private ObjectDeserializer createDefaultObjectDeserializer() {
        return new ObjectDeserializer(){

            @Override
            public <T> T readObject(DataInput input) throws IOException, ClassNotFoundException {
                return (T)DSFIDSerializerImpl.this.readDSFID(input);
            }

            @Override
            public void invokeFromData(Object ds, DataInput in) throws IOException, ClassNotFoundException {
                DSFIDSerializerImpl.this.invokeFromData(ds, in);
            }
        };
    }

    @Override
    public ObjectSerializer getObjectSerializer() {
        return this.objectSerializer;
    }

    @Override
    public ObjectDeserializer getObjectDeserializer() {
        return this.objectDeserializer;
    }

    @Override
    public void writeDSFIDHeader(int dsfid, DataOutput out) throws IOException {
        if (dsfid == 0) {
            throw new IllegalStateException("attempted to serialize ILLEGAL dsfid");
        }
        if (dsfid <= 127 && dsfid >= -128) {
            out.writeByte(DSCODE.DS_FIXED_ID_BYTE.toByte());
            out.writeByte(dsfid);
        } else if (dsfid <= Short.MAX_VALUE && dsfid >= Short.MIN_VALUE) {
            out.writeByte(DSCODE.DS_FIXED_ID_SHORT.toByte());
            out.writeShort(dsfid);
        } else {
            out.writeByte(DSCODE.DS_FIXED_ID_INT.toByte());
            out.writeInt(dsfid);
        }
    }

    @Override
    public void writeDSFID(DataSerializableFixedID o, DataOutput out) throws IOException {
        if (o == null) {
            out.writeByte(DSCODE.NULL.toByte());
            return;
        }
        int dsfid = o.getDSFID();
        if (dsfid == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("NO_FIXED_ID is not supported by BasicDSFIDSerializer - use InternalDataSerializer instead: " + o.getClass().getName());
        }
        this.writeDSFIDHeader(dsfid, out);
        this.invokeToData(o, out);
    }

    @Override
    public void invokeToData(Object ds, DataOutput out) throws IOException {
        boolean isDSFID = ds instanceof DataSerializableFixedID;
        if (!isDSFID) {
            throw new IllegalArgumentException("Expected a DataSerializableFixedID but found " + ds.getClass().getName());
        }
        SerializationContextImpl context = new SerializationContextImpl(out, this);
        try {
            SerializationVersions sv;
            Version[] versions;
            boolean invoked = false;
            Version v = context.getSerializationVersion();
            if (!v.isCurrentVersion() && (versions = (sv = (SerializationVersions)ds).getSerializationVersions()) != null) {
                for (Version version : versions) {
                    if (v.compareTo(version) >= 0) continue;
                    ds.getClass().getMethod("toDataPre_" + version.getMethodSuffix(), DataOutput.class, SerializationContext.class).invoke(ds, out, context);
                    invoked = true;
                    break;
                }
            }
            if (!invoked) {
                ((DataSerializableFixedID)ds).toData(out, context);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IOException("problem invoking toData method on object of class" + ds.getClass().getName(), e);
        }
    }

    public Version getVersionForDataStreamOrNull(DataOutput out) {
        if (out instanceof VersionedDataStream) {
            return ((VersionedDataStream)((Object)out)).getVersion();
        }
        return null;
    }

    public Object readDSFID(DataInput in, DSCODE dscode) throws IOException, ClassNotFoundException {
        switch (dscode) {
            case DS_FIXED_ID_BYTE: {
                return this.create(in.readByte(), in);
            }
            case DS_FIXED_ID_SHORT: {
                return this.create(in.readShort(), in);
            }
            case DS_NO_FIXED_ID: {
                throw new IllegalStateException("DS_NO_FIXED_ID is not supported in readDSFID - use InternalDataSerializer instead");
            }
            case DS_FIXED_ID_INT: {
                return this.create(in.readInt(), in);
            }
        }
        throw new IllegalStateException("unexpected byte: " + (Object)((Object)dscode) + " while reading dsfid");
    }

    public Object readDSFID(DataInput in) throws IOException, ClassNotFoundException {
        DSFIDSerializerImpl.checkIn(in);
        DSCODE dsHeaderType = DscodeHelper.toDSCODE(in.readByte());
        if (dsHeaderType == DSCODE.NULL) {
            return null;
        }
        return this.readDSFID(in, dsHeaderType);
    }

    public int readDSFIDHeader(DataInput in, DSCODE dscode) throws IOException {
        switch (dscode) {
            case DS_FIXED_ID_BYTE: {
                return in.readByte();
            }
            case DS_FIXED_ID_SHORT: {
                return in.readShort();
            }
            case DS_FIXED_ID_INT: {
                return in.readInt();
            }
        }
        throw new IllegalStateException("unexpected byte: " + (Object)((Object)dscode) + " while reading dsfid");
    }

    @Override
    public int readDSFIDHeader(DataInput in) throws IOException {
        DSFIDSerializerImpl.checkIn(in);
        return this.readDSFIDHeader(in, DscodeHelper.toDSCODE(in.readByte()));
    }

    public static void checkIn(DataInput in) {
        if (in == null) {
            throw new NullPointerException("Null DataInput");
        }
    }

    @Override
    public void invokeFromData(Object ds, DataInput in) throws IOException, ClassNotFoundException {
        DeserializationContextImpl context = new DeserializationContextImpl(in, this);
        try {
            boolean invoked = false;
            Version v = context.getSerializationVersion();
            if (!v.isCurrentVersion()) {
                Version[] versions = null;
                SerializationVersions vds = (SerializationVersions)ds;
                versions = vds.getSerializationVersions();
                if (versions != null) {
                    for (Version version : versions) {
                        if (v.compareTo(version) >= 0) continue;
                        ds.getClass().getMethod("fromDataPre_" + version.getMethodSuffix(), DataInput.class, DeserializationContext.class).invoke(ds, in, context);
                        invoked = true;
                        break;
                    }
                }
            }
            if (!invoked) {
                ((DataSerializableFixedID)ds).fromData(in, context);
            }
        }
        catch (EOFException | ClassNotFoundException | SocketException ex) {
            throw ex;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new IOException(String.format("Could not create an instance of %s .", ds.getClass().getName()), ex);
        }
    }

    @Override
    public void registerDSFID(int dsfid, Class dsfidClass) {
        try {
            Constructor cons = dsfidClass.getConstructor(null);
            cons.setAccessible(true);
            if (!cons.isAccessible()) {
                throw new IllegalArgumentException("default constructor not accessible for DSFID=" + dsfid + ": " + dsfidClass);
            }
            if (dsfid >= -128 && dsfid <= 127) {
                this.dsfidMap[dsfid + 127 + 1] = cons;
            } else {
                this.dsfidMap2.put(dsfid, cons);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("Unable to find a default constructor for " + dsfidClass, nsme);
        }
    }

    @Override
    public Object create(int dsfid, DataInput in) throws IOException, ClassNotFoundException {
        Constructor<?> cons = dsfid >= -128 && dsfid <= 127 ? this.dsfidMap[dsfid + 127 + 1] : (Constructor<?>)this.dsfidMap2.get(dsfid);
        if (cons != null) {
            try {
                Object ds = cons.newInstance(null);
                this.invokeFromData(ds, in);
                return ds;
            }
            catch (InstantiationException ie) {
                throw new IOException(ie.getMessage(), ie);
            }
            catch (IllegalAccessException iae) {
                throw new IOException(iae.getMessage(), iae);
            }
            catch (InvocationTargetException ite) {
                Throwable targetEx = ite.getTargetException();
                if (targetEx instanceof IOException) {
                    throw (IOException)targetEx;
                }
                if (targetEx instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)targetEx;
                }
                throw new IOException(ite.getMessage(), targetEx);
            }
        }
        throw new DSFIDNotFoundException("Unknown DataSerializableFixedID: " + dsfid, dsfid);
    }

    public Constructor<?>[] getDsfidmap() {
        return this.dsfidMap;
    }

    public Int2ObjectOpenHashMap getDsfidmap2() {
        return this.dsfidMap2;
    }

    @Override
    public SerializationContext createSerializationContext(DataOutput dataOutput) {
        return new SerializationContextImpl(dataOutput, this);
    }

    @Override
    public DeserializationContext createDeserializationContext(DataInput dataInput) {
        return new DeserializationContextImpl(dataInput, this);
    }
}

