/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.util;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.control.RebalanceOperation;
import org.apache.geode.cache.control.RebalanceResults;
import org.apache.geode.cache.partition.PartitionMemberInfo;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.InternalPRInfo;
import org.apache.geode.internal.cache.partitioned.LoadProbe;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.support.CronSequenceGenerator;

@Experimental(value="The autobalancer may be removed or the API may change in future releases")
public class AutoBalancer
implements Declarable {
    public static final String SCHEDULE = "schedule";
    public static final String SIZE_THRESHOLD_PERCENT = "size-threshold-percent";
    public static final int DEFAULT_SIZE_THRESHOLD_PERCENT = 10;
    public static final String MINIMUM_SIZE = "minimum-size";
    public static final int DEFAULT_MINIMUM_SIZE = 0x6400000;
    public static final String AUTO_BALANCER_LOCK_SERVICE_NAME = "__AUTO_B";
    public static final Object AUTO_BALANCER_LOCK = "__AUTO_B_LOCK";
    private final AuditScheduler scheduler;
    private final OOBAuditor auditor;
    private final TimeProvider clock;
    private final CacheOperationFacade cacheFacade;
    private static final Logger logger = LogService.getLogger();

    public AutoBalancer() {
        this(null, null, null, null);
    }

    public AutoBalancer(AuditScheduler scheduler, OOBAuditor auditor, TimeProvider clock, CacheOperationFacade cacheFacade) {
        this.cacheFacade = cacheFacade == null ? new GeodeCacheFacade() : cacheFacade;
        this.scheduler = scheduler == null ? new CronScheduler() : scheduler;
        this.auditor = auditor == null ? new SizeBasedOOBAuditor(this.cacheFacade) : auditor;
        this.clock = clock == null ? new SystemClockTimeProvider() : clock;
    }

    public void init(Properties props) {
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing " + this.getClass().getSimpleName() + " with " + props);
        }
        this.auditor.init(props);
        String schedule = null;
        if (props != null) {
            schedule = props.getProperty(SCHEDULE);
        }
        this.scheduler.init(schedule);
    }

    OOBAuditor getOOBAuditor() {
        return this.auditor;
    }

    public CacheOperationFacade getCacheOperationFacade() {
        return this.cacheFacade;
    }

    public void destroy() {
        this.scheduler.destroy();
    }

    static interface CacheOperationFacade {
        public boolean acquireAutoBalanceLock();

        public DistributedLockService getDLS();

        public void rebalance();

        public void incrementAttemptCounter();

        public Map<PartitionedRegion, InternalPRInfo> getRegionMemberDetails();

        public long getTotalDataSize(Map<PartitionedRegion, InternalPRInfo> var1);

        public long getTotalTransferSize();
    }

    static interface TimeProvider {
        public long currentTimeMillis();
    }

    static interface OOBAuditor {
        public void init(Properties var1);

        public void execute();
    }

    static interface AuditScheduler {
        public void init(String var1);

        public void destroy();
    }

    private class SystemClockTimeProvider
    implements TimeProvider {
        private SystemClockTimeProvider() {
        }

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    }

    static class GeodeCacheFacade
    implements CacheOperationFacade {
        private final AtomicBoolean isLockAcquired = new AtomicBoolean(false);
        private GemFireCacheImpl cache;

        public GeodeCacheFacade() {
            this(null);
        }

        public GeodeCacheFacade(GemFireCacheImpl cache) {
            this.cache = cache;
        }

        @Override
        public Map<PartitionedRegion, InternalPRInfo> getRegionMemberDetails() {
            GemFireCacheImpl cache = this.getCache();
            HashMap<PartitionedRegion, InternalPRInfo> detailsMap = new HashMap<PartitionedRegion, InternalPRInfo>();
            for (PartitionedRegion region : cache.getPartitionedRegions()) {
                LoadProbe probe = cache.getResourceManager().getLoadProbe();
                InternalPRInfo info = region.getRedundancyProvider().buildPartitionedRegionInfo(true, probe);
                detailsMap.put(region, info);
            }
            return detailsMap;
        }

        @Override
        public long getTotalDataSize(Map<PartitionedRegion, InternalPRInfo> details) {
            long totalSize = 0L;
            if (details != null) {
                for (PartitionedRegion region : details.keySet()) {
                    InternalPRInfo info = details.get(region);
                    Set membersInfo = info.getPartitionMemberInfo();
                    for (PartitionMemberInfo member : membersInfo) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Region:{}, Member: {}, Size: {}", (Object)region.getFullPath(), (Object)member, (Object)member.getSize());
                        }
                        totalSize += member.getSize();
                    }
                }
            }
            return totalSize;
        }

        @Override
        public long getTotalTransferSize() {
            try {
                RebalanceOperation operation = this.getCache().getResourceManager().createRebalanceFactory().simulate();
                RebalanceResults result = operation.getResults();
                if (logger.isDebugEnabled()) {
                    logger.debug("Rebalance estimate: RebalanceResultsImpl [TotalBucketCreateBytes=" + result.getTotalBucketCreateBytes() + ", TotalBucketCreatesCompleted=" + result.getTotalBucketCreatesCompleted() + ", TotalBucketTransferBytes=" + result.getTotalBucketTransferBytes() + ", TotalBucketTransfersCompleted=" + result.getTotalBucketTransfersCompleted() + ", TotalPrimaryTransfersCompleted=" + result.getTotalPrimaryTransfersCompleted() + "]");
                }
                return result.getTotalBucketTransferBytes();
            }
            catch (CancellationException e) {
                logger.info("Error while trying to estimate rebalance cost ", (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.info("Error while trying to estimate rebalance cost ", (Throwable)e);
            }
            return 0L;
        }

        @Override
        public void incrementAttemptCounter() {
            GemFireCacheImpl cache = this.getCache();
            try {
                cache.getResourceManager().getStats().incAutoRebalanceAttempts();
            }
            catch (Exception e) {
                logger.warn("Failed to increment AutoBalanceAttempts counter");
            }
        }

        @Override
        public void rebalance() {
            try {
                RebalanceOperation operation = this.getCache().getResourceManager().createRebalanceFactory().start();
                RebalanceResults result = operation.getResults();
                logger.info("Rebalance result: [TotalBucketCreateBytes=" + result.getTotalBucketCreateBytes() + ", TotalBucketCreateTime=" + result.getTotalBucketCreateTime() + ", TotalBucketCreatesCompleted=" + result.getTotalBucketCreatesCompleted() + ", TotalBucketTransferBytes=" + result.getTotalBucketTransferBytes() + ", TotalBucketTransferTime=" + result.getTotalBucketTransferTime() + ", TotalBucketTransfersCompleted=" + result.getTotalBucketTransfersCompleted() + ", TotalPrimaryTransferTime=" + result.getTotalPrimaryTransferTime() + ", TotalPrimaryTransfersCompleted=" + result.getTotalPrimaryTransfersCompleted() + ", TotalTime=" + result.getTotalTime() + "]");
            }
            catch (CancellationException e) {
                logger.info("Error rebalancing the cluster", (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.info("Error rebalancing the cluster", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        GemFireCacheImpl getCache() {
            if (this.cache == null) {
                GeodeCacheFacade geodeCacheFacade = this;
                synchronized (geodeCacheFacade) {
                    if (this.cache == null) {
                        this.cache = GemFireCacheImpl.getInstance();
                        if (this.cache == null) {
                            throw new IllegalStateException("Missing cache instance.");
                        }
                    }
                }
            }
            if (this.cache.isClosed()) {
                throw new CacheClosedException();
            }
            return this.cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean acquireAutoBalanceLock() {
            if (!this.isLockAcquired.get()) {
                AtomicBoolean atomicBoolean = this.isLockAcquired;
                synchronized (atomicBoolean) {
                    if (!this.isLockAcquired.get()) {
                        DistributedLockService dls = this.getDLS();
                        boolean result = dls.lock(AUTO_BALANCER_LOCK, 0L, -1L);
                        if (result) {
                            this.isLockAcquired.set(true);
                            if (logger.isDebugEnabled()) {
                                logger.debug("Grabbed AutoBalancer lock");
                            }
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("Another member owns auto-balance lock. Skip this attempt to rebalance the cluster");
                        }
                    }
                }
            }
            return this.isLockAcquired.get();
        }

        @Override
        public DistributedLockService getDLS() {
            GemFireCacheImpl cache = this.getCache();
            DistributedLockService dls = DistributedLockService.getServiceNamed((String)AutoBalancer.AUTO_BALANCER_LOCK_SERVICE_NAME);
            if (dls == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Creating DistributeLockService");
                }
                dls = DLockService.create((String)AutoBalancer.AUTO_BALANCER_LOCK_SERVICE_NAME, (InternalDistributedSystem)cache.getDistributedSystem(), (boolean)true, (boolean)true, (boolean)true);
            }
            return dls;
        }
    }

    static class SizeBasedOOBAuditor
    implements OOBAuditor {
        private int sizeThreshold = 10;
        private int sizeMinimum = 0x6400000;
        final CacheOperationFacade cache;

        public SizeBasedOOBAuditor(CacheOperationFacade cache) {
            this.cache = cache;
        }

        @Override
        public void init(Properties props) {
            if (logger.isDebugEnabled()) {
                logger.debug("Initializing " + this.getClass().getSimpleName());
            }
            if (props != null) {
                if (props.getProperty(AutoBalancer.SIZE_THRESHOLD_PERCENT) != null) {
                    this.sizeThreshold = Integer.valueOf(props.getProperty(AutoBalancer.SIZE_THRESHOLD_PERCENT));
                    if (this.sizeThreshold <= 0 || this.sizeThreshold >= 100) {
                        throw new GemFireConfigException("size-threshold-percent should be integer, 1 to 99");
                    }
                }
                if (props.getProperty(AutoBalancer.MINIMUM_SIZE) != null) {
                    this.sizeMinimum = Integer.valueOf(props.getProperty(AutoBalancer.MINIMUM_SIZE));
                    if (this.sizeMinimum <= 0) {
                        throw new GemFireConfigException("minimum-size should be greater than 0");
                    }
                }
            }
        }

        @Override
        public void execute() {
            boolean result = this.cache.acquireAutoBalanceLock();
            if (!result) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Another member owns auto-balance lock. Skip this attempt to rebalance the cluster");
                }
                return;
            }
            this.cache.incrementAttemptCounter();
            result = this.needsRebalancing();
            if (!result) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Rebalancing is not needed");
                }
                return;
            }
            this.cache.rebalance();
        }

        boolean needsRebalancing() {
            int transferPercent;
            long transferSize = this.cache.getTotalTransferSize();
            if (transferSize <= (long)this.sizeMinimum) {
                return false;
            }
            Map<PartitionedRegion, InternalPRInfo> details = this.cache.getRegionMemberDetails();
            long totalSize = this.cache.getTotalDataSize(details);
            return totalSize > 0L && (transferPercent = (int)(100.0 * (double)transferSize / (double)totalSize)) >= this.sizeThreshold;
        }

        int getSizeThreshold() {
            return this.sizeThreshold;
        }

        public long getSizeMinimum() {
            return this.sizeMinimum;
        }
    }

    private class CronScheduler
    implements AuditScheduler {
        final ScheduledExecutorService trigger;
        CronSequenceGenerator generator;

        CronScheduler() {
            this.trigger = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, "AutoBalancer");
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }

        @Override
        public void init(String schedule) {
            if (logger.isDebugEnabled()) {
                logger.debug("Initializing " + this.getClass().getSimpleName() + " with " + schedule);
            }
            if (schedule == null || schedule.isEmpty()) {
                throw new GemFireConfigException("Missing configuration: schedule");
            }
            try {
                this.generator = new CronSequenceGenerator(schedule);
            }
            catch (Exception e) {
                throw new GemFireConfigException("Cron expression could not be parsed: " + schedule, (Throwable)e);
            }
            this.submitNext();
        }

        private void submitNext() {
            long currentTime = AutoBalancer.this.clock.currentTimeMillis();
            Date nextSchedule = this.generator.next(new Date(currentTime));
            long delay = nextSchedule.getTime() - currentTime;
            if (logger.isDebugEnabled()) {
                logger.debug("Now={}, next audit time={}, delay={} ms", (Object)new Date(currentTime), (Object)nextSchedule, (Object)delay);
            }
            this.trigger.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        AutoBalancer.this.auditor.execute();
                    }
                    catch (CacheClosedException e) {
                        logger.warn("Cache closed while attempting to rebalance the cluster. Abort future jobs", (Throwable)e);
                        return;
                    }
                    catch (Exception e) {
                        logger.warn("Error while executing out-of-balance audit.", (Throwable)e);
                    }
                    CronScheduler.this.submitNext();
                }
            }, delay, TimeUnit.MILLISECONDS);
        }

        @Override
        public void destroy() {
            this.trigger.shutdownNow();
        }
    }
}

