/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.servlet.http.HttpServletRequest;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.apache.geode.tools.pulse.internal.util.NameUtil;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="MemberDiskThroughput")
@Scope(value="singleton")
public class MemberDiskThroughputService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public ObjectNode execute(HttpServletRequest request) throws Exception {
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        JsonNode requestDataJSON = this.mapper.readTree(request.getParameter("pulseData"));
        String memberName = requestDataJSON.get("MemberDiskThroughput").get("memberName").textValue();
        Cluster.Member clusterMember = cluster.getMember(NameUtil.makeCompliantName(memberName));
        if (clusterMember != null) {
            responseJSON.put("throughputWrites", clusterMember.getThroughputWrites());
            responseJSON.put("throughputWritesTrend", this.mapper.valueToTree((Object)clusterMember.getMemberStatisticTrend(5)));
            responseJSON.put("throughputReads", clusterMember.getThroughputWrites());
            responseJSON.put("throughputReadsTrend", this.mapper.valueToTree((Object)clusterMember.getMemberStatisticTrend(6)));
        }
        return responseJSON;
    }
}

