/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.servlet.http.HttpServletRequest;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.apache.geode.tools.pulse.internal.util.NameUtil;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="MemberAsynchEventQueues")
@Scope(value="singleton")
public class MemberAsynchEventQueuesService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public ObjectNode execute(HttpServletRequest request) throws Exception {
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        JsonNode requestDataJSON = this.mapper.readTree(request.getParameter("pulseData"));
        String memberName = requestDataJSON.get("MemberAsynchEventQueues").get("memberName").textValue();
        Cluster.Member clusterMember = cluster.getMember(NameUtil.makeCompliantName(memberName));
        if (clusterMember != null) {
            Cluster.AsyncEventQueue[] asyncEventQueues = clusterMember.getMemberAsyncEventQueueList();
            ArrayNode asyncEventQueueJsonList = this.mapper.createArrayNode();
            if (asyncEventQueues != null && asyncEventQueues.length > 0) {
                responseJSON.put("isAsyncEventQueuesPresent", true);
                for (Cluster.AsyncEventQueue asyncEventQueue : asyncEventQueues) {
                    ObjectNode asyncEventQueueJSON = this.mapper.createObjectNode();
                    asyncEventQueueJSON.put("id", asyncEventQueue.getId());
                    asyncEventQueueJSON.put("primary", asyncEventQueue.getPrimary());
                    asyncEventQueueJSON.put("senderType", asyncEventQueue.isParallel());
                    asyncEventQueueJSON.put("batchSize", asyncEventQueue.getBatchSize());
                    asyncEventQueueJSON.put("batchTimeInterval", asyncEventQueue.getBatchTimeInterval());
                    asyncEventQueueJSON.put("batchConflationEnabled", asyncEventQueue.isBatchConflationEnabled());
                    asyncEventQueueJSON.put("asyncEventListener", asyncEventQueue.getAsyncEventListener());
                    asyncEventQueueJSON.put("queueSize", asyncEventQueue.getEventQueueSize());
                    asyncEventQueueJsonList.add((JsonNode)asyncEventQueueJSON);
                }
                responseJSON.put("asyncEventQueues", (JsonNode)asyncEventQueueJsonList);
            } else {
                responseJSON.put("isAsyncEventQueuesPresent", false);
            }
        }
        return responseJSON;
    }
}

