/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="ClusterWANInfo")
@Scope(value="singleton")
public class ClusterWANInfoService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public ObjectNode execute(HttpServletRequest request) throws Exception {
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        ArrayNode connectedClusterListJson = this.mapper.createArrayNode();
        for (Map.Entry<String, Boolean> entry : cluster.getWanInformation().entrySet()) {
            ObjectNode clusterJSON = this.mapper.createObjectNode();
            clusterJSON.put("clusterId", entry.getKey());
            clusterJSON.put("name", entry.getKey());
            clusterJSON.put("status", entry.getValue());
            connectedClusterListJson.add((JsonNode)clusterJSON);
        }
        responseJSON.put("connectedClusters", (JsonNode)connectedClusterListJson);
        return responseJSON;
    }
}

