/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.PulseConstants;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="ClusterMembersRGraph")
@Scope(value="singleton")
public class ClusterMembersRGraphService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();
    private final String CLUSTER = "clustor";
    private final String MEMBER_COUNT = "memberCount";
    private final String ID = "id";
    private final String NAME = "name";
    private final String DATA = "data";
    private final String MEMORY_USAGE = "memoryUsage";
    private final String CPU_USAGE = "cpuUsage";
    private final String REGIONS = "regions";
    private final String HOST = "host";
    private final String PORT = "port";
    private final String CLIENTS = "clients";
    private final String GC_PAUSES = "gcPauses";
    private final String GATEWAY_SENDER = "gatewaySender";
    private final String GATEWAY_RECEIVER = "gatewayReceiver";
    private final String LOAD_AVG = "loadAvg";
    private final String SOCKETS = "sockets";
    private final String THREADS = "threads";
    private final String NUM_THREADS = "numThreads";
    private final String MEMBER_NODE_TYPE_NORMAL = "Normal";
    private final String MEMBER_NODE_TYPE_WARNING = "Warning";
    private final String MEMBER_NODE_TYPE_ERROR = "Error";
    private final String MEMBER_NODE_TYPE_SEVERE = "Severe";
    private final String CHILDREN = "children";
    private List<String> severeAlertList;
    private List<String> errorAlertsList;
    private List<String> warningAlertsList;

    @Override
    public ObjectNode execute(HttpServletRequest request) throws Exception {
        Repository repository = Repository.get();
        Cluster cluster = repository.getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        responseJSON.put(this.CLUSTER, (JsonNode)this.getPhysicalServerJson(cluster, repository.getHost(), repository.getPort()));
        responseJSON.put(this.MEMBER_COUNT, cluster.getMemberCount());
        return responseJSON;
    }

    private ObjectNode getPhysicalServerJson(Cluster cluster, String host, String port) {
        Map<String, List<Cluster.Member>> physicalToMember = cluster.getPhysicalToMember();
        ObjectNode clusterTopologyJSON = this.mapper.createObjectNode();
        clusterTopologyJSON.put(this.ID, cluster.getClusterId());
        clusterTopologyJSON.put(this.NAME, cluster.getClusterId());
        ObjectNode data1 = this.mapper.createObjectNode();
        clusterTopologyJSON.put(this.DATA, (JsonNode)data1);
        ArrayNode childHostArray = this.mapper.createArrayNode();
        this.updateAlertLists(cluster);
        for (Map.Entry<String, List<Cluster.Member>> physicalToMem : physicalToMember.entrySet()) {
            String hostNodeType;
            String hostStatus;
            String hostName = physicalToMem.getKey();
            double hostCpuUsage = 0.0;
            long hostMemoryUsage = 0L;
            double hostLoadAvg = 0.0;
            int hostNumThreads = 0;
            long hostSockets = 0L;
            boolean hostSevere = false;
            boolean hostError = false;
            boolean hostWarning = false;
            ObjectNode childHostObject = this.mapper.createObjectNode();
            childHostObject.put(this.ID, hostName);
            childHostObject.put(this.NAME, hostName);
            ArrayNode membersArray = this.mapper.createArrayNode();
            List<Cluster.Member> memberList = physicalToMem.getValue();
            for (Cluster.Member member : memberList) {
                ObjectNode memberJSONObj = this.mapper.createObjectNode();
                memberJSONObj.put(this.ID, member.getId());
                memberJSONObj.put(this.NAME, member.getName());
                ObjectNode memberData = this.mapper.createObjectNode();
                memberData.put("gemfireVersion", member.getGemfireVersion());
                Long currentHeap = member.getCurrentHeapSize();
                Long usedHeapSize = cluster.getUsedHeapSize();
                if (usedHeapSize > 0L) {
                    double heapUsage = currentHeap.doubleValue() / usedHeapSize.doubleValue() * 100.0;
                    memberData.put(this.MEMORY_USAGE, PulseConstants.TWO_PLACE_DECIMAL_FORMAT.format(heapUsage));
                } else {
                    memberData.put(this.MEMORY_USAGE, 0);
                }
                double currentCPUUsage = member.getCpuUsage();
                memberData.put(this.CPU_USAGE, PulseConstants.TWO_PLACE_DECIMAL_FORMAT.format(currentCPUUsage));
                memberData.put(this.REGIONS, member.getMemberRegions().size());
                memberData.put(this.HOST, member.getHost());
                if (member.getMemberPort() == null || member.getMemberPort().equals("")) {
                    memberData.put(this.PORT, "-");
                } else {
                    memberData.put(this.PORT, member.getMemberPort());
                }
                memberData.put(this.CLIENTS, member.getMemberClientsHMap().size());
                memberData.put(this.GC_PAUSES, member.getGarbageCollectionCount());
                memberData.put(this.NUM_THREADS, member.getNumThreads());
                hostCpuUsage = member.getHostCpuUsage();
                hostMemoryUsage += member.getCurrentHeapSize();
                hostLoadAvg = member.getLoadAverage();
                hostNumThreads = member.getNumThreads();
                hostSockets = member.getTotalFileDescriptorOpen();
                String memberNodeType = "";
                if (this.severeAlertList.contains(member.getName())) {
                    memberNodeType = this.getMemberNodeType(member, this.MEMBER_NODE_TYPE_SEVERE);
                    if (!hostSevere) {
                        hostSevere = true;
                    }
                } else if (this.errorAlertsList.contains(member.getName())) {
                    memberNodeType = this.getMemberNodeType(member, this.MEMBER_NODE_TYPE_ERROR);
                    if (!hostError) {
                        hostError = true;
                    }
                } else if (this.warningAlertsList.contains(member.getName())) {
                    memberNodeType = this.getMemberNodeType(member, this.MEMBER_NODE_TYPE_WARNING);
                    if (!hostWarning) {
                        hostWarning = true;
                    }
                } else {
                    memberNodeType = this.getMemberNodeType(member, this.MEMBER_NODE_TYPE_NORMAL);
                }
                memberData.put("nodeType", memberNodeType);
                memberData.put("$type", memberNodeType);
                memberData.put(this.GATEWAY_SENDER, member.getGatewaySenderList().size());
                if (member.getGatewayReceiver() != null) {
                    memberData.put(this.GATEWAY_RECEIVER, 1);
                } else {
                    memberData.put(this.GATEWAY_RECEIVER, 0);
                }
                memberJSONObj.put(this.DATA, (JsonNode)memberData);
                memberJSONObj.put(this.CHILDREN, (JsonNode)this.mapper.createArrayNode());
                membersArray.add((JsonNode)memberJSONObj);
            }
            ObjectNode data = this.mapper.createObjectNode();
            data.put(this.LOAD_AVG, PulseConstants.TWO_PLACE_DECIMAL_FORMAT.format(hostLoadAvg));
            data.put(this.SOCKETS, hostSockets);
            data.put(this.THREADS, hostNumThreads);
            data.put(this.CPU_USAGE, PulseConstants.TWO_PLACE_DECIMAL_FORMAT.format(hostCpuUsage));
            data.put(this.MEMORY_USAGE, hostMemoryUsage);
            if (hostSevere) {
                hostStatus = this.MEMBER_NODE_TYPE_SEVERE;
                hostNodeType = "hostSevereNode";
            } else if (hostError) {
                hostStatus = this.MEMBER_NODE_TYPE_ERROR;
                hostNodeType = "hostErrorNode";
            } else if (hostWarning) {
                hostStatus = this.MEMBER_NODE_TYPE_WARNING;
                hostNodeType = "hostWarningNode";
            } else {
                hostStatus = this.MEMBER_NODE_TYPE_NORMAL;
                hostNodeType = "hostNormalNode";
            }
            data.put("hostStatus", hostStatus);
            data.put("$type", hostNodeType);
            childHostObject.put(this.DATA, (JsonNode)data);
            childHostObject.put(this.CHILDREN, (JsonNode)membersArray);
            childHostArray.add((JsonNode)childHostObject);
        }
        clusterTopologyJSON.put(this.CHILDREN, (JsonNode)childHostArray);
        return clusterTopologyJSON;
    }

    private String getMemberNodeType(Cluster.Member member, String memberState) {
        String memberNodeType = "";
        if (member.isLocator() && member.isServer() && member.isManager()) {
            memberNodeType = "memberLocatorManagerServer" + memberState + "Node";
        } else if (member.isLocator() && member.isServer() && !member.isManager()) {
            memberNodeType = "memberLocatorServer" + memberState + "Node";
        } else if (member.isLocator() && !member.isServer() && member.isManager()) {
            memberNodeType = "memberLocatorManager" + memberState + "Node";
        } else if (member.isLocator() && !member.isServer() && !member.isManager()) {
            memberNodeType = "memberLocator" + memberState + "Node";
        } else if (!member.isLocator() && member.isServer() && member.isManager()) {
            memberNodeType = "memberManagerServer" + memberState + "Node";
        } else if (!member.isLocator() && member.isServer() && !member.isManager()) {
            memberNodeType = "memberServer" + memberState + "Node";
        } else if (!member.isLocator() && !member.isServer() && member.isManager()) {
            memberNodeType = "memberManager" + memberState + "Node";
        } else if (!(member.isLocator() || member.isServer() || member.isManager())) {
            memberNodeType = "member" + memberState + "Node";
        }
        return memberNodeType;
    }

    private void updateAlertLists(Cluster cluster) {
        Cluster.Alert[] alertsList;
        this.severeAlertList = new ArrayList<String>();
        this.errorAlertsList = new ArrayList<String>();
        this.warningAlertsList = new ArrayList<String>();
        for (Cluster.Alert alert : alertsList = cluster.getAlertsList()) {
            if (alert.getSeverity() == 0) {
                if (this.errorAlertsList.contains(alert.getMemberName())) {
                    this.errorAlertsList.remove(alert.getMemberName());
                } else if (this.warningAlertsList.contains(alert.getMemberName())) {
                    this.warningAlertsList.remove(alert.getMemberName());
                }
                if (this.severeAlertList.contains(alert.getMemberName())) continue;
                this.severeAlertList.add(alert.getMemberName());
                continue;
            }
            if (alert.getSeverity() == 1) {
                if (this.severeAlertList.contains(alert.getMemberName())) continue;
                if (this.warningAlertsList.contains(alert.getMemberName())) {
                    this.warningAlertsList.remove(alert.getMemberName());
                }
                if (this.errorAlertsList.contains(alert.getMemberName())) continue;
                this.errorAlertsList.add(alert.getMemberName());
                continue;
            }
            if (alert.getSeverity() != 2 || this.severeAlertList.contains(alert.getMemberName()) || this.errorAlertsList.contains(alert.getMemberName()) || this.warningAlertsList.contains(alert.getMemberName())) continue;
            this.warningAlertsList.add(alert.getMemberName());
        }
    }
}

