/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.geode.tools.pulse.internal.util.ConnectionUtil;

public class JmxManagerFinder {
    private static final short JMX_MANAGER_LOCATOR_REQUEST = 2150;
    private static final short JMX_MANAGER_LOCATOR_RESPONSE = 2151;
    private static final byte DS_FIXED_ID_SHORT = 2;
    private static final int GOSSIPVERSION = 1001;
    private static final byte STRING_BYTES = 87;
    private static final byte NULL_STRING = 69;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JmxManagerInfo askLocatorForJmxManager(InetAddress addr, int port, int timeout, boolean usessl) throws IOException {
        InetSocketAddress sockaddr = new InetSocketAddress(addr, port);
        Socket sock = ConnectionUtil.getSocketFactory(usessl).createSocket();
        try {
            String host;
            sock.connect(sockaddr, timeout);
            sock.setSoTimeout(timeout);
            DataOutputStream out = new DataOutputStream(sock.getOutputStream());
            out.writeInt(1001);
            out.writeByte(2);
            out.writeShort(2150);
            out.flush();
            DataInputStream in = new DataInputStream(sock.getInputStream());
            byte header = in.readByte();
            if (header != 2) {
                throw new IllegalStateException("Expected 2 but found " + header);
            }
            short msgType = in.readShort();
            if (msgType != 2151) {
                throw new IllegalStateException("Expected 2151 but found " + msgType);
            }
            byte hostHeader = in.readByte();
            if (hostHeader == 69) {
                host = "";
            } else if (hostHeader == 87) {
                String str;
                int len = in.readUnsignedShort();
                byte[] buf = new byte[len];
                in.readFully(buf, 0, len);
                host = str = new String(buf, 0);
            } else {
                throw new IllegalStateException("Expected 87 or 69 but found " + hostHeader);
            }
            int jmport = in.readInt();
            boolean ssl = in.readBoolean();
            if (host.equals("")) {
                jmport = 0;
            }
            JmxManagerInfo jmxManagerInfo = new JmxManagerInfo(host, jmport, ssl);
            return jmxManagerInfo;
        }
        finally {
            try {
                sock.close();
            }
            catch (Exception exception) {}
        }
    }

    public static class JmxManagerInfo {
        public final String host;
        public final int port;
        public final boolean ssl;

        JmxManagerInfo(String host, int port, boolean ssl) {
            this.host = host;
            this.port = port;
            this.ssl = ssl;
        }
    }
}

