/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataBrowser {
    private static final Logger logger = LogManager.getLogger();
    private final ResourceBundle resourceBundle = Repository.get().getResourceBundle();
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, MMM dd yyyy, HH:mm:ss z");
    private final ObjectMapper mapper = new ObjectMapper();

    public boolean addQueryInHistory(String queryText, String userId) {
        boolean operationStatus = false;
        if (StringUtils.isNotBlank((String)queryText) && StringUtils.isNotBlank((String)userId)) {
            ObjectNode queries = this.fetchAllQueriesFromFile();
            ObjectNode userQueries = (ObjectNode)queries.get(userId);
            if (userQueries == null) {
                userQueries = this.mapper.createObjectNode();
            }
            userQueries.put(Long.toString(System.currentTimeMillis()), queryText);
            queries.put(userId, (JsonNode)userQueries);
            operationStatus = this.storeQueriesInFile(queries);
        }
        return operationStatus;
    }

    public boolean deleteQueryById(String userId, String queryId) {
        ObjectNode queries;
        ObjectNode userQueries;
        boolean operationStatus = false;
        if (StringUtils.isNotBlank((String)queryId) && StringUtils.isNotBlank((String)userId) && (userQueries = (ObjectNode)(queries = this.fetchAllQueriesFromFile()).get(userId)) != null) {
            userQueries.remove(queryId);
            queries.put(userId, (JsonNode)userQueries);
            operationStatus = this.storeQueriesInFile(queries);
        }
        return operationStatus;
    }

    public ArrayNode getQueryHistoryByUserId(String userId) {
        ObjectNode queries;
        ObjectNode userQueries;
        ArrayNode queryList = this.mapper.createArrayNode();
        if (StringUtils.isNotBlank((String)userId) && (userQueries = (ObjectNode)(queries = this.fetchAllQueriesFromFile()).get(userId)) != null) {
            Iterator it = userQueries.fieldNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                ObjectNode queryItem = this.mapper.createObjectNode();
                queryItem.put("queryId", key);
                queryItem.put("queryText", userQueries.get(key).toString());
                queryItem.put("queryDateTime", this.simpleDateFormat.format(Long.valueOf(key)));
                queryList.add((JsonNode)queryItem);
            }
        }
        return queryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectNode fetchAllQueriesFromFile() {
        FileInputStream inputStream = null;
        ObjectNode queriesJSON = this.mapper.createObjectNode();
        try {
            inputStream = new FileInputStream(Repository.get().getPulseConfig().getQueryHistoryFileName());
            String inputStreamString = new Scanner((InputStream)inputStream, "UTF-8").useDelimiter("\\A").next();
            queriesJSON = this.mapper.readTree(inputStreamString);
        }
        catch (FileNotFoundException e) {
            logger.debug(this.resourceBundle.getString("LOG_MSG_DATA_BROWSER_QUERY_HISTORY_FILE_NOT_FOUND"), (Throwable)e);
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    logger.info((Object)e);
                }
            }
        }
        return queriesJSON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeQueriesInFile(ObjectNode queries) {
        boolean operationStatus = false;
        FileOutputStream fileOut = null;
        File file = new File(Repository.get().getPulseConfig().getQueryHistoryFileName());
        try {
            fileOut = new FileOutputStream(file);
            if (!file.exists()) {
                file.createNewFile();
            }
            byte[] contentInBytes = queries.toString().getBytes();
            fileOut.write(contentInBytes);
            fileOut.flush();
            operationStatus = true;
        }
        catch (FileNotFoundException e) {
            logger.debug(this.resourceBundle.getString("LOG_MSG_DATA_BROWSER_QUERY_HISTORY_FILE_NOT_FOUND"), (Object)e.getMessage());
        }
        catch (IOException e) {
            logger.info((Object)e);
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    logger.info((Object)e);
                }
            }
        }
        return operationStatus;
    }
}

