/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.security;

import java.util.ArrayList;
import java.util.Collection;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.apache.geode.tools.pulse.internal.data.PulseConstants;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class GemFireAuthentication
extends UsernamePasswordAuthenticationToken {
    private JMXConnector jmxc = null;
    private static final long serialVersionUID = 420L;

    public GemFireAuthentication(Object principal, Object credentials, Collection<GrantedAuthority> list, JMXConnector jmxc) {
        super(principal, credentials, list);
        this.jmxc = jmxc;
    }

    public static ArrayList<GrantedAuthority> populateAuthorities(JMXConnector jmxc) {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        try {
            ObjectName name = new ObjectName("GemFire:service=AccessControl,type=Distributed");
            MBeanServerConnection mbeanServer = jmxc.getMBeanServerConnection();
            for (String role : PulseConstants.PULSE_ROLES) {
                Object[] params = role.split(":");
                String[] signature = new String[]{String.class.getCanonicalName(), String.class.getCanonicalName()};
                boolean result = (Boolean)mbeanServer.invoke(name, "authorize", params, signature);
                if (!result) continue;
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_" + role));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return authorities;
    }
}

