/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.modules.session.catalina.AbstractCommitSessionValve;
import org.apache.geode.modules.session.catalina.ClientServerSessionCache;
import org.apache.geode.modules.session.catalina.DeltaSession;
import org.apache.geode.modules.session.catalina.DeltaSessionInterface;
import org.apache.geode.modules.session.catalina.DeltaSessionManagerConfiguration;
import org.apache.geode.modules.session.catalina.JvmRouteBinderValve;
import org.apache.geode.modules.session.catalina.PeerToPeerSessionCache;
import org.apache.geode.modules.session.catalina.SessionCache;
import org.apache.geode.modules.session.catalina.SessionManager;
import org.apache.geode.modules.session.catalina.internal.DeltaSessionStatistics;
import org.apache.geode.modules.util.ContextMapper;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class DeltaSessionManager<CommitSessionValveT extends AbstractCommitSessionValve<?>>
extends ManagerBase
implements Lifecycle,
PropertyChangeListener,
SessionManager,
DeltaSessionManagerConfiguration {
    static final String catalinaBaseSystemProperty = "catalina.base";
    static final String javaTempDirSystemProperty = "java.io.tmpdir";
    static final String fileSeparatorSystemProperty = "file.separator";
    private final AtomicInteger rejectedSessions;
    private int maxActiveSessions = -1;
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected String name;
    private Valve jvmRouteBinderValve;
    private CommitSessionValveT commitSessionValve;
    private SessionCache sessionCache;
    private static final String DEFAULT_REGION_NAME = "gemfire_modules_sessions";
    private static final boolean DEFAULT_ENABLE_GATEWAY_REPLICATION = false;
    private static final boolean DEFAULT_ENABLE_DEBUG_LISTENER = false;
    private static final boolean DEFAULT_ENABLE_COMMIT_VALVE = true;
    private static final boolean DEFAULT_ENABLE_COMMIT_VALVE_FAILFAST = false;
    @Deprecated
    private static final boolean DEFAULT_PREFER_DESERIALIZED_FORM = true;
    private Log LOGGER;
    protected String regionName = "gemfire_modules_sessions";
    private String regionAttributesId;
    private Boolean enableLocalCache;
    private boolean enableCommitValve = true;
    private boolean enableCommitValveFailfast = false;
    private boolean enableGatewayReplication = false;
    private boolean enableDebugListener = false;
    @Deprecated
    private boolean preferDeserializedForm = true;
    private Timer timer;
    private final Set<String> sessionsToTouch;
    private static final long TIMER_TASK_PERIOD = Long.getLong("gemfiremodules.sessionTimerTaskPeriod", 10000L);
    private static final long TIMER_TASK_DELAY = Long.getLong("gemfiremodules.sessionTimerTaskDelay", 10000L);

    public DeltaSessionManager() {
        this.rejectedSessions = new AtomicInteger(0);
        this.sessionsToTouch = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @Override
    public String getRegionName() {
        return this.regionName;
    }

    @Override
    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    @Override
    public String getRegionAttributesId() {
        if (this.regionAttributesId == null) {
            this.regionAttributesId = this.getSessionCache().getDefaultRegionAttributesId();
        }
        return this.regionAttributesId;
    }

    @Override
    public void setRegionAttributesId(String regionType) {
        this.regionAttributesId = regionType;
    }

    @Override
    public boolean getEnableLocalCache() {
        if (this.enableLocalCache == null) {
            this.enableLocalCache = this.getSessionCache().getDefaultEnableLocalCache();
        }
        return this.enableLocalCache;
    }

    @Override
    public void setEnableLocalCache(boolean enableLocalCache) {
        this.enableLocalCache = enableLocalCache;
    }

    @Override
    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    @Override
    public void setMaxActiveSessions(int maxActiveSessions) {
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = maxActiveSessions;
        this.support.firePropertyChange("maxActiveSessions", new Integer(oldMaxActiveSessions), new Integer(this.maxActiveSessions));
    }

    @Override
    public boolean getEnableGatewayDeltaReplication() {
        return false;
    }

    @Override
    public void setEnableGatewayDeltaReplication(boolean enableGatewayDeltaReplication) {
    }

    @Override
    public boolean getEnableGatewayReplication() {
        return this.enableGatewayReplication;
    }

    @Override
    public void setEnableGatewayReplication(boolean enableGatewayReplication) {
        this.enableGatewayReplication = enableGatewayReplication;
    }

    @Override
    public boolean getEnableDebugListener() {
        return this.enableDebugListener;
    }

    @Override
    public void setEnableDebugListener(boolean enableDebugListener) {
        this.enableDebugListener = enableDebugListener;
    }

    @Override
    public boolean isCommitValveEnabled() {
        return this.enableCommitValve;
    }

    @Override
    public void setEnableCommitValve(boolean enable) {
        this.enableCommitValve = enable;
    }

    @Override
    public boolean isCommitValveFailfastEnabled() {
        return this.enableCommitValveFailfast;
    }

    @Override
    public void setEnableCommitValveFailfast(boolean enable) {
        this.enableCommitValveFailfast = enable;
    }

    @Override
    public boolean isBackingCacheAvailable() {
        return this.sessionCache.isBackingCacheAvailable();
    }

    @Override
    @Deprecated
    public void setPreferDeserializedForm(boolean enable) {
        this.LOGGER.warn((Object)"Use of deprecated preferDeserializedForm property to be removed in future release.");
        if (!enable) {
            this.LOGGER.warn((Object)"Use of HttpSessionAttributeListener may result in serialized form in HttpSessionBindingEvent.");
        }
        this.preferDeserializedForm = enable;
    }

    @Override
    @Deprecated
    public boolean getPreferDeserializedForm() {
        return this.preferDeserializedForm;
    }

    @Override
    public String getStatisticsName() {
        return this.getContextName().replace("/", "");
    }

    @Override
    public Log getLogger() {
        if (this.LOGGER == null) {
            this.LOGGER = LogFactory.getLog(DeltaSessionManager.class);
        }
        return this.LOGGER;
    }

    public SessionCache getSessionCache() {
        return this.sessionCache;
    }

    public DeltaSessionStatistics getStatistics() {
        return this.getSessionCache().getStatistics();
    }

    boolean isPeerToPeer() {
        return this.getSessionCache().isPeerToPeer();
    }

    public boolean isClientServer() {
        return this.getSessionCache().isClientServer();
    }

    public Session findSession(String id) {
        DeltaSessionInterface session;
        if (id == null) {
            return null;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(String.valueOf(this) + ": Finding session " + id + " in " + this.getSessionCache().getOperatingRegionName()));
        }
        if ((session = (DeltaSessionInterface)this.getSessionCache().getSession(id)) != null && !session.getContextName().isEmpty() && !this.getContextName().equals(session.getContextName())) {
            this.getLogger().info((Object)(String.valueOf(this) + ": Session " + id + " rejected as container name and context do not match: " + this.getContextName() + " != " + session.getContextName()));
            session = null;
        }
        if (session == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(String.valueOf(this) + ": Did not find session " + id + " in " + this.getSessionCache().getOperatingRegionName()));
            }
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(String.valueOf(this) + ": Found session " + id + " in " + this.getSessionCache().getOperatingRegionName() + ": " + String.valueOf(session)));
            }
            session.setNew(false);
            if (session.getManager() == null) {
                session.setOwner(this);
                session.activate();
            }
        }
        return session;
    }

    protected void initializeSessionCache() {
        GemFireCacheImpl cache = (GemFireCacheImpl)this.getAnyCacheInstance();
        if (cache == null) {
            throw new IllegalStateException("No cache exists. Please configure either a PeerToPeerCacheLifecycleListener or ClientServerCacheLifecycleListener in the server.xml file.");
        }
        this.sessionCache = cache.isClient() ? new ClientServerSessionCache(this, (ClientCache)cache) : new PeerToPeerSessionCache(this, (Cache)cache);
        this.initSessionCache();
    }

    void initSessionCache() {
        this.sessionCache.initialize();
    }

    Cache getAnyCacheInstance() {
        return CacheFactory.getAnyInstance();
    }

    protected StandardSession getNewSession() {
        return new DeltaSession((Manager)this);
    }

    public void remove(Session session) {
        DeltaSessionInterface ds = (DeltaSessionInterface)session;
        if (ds.getExpired()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(String.valueOf(this) + ": Expired session " + session.getId() + " from " + this.getSessionCache().getOperatingRegionName()));
            }
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(String.valueOf(this) + ": Destroying session " + session.getId() + " from " + this.getSessionCache().getOperatingRegionName()));
            }
            this.getSessionCache().destroySession(session.getId());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(String.valueOf(this) + ": Destroyed session " + session.getId() + " from " + this.getSessionCache().getOperatingRegionName()));
            }
        }
    }

    public void add(Session session) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(String.valueOf(this) + ": Storing session " + session.getId() + " into " + this.getSessionCache().getOperatingRegionName()));
        }
        this.getSessionCache().putSession(session);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(String.valueOf(this) + ": Stored session " + session.getId() + " into " + this.getSessionCache().getOperatingRegionName()));
        }
        this.getSessionCache().getStatistics().incSessionsCreated();
    }

    public int getRejectedSessions() {
        return this.rejectedSessions.get();
    }

    public void setRejectedSessions(int rejectedSessions) {
        this.rejectedSessions.set(rejectedSessions);
    }

    public int getActiveSessions() {
        return this.getSessionCache().size();
    }

    public String listSessionIds() {
        StringBuilder builder = new StringBuilder();
        Iterator<String> sessionIds = this.getSessionCache().keySet().iterator();
        while (sessionIds.hasNext()) {
            builder.append(sessionIds.next());
            if (!sessionIds.hasNext()) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    void addSessionToTouch(String sessionId) {
        this.sessionsToTouch.add(sessionId);
    }

    protected Set<String> getSessionsToTouch() {
        return this.sessionsToTouch;
    }

    void removeTouchedSession(String sessionId) {
        this.sessionsToTouch.remove(sessionId);
    }

    protected void scheduleTimerTasks() {
        this.timer = new Timer("Timer for " + String.valueOf(this), true);
        this.scheduleTouchSessionsTask();
        this.scheduleDetermineMaxActiveSessionsTask();
    }

    private void scheduleTouchSessionsTask() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                HashSet<String> sessionIds = new HashSet<String>(DeltaSessionManager.this.getSessionsToTouch());
                DeltaSessionManager.this.getSessionsToTouch().clear();
                if (!sessionIds.isEmpty()) {
                    DeltaSessionManager.this.getSessionCache().touchSessions(sessionIds);
                    if (DeltaSessionManager.this.getLogger().isDebugEnabled()) {
                        DeltaSessionManager.this.getLogger().debug((Object)(String.valueOf(DeltaSessionManager.this) + ": Touched sessions: " + String.valueOf(sessionIds)));
                    }
                }
            }
        };
        this.timer.schedule(task, TIMER_TASK_DELAY, TIMER_TASK_PERIOD);
    }

    protected void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private void scheduleDetermineMaxActiveSessionsTask() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                int currentActiveSessions = 0;
                try {
                    currentActiveSessions = DeltaSessionManager.this.getSessionCache().size();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (currentActiveSessions > DeltaSessionManager.this.getMaxActive()) {
                    DeltaSessionManager.this.setMaxActive(currentActiveSessions);
                    if (DeltaSessionManager.this.getLogger().isDebugEnabled()) {
                        DeltaSessionManager.this.getLogger().debug((Object)(String.valueOf(DeltaSessionManager.this) + ": Set max active sessions: " + currentActiveSessions));
                    }
                }
            }
        };
        this.timer.schedule(task, TIMER_TASK_DELAY, TIMER_TASK_PERIOD);
    }

    public void load() throws ClassNotFoundException, IOException {
        ContextMapper.addContext(this.getContextName(), this);
    }

    public void unload() throws IOException {
        this.clearLocalCache();
        ContextMapper.removeContext(this.getContextName());
    }

    protected void registerJvmRouteBinderValve() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(String.valueOf(this) + ": Registering JVM route binder valve"));
        }
        this.jvmRouteBinderValve = new JvmRouteBinderValve();
        this.getPipeline().addValve(this.jvmRouteBinderValve);
    }

    protected abstract Pipeline getPipeline();

    protected void unregisterJvmRouteBinderValve() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(String.valueOf(this) + ": Unregistering JVM route binder valve"));
        }
        if (this.jvmRouteBinderValve != null) {
            this.getPipeline().removeValve(this.jvmRouteBinderValve);
        }
    }

    protected void registerCommitSessionValve() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(String.valueOf(this) + ": Registering CommitSessionValve"));
        }
        this.commitSessionValve = this.createCommitSessionValve();
        this.getPipeline().addValve(this.commitSessionValve);
    }

    protected abstract CommitSessionValveT createCommitSessionValve();

    protected void unregisterCommitSessionValve() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(String.valueOf(this) + ": Unregistering CommitSessionValve"));
        }
        if (this.commitSessionValve != null) {
            this.getPipeline().removeValve(this.commitSessionValve);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        if (event.getPropertyName().equals("sessionTimeout")) {
            try {
                int interval = (Integer)event.getNewValue();
                if (interval < -1) {
                    this.getLogger().warn((Object)("The configured session timeout of " + interval + " minutes is invalid. Using the original value of " + String.valueOf(event.getOldValue()) + " minutes."));
                    interval = (Integer)event.getOldValue();
                }
                this.setMaxInactiveInterval(interval == -1 ? -1 : interval * 60);
            }
            catch (NumberFormatException e) {
                this.getLogger().error((Object)sm.getString("standardManager.sessionTimeout", new Object[]{event.getNewValue().toString()}));
            }
        }
    }

    private void clearLocalCache() {
        Log logger = this.getLogger();
        boolean debugEnabled = logger.isDebugEnabled();
        if (this.getSessionCache().isClientServer()) {
            if (debugEnabled) {
                logger.debug((Object)"Locally clearing sessions.");
            }
            this.getSessionCache().getOperatingRegion().localClear();
        }
        if (debugEnabled) {
            logger.debug((Object)"Unloading complete");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[container=" + String.valueOf(this.getTheContext()) + "; regionName=" + this.regionName + "; regionAttributesId=" + this.regionAttributesId + "]";
    }

    String getContextName() {
        return this.getTheContext().getName();
    }

    public abstract Context getTheContext();

    @Override
    public abstract int getMaxInactiveInterval();

    public abstract void setMaxInactiveInterval(int var1);
}

