/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.util;

import java.util.Properties;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.partition.PartitionRegionHelper;

public class TouchPartitionedRegionEntriesFunction
implements Function,
Declarable {
    private static final long serialVersionUID = -3700389655056961153L;
    private final Cache cache;
    public static final String ID = "touch-partitioned-region-entries";

    public TouchPartitionedRegionEntriesFunction() {
        this(CacheFactory.getAnyInstance());
    }

    public TouchPartitionedRegionEntriesFunction(Cache cache) {
        this.cache = cache;
    }

    public void execute(FunctionContext context) {
        RegionFunctionContext rfc = (RegionFunctionContext)context;
        Set keys = rfc.getFilter();
        Region primaryDataSet = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rfc);
        if (this.cache.getLogger().fineEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Function ").append(ID).append(" received request to touch ").append(primaryDataSet.getFullPath()).append("->").append(keys);
            this.cache.getLogger().fine(builder.toString());
        }
        for (String key : keys) {
            primaryDataSet.get((Object)key);
        }
        context.getResultSender().lastResult((Object)true);
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public boolean isHA() {
        return false;
    }

    public boolean hasResult() {
        return true;
    }

    public void init(Properties properties) {
    }
}

