/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.gatewaydelta;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.Instantiator;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.modules.gatewaydelta.AbstractGatewayDeltaEvent;

public class GatewayDeltaCreateEvent
extends AbstractGatewayDeltaEvent {
    private byte[] gatewayDelta;

    public GatewayDeltaCreateEvent() {
    }

    public GatewayDeltaCreateEvent(String regionName, String key, byte[] gatewayDelta) {
        super(regionName, key);
        this.gatewayDelta = gatewayDelta;
    }

    public byte[] getGatewayDelta() {
        return this.gatewayDelta;
    }

    @Override
    public void apply(Cache cache) {
        Region region = this.getRegion(cache);
        region.put((Object)this.key, (Object)CachedDeserializableFactory.create((byte[])this.gatewayDelta), (Object)true);
        if (cache.getLogger().fineEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Applied ").append(this);
            cache.getLogger().fine(builder.toString());
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.gatewayDelta = DataSerializer.readByteArray((DataInput)in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeByteArray((byte[])this.gatewayDelta, (DataOutput)out);
    }

    public static void registerInstantiator(int id) {
        Instantiator.register((Instantiator)new Instantiator(GatewayDeltaCreateEvent.class, id){

            public DataSerializable newInstance() {
                return new GatewayDeltaCreateEvent();
            }
        });
    }

    public String toString() {
        return "GatewayDeltaCreateEvent[" + "regionName=" + this.regionName + "; key=" + this.key + "; gatewayDelta=" + this.gatewayDelta + "]";
    }
}

