/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.control.ResourceManager;

public class ResourceManagerValidator {
    private static final Pattern DIGIT_PATTERN = Pattern.compile("(\\d+|[^\\d]+)");

    public static void validateJavaStartupParameters(GemFireCache cache) {
        String vmVendor;
        ResourceManager rm = cache.getResourceManager();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = runtimeBean.getInputArguments();
        if (cache.getLogger().fineEnabled()) {
            cache.getLogger().fine("Full input java arguments: " + inputArguments);
        }
        if ((vmVendor = runtimeBean.getVmVendor()).startsWith("Sun") || vmVendor.startsWith("Apple")) {
            ResourceManagerValidator.validateSunArguments(cache, rm, inputArguments);
        } else if (vmVendor.startsWith("IBM") || vmVendor.startsWith("BEA")) {
            // empty if block
        }
    }

    private static void validateSunArguments(GemFireCache cache, ResourceManager rm, List<String> inputArguments) {
        String dashXms = null;
        String dashXmx = null;
        String useCMS = null;
        String cmsIOF = null;
        for (String argument : inputArguments) {
            if (argument.startsWith("-Xms")) {
                dashXms = argument;
                continue;
            }
            if (argument.startsWith("-Xmx")) {
                dashXmx = argument;
                continue;
            }
            if (argument.equals("-XX:+UseConcMarkSweepGC")) {
                useCMS = argument;
                continue;
            }
            if (!argument.startsWith("-XX:CMSInitiatingOccupancyFraction")) continue;
            cmsIOF = argument;
        }
        if (cache.getLogger().fineEnabled()) {
            String builder = "Relevant input java arguments: dashXms=" + dashXms + "; dashXmx=" + dashXmx + "; useCMS=" + useCMS + "; cmsIOF=" + cmsIOF;
            cache.getLogger().fine(builder);
        }
        ResourceManagerValidator.validateJavaHeapParameters(cache, dashXms, dashXmx);
        ResourceManagerValidator.verifyCMSGC(cache, useCMS);
        ResourceManagerValidator.verifyCMSInitiatingOccupancyFraction(cache, rm, cmsIOF);
    }

    private static void validateJavaHeapParameters(GemFireCache cache, String dashXms, String dashXmx) {
        if (dashXms == null) {
            cache.getLogger().warning("Setting the initial size of the heap (configured using -Xms) is recommended so that GemFire cache eviction is optimal");
        } else if (dashXmx == null) {
            cache.getLogger().warning("Setting the maximum size of the heap (configured using -Xmx) is recommended so that GemFire cache eviction is optimal");
        } else {
            List<String> dashXmxList;
            String dashXmxStr;
            List<String> dashXmsList = ResourceManagerValidator.splitAtDigits(dashXms);
            String dashXmsStr = dashXmsList.get(1);
            if (!dashXmsStr.equals(dashXmxStr = (dashXmxList = ResourceManagerValidator.splitAtDigits(dashXmx)).get(1))) {
                String builder = "Setting the initial (" + dashXmsStr + dashXmsList.get(2) + ") and maximum (" + dashXmxStr + dashXmxList.get(2) + ") sizes of the heap the same is recommended so that GemFire cache eviction is optimal";
                cache.getLogger().warning(builder);
            }
        }
    }

    private static boolean isCMSAvailable() {
        return SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13);
    }

    private static void verifyCMSGC(GemFireCache cache, String useCMS) {
        if (useCMS == null && ResourceManagerValidator.isCMSAvailable()) {
            cache.getLogger().warning("Using the concurrent garbage collector (configured using -XX:+UseConcMarkSweepGC) is recommended so that GemFire cache eviction is optimal");
        }
    }

    private static void verifyCMSInitiatingOccupancyFraction(GemFireCache cache, ResourceManager rm, String cmsIOF) {
        if (!ResourceManagerValidator.isCMSAvailable()) {
            return;
        }
        if (cmsIOF == null) {
            cache.getLogger().warning("Setting the CMS initiating occupancy fraction (configured using -XX:CMSInitiatingOccupancyFraction=N) is recommended so that GemFire cache eviction is optimal");
        } else {
            float currentCriticalHeapPercentage;
            int cmsIOFVal = Integer.parseInt(cmsIOF.split("=")[1]);
            float currentEvictionHeapPercentage = rm.getEvictionHeapPercentage();
            if (currentEvictionHeapPercentage != 0.0f && currentEvictionHeapPercentage < (float)cmsIOFVal) {
                cache.getLogger().warning("Setting the CMS initiating occupancy fraction (" + cmsIOFVal + ") less than the eviction heap percentage (" + currentEvictionHeapPercentage + ") is recommended so that GemFire cache eviction is optimal");
            }
            if ((currentCriticalHeapPercentage = rm.getCriticalHeapPercentage()) != 0.0f && currentCriticalHeapPercentage < (float)cmsIOFVal) {
                cache.getLogger().warning("Setting the CMS initiating occupancy fraction (" + cmsIOFVal + ") less than the critical heap percentage (" + currentCriticalHeapPercentage + ") is recommended so that GemFire cache eviction is optimal");
            }
        }
    }

    private static List<String> splitAtDigits(String input) {
        Matcher matcher = DIGIT_PATTERN.matcher(input);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            result.add(matcher.group());
        }
        return result;
    }

    private ResourceManagerValidator() {
    }
}

