/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.util;

import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugCacheListener
extends CacheListenerAdapter
implements Declarable {
    private static final Logger logger = LoggerFactory.getLogger(DebugCacheListener.class);

    public void afterCreate(EntryEvent event) {
        this.log(event);
    }

    public void afterUpdate(EntryEvent event) {
        this.log(event);
    }

    public void afterInvalidate(EntryEvent event) {
        this.log(event);
    }

    public void afterDestroy(EntryEvent event) {
        this.log(event);
    }

    private void log(EntryEvent event) {
        StringBuilder builder = new StringBuilder();
        builder.append("DebugCacheListener: Received ").append(event.getOperation()).append(" for key=").append(event.getKey());
        if (event.getNewValue() != null) {
            builder.append("; value=").append(event.getNewValue());
        }
        logger.info(builder.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof DebugCacheListener;
    }

    public int hashCode() {
        return DebugCacheListener.class.hashCode();
    }
}

