/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import org.apache.geode.DataSerializable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.locks.DistributedMemberLock;
import org.apache.geode.internal.cache.CacheFactoryStatics;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionFactory;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.xmlcache.CacheXmlGenerator;
import org.apache.geode.internal.cache.xmlcache.RegionAttributesCreation;
import org.apache.geode.management.internal.security.ResourcePermissions;
import org.apache.geode.modules.util.RegionConfiguration;
import org.apache.geode.modules.util.RegionConfigurationCacheListener;
import org.apache.geode.modules.util.RegionHelper;
import org.apache.geode.modules.util.RegionStatus;
import org.apache.geode.security.ResourcePermission;

public class CreateRegionFunction
implements Function,
Declarable,
DataSerializable {
    private static final long serialVersionUID = -9210226844302128969L;
    public static final String ID = "create-region-function";
    private static final boolean DUMP_SESSION_CACHE_XML = Boolean.getBoolean("gemfiremodules.dumpSessionCacheXml");
    static final String REGION_CONFIGURATION_METADATA_REGION = "__regionConfigurationMetadata";
    private final InternalCache cache = CacheFactoryStatics.getAnyInstance();
    private final Region<String, RegionConfiguration> regionConfigurationsRegion = this.createRegionConfigurationMetadataRegion();

    public void execute(FunctionContext context) {
        RegionConfiguration configuration = (RegionConfiguration)context.getArguments();
        if (this.cache.getLogger().fineEnabled()) {
            this.cache.getLogger().fine("Function create-region-function received request: " + configuration);
        }
        RegionStatus status = this.createOrRetrieveRegion(configuration);
        if (DUMP_SESSION_CACHE_XML) {
            this.writeCacheXml();
        }
        context.getResultSender().lastResult((Object)status);
    }

    public Collection<ResourcePermission> getRequiredPermissions(String regionName) {
        return Collections.singletonList(ResourcePermissions.DATA_MANAGE);
    }

    private RegionStatus createOrRetrieveRegion(RegionConfiguration configuration) {
        RegionStatus status;
        Region region;
        String regionName = configuration.getRegionName();
        if (this.cache.getLogger().fineEnabled()) {
            this.cache.getLogger().fine("Function create-region-function retrieving region named: " + regionName);
        }
        if ((region = this.cache.getRegion(regionName)) == null) {
            status = this.createRegion(configuration);
        } else {
            status = RegionStatus.VALID;
            try {
                RegionAttributes existingRegionAttributes = region.getAttributes();
                RegionAttributes requestedRegionAttributes = RegionHelper.getRegionAttributes((Cache)this.cache, configuration);
                this.compareRegionAttributes(existingRegionAttributes, requestedRegionAttributes);
            }
            catch (Exception e) {
                if (!e.getMessage().equals("CacheListeners are not the same")) {
                    this.cache.getLogger().warning((Throwable)e);
                }
                status = RegionStatus.INVALID;
            }
        }
        return status;
    }

    void compareRegionAttributes(RegionAttributes existingRegionAttributes, RegionAttributes requestedRegionAttributes) {
        EvictionAttributes evictionAttributes = existingRegionAttributes.getEvictionAttributes();
        RegionAttributesCreation existingRACreation = new RegionAttributesCreation(existingRegionAttributes, false);
        RegionAttributesCreation requestedAttributesCreation = new RegionAttributesCreation(requestedRegionAttributes, false);
        if ((existingRegionAttributes.getDataPolicy().withPersistence() || evictionAttributes != null && evictionAttributes.getAction() == EvictionAction.OVERFLOW_TO_DISK) && requestedRegionAttributes.getDiskStoreName() == null && existingRegionAttributes.getDiskStoreName() == null) {
            existingRACreation.setDiskStoreName("DEFAULT");
            requestedAttributesCreation.setDiskStoreName("DEFAULT");
        }
        existingRACreation.sameAs((RegionAttributes)requestedAttributesCreation);
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return true;
    }

    public boolean hasResult() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionStatus createRegion(RegionConfiguration configuration) {
        RegionStatus status;
        DistributedMemberLock dml = this.getDistributedLock();
        if (this.cache.getLogger().fineEnabled()) {
            this.cache.getLogger().fine(this + ": Attempting to lock " + dml);
        }
        long start = 0L;
        try {
            String regionName;
            Region region;
            if (this.cache.getLogger().fineEnabled()) {
                start = System.currentTimeMillis();
            }
            dml.lockInterruptibly();
            if (this.cache.getLogger().fineEnabled()) {
                long end = System.currentTimeMillis();
                this.cache.getLogger().fine(this + ": Obtained lock on " + dml + " in " + (end - start) + " ms");
            }
            if ((region = this.cache.getRegion(regionName = configuration.getRegionName())) == null) {
                this.regionConfigurationsRegion.put((Object)regionName, (Object)configuration);
                region = this.cache.getRegion(regionName);
                if (region == null) {
                    status = RegionStatus.INVALID;
                } else {
                    if (region instanceof PartitionedRegion) {
                        PartitionedRegion pr = (PartitionedRegion)region;
                        this.createBuckets(pr);
                    }
                    status = RegionStatus.VALID;
                }
            } else {
                status = RegionStatus.VALID;
                try {
                    RegionHelper.validateRegion((Cache)this.cache, configuration, region);
                }
                catch (Exception e) {
                    if (!e.getMessage().equals("CacheListeners are not the same")) {
                        this.cache.getLogger().warning((Throwable)e);
                    }
                    status = RegionStatus.INVALID;
                }
            }
        }
        catch (Exception e) {
            String builder = this + ": Caught Exception attempting to create region named " + configuration.getRegionName() + ":";
            this.cache.getLogger().warning(builder, (Throwable)e);
            status = RegionStatus.INVALID;
        }
        finally {
            try {
                dml.unlock();
            }
            catch (Exception exception) {}
        }
        return status;
    }

    private void createBuckets(PartitionedRegion region) {
        PartitionRegionHelper.assignBucketsToPartitions((Region)region);
    }

    private Region<String, RegionConfiguration> createRegionConfigurationMetadataRegion() {
        Region region = this.cache.getRegion(REGION_CONFIGURATION_METADATA_REGION);
        if (region != null) {
            return region;
        }
        InternalRegionFactory regionFactory = this.cache.createInternalRegionFactory(RegionShortcut.REPLICATE);
        regionFactory.addCacheListener((CacheListener)new RegionConfigurationCacheListener());
        regionFactory.setInternalRegion(true);
        return regionFactory.create(REGION_CONFIGURATION_METADATA_REGION);
    }

    private void writeCacheXml() {
        File file = new File("cache-" + System.currentTimeMillis() + ".xml");
        try {
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(file), true);
            CacheXmlGenerator.generate((Cache)this.cache, (PrintWriter)pw);
            pw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private DistributedMemberLock getDistributedLock() {
        String dlsName = this.regionConfigurationsRegion.getName();
        DistributedLockService lockService = this.initializeDistributedLockService(dlsName);
        String lockToken = dlsName + "_token";
        return new DistributedMemberLock(lockService, (Serializable)((Object)lockToken));
    }

    private DistributedLockService initializeDistributedLockService(String dlsName) {
        DistributedLockService lockService = DistributedLockService.getServiceNamed((String)dlsName);
        if (lockService == null) {
            lockService = DistributedLockService.create((String)dlsName, (DistributedSystem)this.cache.getDistributedSystem());
        }
        return lockService;
    }

    public void toData(DataOutput out) {
    }

    public void fromData(DataInput in) {
    }
}

