/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina.internal;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class DeltaSessionStatistics {
    private static final String typeName = "SessionStatistics";
    private static final StatisticsType type;
    private static final String SESSIONS_CREATED = "sessionsCreated";
    private static final String SESSIONS_INVALIDATED = "sessionsInvalidated";
    private static final String SESSIONS_EXPIRED = "sessionsExpired";
    private static final int sessionsCreatedId;
    private static final int sessionsInvalidatedId;
    private static final int sessionsExpiredId;
    private final Statistics stats;

    public DeltaSessionStatistics(StatisticsFactory factory, String applicationName) {
        this.stats = factory.createAtomicStatistics(type, "SessionStatistics_" + applicationName);
    }

    public void close() {
        this.stats.close();
    }

    public long getSessionsCreated() {
        return this.stats.getLong(sessionsCreatedId);
    }

    public void incSessionsCreated() {
        this.stats.incLong(sessionsCreatedId, 1L);
    }

    public long getSessionsInvalidated() {
        return this.stats.getLong(sessionsInvalidatedId);
    }

    public void incSessionsInvalidated() {
        this.stats.incLong(sessionsInvalidatedId, 1L);
    }

    public long getSessionsExpired() {
        return this.stats.getLong(sessionsExpiredId);
    }

    public void incSessionsExpired() {
        this.stats.incLong(sessionsExpiredId, 1L);
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        type = f.createType(typeName, typeName, new StatisticDescriptor[]{f.createLongCounter(SESSIONS_CREATED, "The number of sessions created", "operations"), f.createLongCounter(SESSIONS_INVALIDATED, "The number of sessions invalidated by invoking invalidate", "operations"), f.createLongCounter(SESSIONS_EXPIRED, "The number of sessions invalidated by timeout", "operations")});
        sessionsCreatedId = type.nameToId(SESSIONS_CREATED);
        sessionsInvalidatedId = type.nameToId(SESSIONS_INVALIDATED);
        sessionsExpiredId = type.nameToId(SESSIONS_EXPIRED);
    }
}

