/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.modules.gatewaydelta.AbstractGatewayDeltaEvent;
import org.apache.geode.modules.session.catalina.DeltaSessionInterface;
import org.apache.geode.modules.session.catalina.internal.DeltaSessionAttributeEvent;

public class DeltaSessionAttributeEventBatch
extends AbstractGatewayDeltaEvent {
    private List<DeltaSessionAttributeEvent> eventQueue;

    List<DeltaSessionAttributeEvent> getEventQueue() {
        return this.eventQueue;
    }

    public DeltaSessionAttributeEventBatch() {
    }

    public DeltaSessionAttributeEventBatch(String regionName, String sessionId, List<DeltaSessionAttributeEvent> eventQueue) {
        super(regionName, sessionId);
        this.eventQueue = eventQueue;
    }

    @Override
    public void apply(Cache cache) {
        Region region = this.getRegion(cache);
        DeltaSessionInterface session = (DeltaSessionInterface)region.get((Object)this.key);
        if (session == null) {
            String builder = "Session " + this.key + " was not found while attempting to apply " + this;
            cache.getLogger().warning(builder);
        } else {
            session.applyAttributeEvents((Region<String, DeltaSessionInterface>)region, this.eventQueue);
            if (cache.getLogger().fineEnabled()) {
                cache.getLogger().fine("Applied " + this);
            }
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.eventQueue = DataSerializer.readArrayList((DataInput)in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeArrayList((ArrayList)((ArrayList)this.eventQueue), (DataOutput)out);
    }

    public String toString() {
        return "DeltaSessionAttributeEventBatch[regionName=" + this.regionName + "; sessionId=" + this.key + "; numberOfEvents=" + this.eventQueue.size() + "]";
    }
}

