/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina;

import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.geode.modules.session.catalina.DeltaSessionManager;
import org.apache.geode.modules.session.catalina.Tomcat6CommitSessionValve;

public class Tomcat6DeltaSessionManager
extends DeltaSessionManager<Tomcat6CommitSessionValve> {
    private LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);

    public void start() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + ": Starting"));
        }
        if (this.started.get()) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        try {
            this.init();
        }
        catch (Throwable t) {
            this.getLogger().error((Object)t.getMessage(), t);
        }
        this.registerJvmRouteBinderValve();
        if (this.isCommitValveEnabled()) {
            this.registerCommitSessionValve();
        }
        this.initializeSessionCache();
        this.scheduleTimerTasks();
        this.started.set(true);
    }

    public void stop() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + ": Stopping"));
        }
        this.started.set(false);
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.random = null;
        if (this.initialized) {
            this.destroy();
        }
        this.getSessionsToTouch().clear();
        this.cancelTimer();
        this.unregisterJvmRouteBinderValve();
        if (this.isCommitValveEnabled()) {
            this.unregisterCommitSessionValve();
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    protected Tomcat6CommitSessionValve createCommitSessionValve() {
        return new Tomcat6CommitSessionValve();
    }
}

