/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.geode.DataSerializable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.management.internal.security.ResourcePermissions;
import org.apache.geode.modules.util.CreateRegionFunction;
import org.apache.geode.modules.util.RegionSizeFunction;
import org.apache.geode.modules.util.TouchPartitionedRegionEntriesFunction;
import org.apache.geode.modules.util.TouchReplicatedRegionEntriesFunction;
import org.apache.geode.security.ResourcePermission;

public class BootstrappingFunction
implements Function,
MembershipListener,
DataSerializable {
    private static final long serialVersionUID = 1856043174458190605L;
    public static final String ID = "bootstrapping-function";
    private static final ReentrantLock registerFunctionLock = new ReentrantLock();
    private static final int TIME_TO_WAIT_FOR_CACHE = Integer.getInteger("gemfiremodules.timeToWaitForCache", 30000);

    public void execute(FunctionContext context) {
        Cache cache = this.verifyCacheExists();
        this.registerAsMembershipListener(cache);
        if (!this.isLocator(cache)) {
            this.registerFunctions();
        }
        context.getResultSender().lastResult((Object)Boolean.TRUE);
    }

    protected boolean isLocator(Cache cache) {
        DistributedSystem system = cache.getDistributedSystem();
        InternalDistributedMember member = (InternalDistributedMember)system.getDistributedMember();
        return member.getVmKind() == 11;
    }

    protected Cache verifyCacheExists() {
        Cache cache = null;
        for (int timeToWait = 0; timeToWait < TIME_TO_WAIT_FOR_CACHE; timeToWait += 250) {
            try {
                cache = CacheFactory.getAnyInstance();
                break;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(250L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        if (cache == null) {
            cache = new CacheFactory().create();
        }
        return cache;
    }

    public Collection<ResourcePermission> getRequiredPermissions(String regionName) {
        return Collections.singletonList(ResourcePermissions.CLUSTER_MANAGE);
    }

    private void registerAsMembershipListener(Cache cache) {
        DistributionManager dm = ((InternalDistributedSystem)cache.getDistributedSystem()).getDistributionManager();
        dm.addMembershipListener((MembershipListener)this);
    }

    protected void registerFunctions() {
        registerFunctionLock.lock();
        try {
            if (!FunctionService.isRegistered((String)"create-region-function")) {
                FunctionService.registerFunction((Function)new CreateRegionFunction());
            }
            if (!FunctionService.isRegistered((String)"touch-partitioned-region-entries")) {
                FunctionService.registerFunction((Function)new TouchPartitionedRegionEntriesFunction());
            }
            if (!FunctionService.isRegistered((String)"touch-replicated-region-entries")) {
                FunctionService.registerFunction((Function)new TouchReplicatedRegionEntriesFunction());
            }
            if (!FunctionService.isRegistered((String)"region-size-function")) {
                FunctionService.registerFunction((Function)new RegionSizeFunction());
            }
        }
        finally {
            registerFunctionLock.unlock();
        }
    }

    private void bootstrapMember(InternalDistributedMember member) {
        Cache cache = CacheFactory.getAnyInstance();
        Execution execution = FunctionService.onMember((DistributedMember)member);
        ResultCollector collector = execution.execute((Function)this);
        try {
            collector.getResult();
        }
        catch (Exception e) {
            cache.getLogger().warning("Caught unexpected exception:", (Throwable)e);
        }
    }

    public String getId() {
        return ID;
    }

    public boolean hasResult() {
        return true;
    }

    public boolean isHA() {
        return false;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public int hashCode() {
        return ID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && obj instanceof BootstrappingFunction;
    }

    public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
    }

    public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
        this.bootstrapMember(id);
    }

    public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
    }

    public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> internalDistributedMembers, List<InternalDistributedMember> internalDistributedMembers2) {
    }

    public void toData(DataOutput out) throws IOException {
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
    }
}

