/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.gatewaydelta;

import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.InterestPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.SerializedCacheValue;
import org.apache.geode.cache.SubscriptionAttributes;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.modules.gatewaydelta.GatewayDelta;
import org.apache.geode.modules.gatewaydelta.GatewayDeltaCreateEvent;
import org.apache.geode.modules.gatewaydelta.GatewayDeltaDestroyEvent;
import org.apache.geode.modules.gatewaydelta.GatewayDeltaEventApplicationCacheListener;

public class GatewayDeltaForwarderCacheListener
extends CacheListenerAdapter<String, GatewayDelta>
implements Declarable {
    private final Cache cache;
    private LocalRegion gatewayDeltaRegion;

    public GatewayDeltaForwarderCacheListener() {
        this(CacheFactory.getAnyInstance());
    }

    public GatewayDeltaForwarderCacheListener(Cache cache) {
        this.cache = cache;
    }

    public void afterCreate(EntryEvent<String, GatewayDelta> event) {
        if (event.getCallbackArgument() == null) {
            if (this.cache.getLogger().fineEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("GatewayDeltaForwarderCacheListener: Received create event for ").append((String)event.getKey()).append("->").append(event.getNewValue()).append(" that originated in the local site. Sending it to the remote site.");
                this.cache.getLogger().fine(builder.toString());
            }
            String regionName = event.getRegion().getFullPath();
            String sessionId = (String)event.getKey();
            SerializedCacheValue scv = event.getSerializedNewValue();
            if (scv == null) {
                this.getGatewayDeltaRegion().put((Object)sessionId, (Object)new GatewayDeltaCreateEvent(regionName, sessionId, EntryEventImpl.serialize((Object)event.getNewValue())));
            } else {
                System.out.println("GatewayDeltaForwarderCacheListener event.getSerializedNewValue().getSerializedValue(): " + event.getSerializedNewValue().getSerializedValue());
                this.getGatewayDeltaRegion().put((Object)sessionId, (Object)new GatewayDeltaCreateEvent(regionName, sessionId, scv.getSerializedValue()));
            }
        } else if (this.cache.getLogger().fineEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("GatewayDeltaForwarderCacheListener: Received create event for ").append((String)event.getKey()).append("->").append(event.getNewValue()).append(" that originated in the remote site.");
            this.cache.getLogger().fine(builder.toString());
        }
    }

    public void afterUpdate(EntryEvent<String, GatewayDelta> event) {
        if (event.getCallbackArgument() == null) {
            if (this.cache.getLogger().fineEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("GatewayDeltaForwarderCacheListener: Received update event for ").append((String)event.getKey()).append("->").append(event.getNewValue()).append(" that originated in the local site. Sending it to the remote site.");
                this.cache.getLogger().fine(builder.toString());
            }
            GatewayDelta session = (GatewayDelta)event.getNewValue();
            this.getGatewayDeltaRegion().put(event.getKey(), (Object)session.getCurrentGatewayDeltaEvent());
            session.setCurrentGatewayDeltaEvent(null);
        } else if (this.cache.getLogger().fineEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("GatewayDeltaForwarderCacheListener: Received update event for ").append((String)event.getKey()).append("->").append(event.getNewValue()).append(" that originated in the remote site.");
            this.cache.getLogger().fine(builder.toString());
        }
    }

    public void afterDestroy(EntryEvent<String, GatewayDelta> event) {
        if (event.getCallbackArgument() != null) {
            if (this.cache.getLogger().fineEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("GatewayDeltaForwarderCacheListener: Received destroy event for ").append((String)event.getKey()).append("->").append(event.getNewValue()).append(" that originated in the local site. Sending it to the remote site.");
                this.cache.getLogger().fine(builder.toString());
            }
            String sessionId = (String)event.getKey();
            this.getGatewayDeltaRegion().put((Object)sessionId, (Object)new GatewayDeltaDestroyEvent(event.getRegion().getFullPath(), sessionId));
        } else if (this.cache.getLogger().fineEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("GatewayDeltaForwarderCacheListener: Received destroy event for session ").append((String)event.getKey()).append(" that either expired or originated in the remote site.");
            this.cache.getLogger().fine(builder.toString());
        }
    }

    public void init(Properties p) {
    }

    private LocalRegion getGatewayDeltaRegion() {
        if (this.gatewayDeltaRegion == null) {
            this.gatewayDeltaRegion = this.createOrRetrieveGatewayDeltaRegion();
        }
        return this.gatewayDeltaRegion;
    }

    private LocalRegion createOrRetrieveGatewayDeltaRegion() {
        Region region = this.cache.getRegion("__gatewayDelta");
        if (region == null) {
            region = new RegionFactory().setScope(Scope.LOCAL).setDataPolicy(DataPolicy.EMPTY).setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL)).addCacheListener((CacheListener)new GatewayDeltaEventApplicationCacheListener()).create("__gatewayDelta");
        }
        if (this.cache.getLogger().fineEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("GatewayDeltaForwarderCacheListener: Created gateway delta region: ").append(region);
            this.cache.getLogger().fine(builder.toString());
        }
        return (LocalRegion)region;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && obj instanceof GatewayDeltaForwarderCacheListener;
    }
}

