/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Manager;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.geode.modules.session.catalina.DeltaSessionFacade;
import org.apache.geode.modules.session.catalina.DeltaSessionManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class CommitSessionValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(CommitSessionValve.class);
    protected static final String info = "org.apache.geode.modules.session.catalina.CommitSessionValve/1.0";

    public CommitSessionValve() {
        log.info((Object)"Initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Manager manager = request.getContext().getManager();
        DeltaSessionFacade session = null;
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            if (manager instanceof DeltaSessionManager) {
                session = (DeltaSessionFacade)request.getSession(false);
                DeltaSessionManager dsm = (DeltaSessionManager)manager;
                if (session != null) {
                    if (session.isValid()) {
                        dsm.removeTouchedSession(session.getId());
                        session.commit();
                        if (dsm.getTheContext().getLogger().isDebugEnabled()) {
                            dsm.getTheContext().getLogger().debug((Object)((Object)((Object)session) + ": Committed."));
                        }
                    } else if (dsm.getTheContext().getLogger().isDebugEnabled()) {
                        dsm.getTheContext().getLogger().debug((Object)((Object)((Object)session) + ": Not valid so not committing."));
                    }
                }
            }
        }
    }
}

