/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.geode.modules.session.catalina.DeltaSessionManager;

public class JvmRouteBinderValve
extends ValveBase {
    protected static final String info = "org.apache.geode.modules.session.JvmRouteBinderValve/1.0";

    public void invoke(Request request, Response response) throws IOException, ServletException {
        DeltaSessionManager absMgr;
        String localJvmRoute;
        Manager manager = request.getContext().getManager();
        if (manager instanceof DeltaSessionManager && (localJvmRoute = (absMgr = (DeltaSessionManager)manager).getJvmRoute()) != null) {
            this.handlePossibleFailover(request, absMgr, localJvmRoute);
        }
        this.getNext().invoke(request, response);
    }

    private void handlePossibleFailover(Request request, DeltaSessionManager manager, String localJvmRoute) {
        String sessionId = request.getRequestedSessionId();
        if (sessionId != null) {
            String requestJvmRoute = null;
            int index = sessionId.indexOf(".");
            if (index > 0) {
                requestJvmRoute = sessionId.substring(index + 1, sessionId.length());
            }
            if (requestJvmRoute != null && !requestJvmRoute.equals(localJvmRoute)) {
                if (manager.getLogger().isDebugEnabled()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append((Object)this).append(": Handling failover of session ").append(sessionId).append(" from ").append(requestJvmRoute).append(" to ").append(localJvmRoute);
                    manager.getLogger().debug((Object)builder.toString());
                }
                Session session = null;
                try {
                    session = manager.findSession(sessionId);
                }
                catch (IOException e) {
                    StringBuilder builder = new StringBuilder();
                    builder.append((Object)this).append(": Caught exception attempting to find session ").append(sessionId).append(" in ").append(manager);
                    manager.getLogger().warn((Object)builder.toString(), (Throwable)e);
                }
                if (session == null) {
                    StringBuilder builder = new StringBuilder();
                    builder.append((Object)this).append(": Did not find session ").append(sessionId).append(" to failover in ").append(manager);
                    manager.getLogger().warn((Object)builder.toString());
                } else {
                    String baseSessionId = sessionId.substring(0, index);
                    String newSessionId = baseSessionId + "." + localJvmRoute;
                    session.setId(newSessionId);
                    request.changeSessionId(newSessionId);
                }
            }
        }
    }
}

